/*
 * Decompiled with CFR 0.152.
 */
package org.rarefiedredis.redis;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rarefiedredis.redis.AbstractRedisMock;
import org.rarefiedredis.redis.ArgException;
import org.rarefiedredis.redis.BitArgException;
import org.rarefiedredis.redis.DiscardWithoutMultiException;
import org.rarefiedredis.redis.ExecWithoutMultiException;
import org.rarefiedredis.redis.IRedisClient;
import org.rarefiedredis.redis.IndexOutOfRangeException;
import org.rarefiedredis.redis.NoKeyException;
import org.rarefiedredis.redis.NotFloatException;
import org.rarefiedredis.redis.NotFloatHashException;
import org.rarefiedredis.redis.NotIntegerException;
import org.rarefiedredis.redis.NotIntegerHashException;
import org.rarefiedredis.redis.RedisMock;
import org.rarefiedredis.redis.RedisMockMulti;
import org.rarefiedredis.redis.ScanResult;
import org.rarefiedredis.redis.SyntaxErrorException;
import org.rarefiedredis.redis.WrongTypeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RedisMockClient
extends AbstractRedisMock {
    private RedisMock redisMock;

    public RedisMockClient(RedisMock redisMock) {
        this.redisMock = redisMock;
    }

    @Override
    public IRedisClient createClient() {
        return new RedisMockClient(this.redisMock);
    }

    @Override
    public boolean modified(Integer hashCode, String command, List<Object> args) {
        return this.redisMock.modified(hashCode, command, args);
    }

    @Override
    public Long del(String ... keys) {
        return this.redisMock.del(keys);
    }

    @Override
    public Boolean exists(String key) {
        return this.redisMock.exists(key);
    }

    @Override
    public Boolean expire(String key, int seconds) {
        return this.redisMock.expire(key, seconds);
    }

    @Override
    public Boolean expireat(String key, long timestamp) {
        return this.redisMock.expireat(key, timestamp);
    }

    @Override
    public Boolean persist(String key) {
        return this.redisMock.persist(key);
    }

    @Override
    public Boolean pexpire(String key, long milliseconds) {
        return this.redisMock.pexpire(key, milliseconds);
    }

    @Override
    public Boolean pexpireat(String key, long timestamp) {
        return this.redisMock.pexpireat(key, timestamp);
    }

    @Override
    public String type(String key) {
        return this.redisMock.type(key);
    }

    @Override
    public Long append(String key, String value) throws WrongTypeException {
        return this.redisMock.append(key, value);
    }

    @Override
    public Long bitcount(String key, long ... options) throws WrongTypeException {
        return this.redisMock.bitcount(key, options);
    }

    @Override
    public Long bitop(String operation, String destkey, String ... keys) throws WrongTypeException {
        return this.redisMock.bitop(operation, destkey, keys);
    }

    @Override
    public Long bitpos(String key, long bit, long ... options) throws WrongTypeException, BitArgException {
        return this.redisMock.bitpos(key, bit, options);
    }

    @Override
    public Long decr(String key) throws WrongTypeException, NotIntegerException {
        return this.redisMock.decr(key);
    }

    @Override
    public Long decrby(String key, long decrement) throws WrongTypeException, NotIntegerException {
        return this.redisMock.decrby(key, decrement);
    }

    @Override
    public String get(String key) throws WrongTypeException {
        return this.redisMock.get(key);
    }

    @Override
    public Boolean getbit(String key, long offset) throws WrongTypeException {
        return this.redisMock.getbit(key, offset);
    }

    @Override
    public String getrange(String key, long start, long end) throws WrongTypeException {
        return this.redisMock.getrange(key, start, end);
    }

    @Override
    public String getset(String key, String value) throws WrongTypeException {
        return this.redisMock.getset(key, value);
    }

    @Override
    public Long incr(String key) throws WrongTypeException, NotIntegerException {
        return this.redisMock.incr(key);
    }

    @Override
    public Long incrby(String key, long increment) throws WrongTypeException, NotIntegerException {
        return this.redisMock.incrby(key, increment);
    }

    @Override
    public String incrbyfloat(String key, double increment) throws WrongTypeException, NotFloatException {
        return this.redisMock.incrbyfloat(key, increment);
    }

    @Override
    public synchronized String[] mget(String ... keys) {
        return this.redisMock.mget(keys);
    }

    @Override
    public String mset(String ... keyvalues) throws ArgException {
        return this.redisMock.mset(keyvalues);
    }

    @Override
    public Boolean msetnx(String ... keyvalues) throws ArgException {
        return this.redisMock.msetnx(keyvalues);
    }

    @Override
    public String psetex(String key, long milliseconds, String value) {
        return this.redisMock.psetex(key, milliseconds, value);
    }

    @Override
    public String set(String key, String value, String ... options) throws SyntaxErrorException {
        return this.redisMock.set(key, value, options);
    }

    @Override
    public Long setbit(String key, long offset, boolean value) throws WrongTypeException {
        return this.redisMock.setbit(key, offset, value);
    }

    @Override
    public String setex(String key, int seconds, String value) {
        return this.redisMock.setex(key, seconds, value);
    }

    @Override
    public Long setnx(String key, String value) {
        return this.redisMock.setnx(key, value);
    }

    @Override
    public Long setrange(String key, long offset, String value) throws WrongTypeException {
        return this.redisMock.setrange(key, offset, value);
    }

    @Override
    public Long strlen(String key) throws WrongTypeException {
        return this.redisMock.strlen(key);
    }

    @Override
    public String lindex(String key, long index) throws WrongTypeException {
        return this.redisMock.lindex(key, index);
    }

    @Override
    public Long linsert(String key, String before_after, String pivot, String value) throws WrongTypeException {
        return this.redisMock.linsert(key, before_after, pivot, value);
    }

    @Override
    public Long llen(String key) throws WrongTypeException {
        return this.redisMock.llen(key);
    }

    @Override
    public String lpop(String key) throws WrongTypeException {
        return this.redisMock.lpop(key);
    }

    @Override
    public Long lpush(String key, String element, String ... elements) throws WrongTypeException {
        return this.redisMock.lpush(key, element, elements);
    }

    @Override
    public Long lpushx(String key, String element) throws WrongTypeException {
        return this.redisMock.lpushx(key, element);
    }

    @Override
    public List<String> lrange(String key, long start, long end) throws WrongTypeException {
        return this.redisMock.lrange(key, start, end);
    }

    @Override
    public Long lrem(String key, long count, String element) throws WrongTypeException {
        return this.redisMock.lrem(key, count, element);
    }

    @Override
    public String lset(String key, long index, String element) throws WrongTypeException, NoKeyException, IndexOutOfRangeException {
        return this.redisMock.lset(key, index, element);
    }

    @Override
    public String ltrim(String key, long start, long end) throws WrongTypeException {
        return this.redisMock.ltrim(key, start, end);
    }

    @Override
    public String rpop(String key) throws WrongTypeException {
        return this.redisMock.rpop(key);
    }

    @Override
    public String rpoplpush(String source, String dest) throws WrongTypeException {
        return this.redisMock.rpoplpush(source, dest);
    }

    @Override
    public Long rpush(String key, String element, String ... elements) throws WrongTypeException {
        return this.redisMock.rpush(key, element, elements);
    }

    @Override
    public Long rpushx(String key, String element) throws WrongTypeException {
        return this.redisMock.rpushx(key, element);
    }

    @Override
    public Long sadd(String key, String member, String ... members) throws WrongTypeException {
        return this.redisMock.sadd(key, member, members);
    }

    @Override
    public Long scard(String key) throws WrongTypeException {
        return this.redisMock.scard(key);
    }

    @Override
    public Set<String> sdiff(String key, String ... keys) throws WrongTypeException {
        return this.redisMock.sdiff(key, keys);
    }

    @Override
    public Long sdiffstore(String destination, String key, String ... keys) throws WrongTypeException {
        return this.redisMock.sdiffstore(destination, key, keys);
    }

    @Override
    public Set<String> sinter(String key, String ... keys) throws WrongTypeException {
        return this.redisMock.sinter(key, keys);
    }

    @Override
    public Long sinterstore(String destination, String key, String ... keys) throws WrongTypeException {
        return this.redisMock.sinterstore(destination, key, keys);
    }

    @Override
    public Boolean sismember(String key, String member) throws WrongTypeException {
        return this.redisMock.sismember(key, member);
    }

    @Override
    public Set<String> smembers(String key) throws WrongTypeException {
        return this.redisMock.smembers(key);
    }

    @Override
    public Boolean smove(String source, String dest, String member) throws WrongTypeException {
        return this.redisMock.smove(source, dest, member);
    }

    @Override
    public String spop(String key) throws WrongTypeException {
        return this.redisMock.spop(key);
    }

    @Override
    public String srandmember(String key) throws WrongTypeException {
        return this.redisMock.srandmember(key);
    }

    @Override
    public List<String> srandmember(String key, long count) throws WrongTypeException {
        return this.redisMock.srandmember(key, count);
    }

    @Override
    public Long srem(String key, String member, String ... members) throws WrongTypeException {
        return this.redisMock.srem(key, member, members);
    }

    @Override
    public Set<String> sunion(String key, String ... keys) throws WrongTypeException {
        return this.redisMock.sunion(key, keys);
    }

    @Override
    public Long sunionstore(String destination, String key, String ... keys) throws WrongTypeException {
        return this.redisMock.sunionstore(destination, key, keys);
    }

    @Override
    public ScanResult<Set<String>> sscan(String key, long cursor, String ... options) throws WrongTypeException {
        return this.redisMock.sscan(key, cursor, options);
    }

    @Override
    public Long hdel(String key, String field, String ... fields) throws WrongTypeException {
        return this.redisMock.hdel(key, field, fields);
    }

    @Override
    public Boolean hexists(String key, String field) throws WrongTypeException {
        return this.redisMock.hexists(key, field);
    }

    @Override
    public String hget(String key, String field) throws WrongTypeException {
        return this.redisMock.hget(key, field);
    }

    @Override
    public Map<String, String> hgetall(String key) throws WrongTypeException {
        return this.redisMock.hgetall(key);
    }

    @Override
    public Long hincrby(String key, String field, long increment) throws WrongTypeException, NotIntegerHashException {
        return this.redisMock.hincrby(key, field, increment);
    }

    @Override
    public String hincrbyfloat(String key, String field, double increment) throws WrongTypeException, NotFloatHashException {
        return this.redisMock.hincrbyfloat(key, field, increment);
    }

    @Override
    public Set<String> hkeys(String key) throws WrongTypeException {
        return this.redisMock.hkeys(key);
    }

    @Override
    public Long hlen(String key) throws WrongTypeException {
        return this.redisMock.hlen(key);
    }

    @Override
    public List<String> hmget(String key, String field, String ... fields) throws WrongTypeException {
        return this.redisMock.hmget(key, field, fields);
    }

    @Override
    public String hmset(String key, String field, String value, String ... fieldsvalues) throws WrongTypeException, ArgException {
        return this.redisMock.hmset(key, field, value, fieldsvalues);
    }

    @Override
    public Boolean hset(String key, String field, String value) throws WrongTypeException {
        return this.redisMock.hset(key, field, value);
    }

    @Override
    public Boolean hsetnx(String key, String field, String value) throws WrongTypeException {
        return this.redisMock.hsetnx(key, field, value);
    }

    @Override
    public Long hstrlen(String key, String field) throws WrongTypeException {
        return this.redisMock.hstrlen(key, field);
    }

    @Override
    public List<String> hvals(String key) throws WrongTypeException {
        return this.redisMock.hvals(key);
    }

    @Override
    public ScanResult<Map<String, String>> hscan(String key, long cursor, String ... options) throws WrongTypeException {
        return this.redisMock.hscan(key, cursor, options);
    }

    @Override
    public String discard() throws DiscardWithoutMultiException {
        return this.redisMock.discard();
    }

    @Override
    public List<Object> exec() throws ExecWithoutMultiException {
        return this.redisMock.exec();
    }

    @Override
    public IRedisClient multi() {
        return new RedisMockMulti(this);
    }

    @Override
    public String unwatch() {
        return this.redisMock.unwatch(this.hashCode());
    }

    @Override
    public String watch(String key) {
        return this.redisMock.watch(key, this.hashCode());
    }
}

