/*
 * Decompiled with CFR 0.152.
 */
package org.rarefiedredis.redis.adapter.jedis;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rarefiedredis.redis.ExecWithoutMultiException;
import org.rarefiedredis.redis.IRedisClient;
import org.rarefiedredis.redis.adapter.jedis.AbstractJedisIRedisClient;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.exceptions.JedisDataException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JedisIRedisClientMulti
extends AbstractJedisIRedisClient {
    private final JedisPool pool;
    private Jedis jedis;
    private Transaction transaction;

    public JedisIRedisClientMulti(JedisPool pool) {
        this.pool = pool;
        this.jedis = null;
        this.initialize();
    }

    public JedisIRedisClientMulti(Jedis jedis) {
        this.pool = null;
        this.jedis = jedis;
        this.initialize();
    }

    private void initialize() {
        block3: {
            Jedis jedis = null;
            try {
                if (this.pool != null) {
                    this.jedis = this.pool.getResource();
                }
                jedis = this.jedis;
                this.transaction = jedis.multi();
            }
            catch (Exception e) {
                this.transaction = null;
                if (this.pool == null || jedis == null) break block3;
                jedis.close();
            }
        }
    }

    @Override
    public IRedisClient createClient() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object command(String name, Object ... args) {
        try {
            Class[] parameterTypes = new Class[args.length];
            for (int idx = 0; idx < args.length; ++idx) {
                if (args[idx] == null) continue;
                parameterTypes[idx] = args[idx].getClass();
                if (parameterTypes[idx].equals(Integer.class)) {
                    parameterTypes[idx] = Integer.TYPE;
                }
                if (parameterTypes[idx].equals(Long.class)) {
                    parameterTypes[idx] = Long.TYPE;
                }
                if (parameterTypes[idx].equals(Double.class)) {
                    parameterTypes[idx] = Double.TYPE;
                }
                if (!parameterTypes[idx].equals(HashMap.class)) continue;
                parameterTypes[idx] = Map.class;
            }
            JedisIRedisClientMulti jedisIRedisClientMulti = this;
            synchronized (jedisIRedisClientMulti) {
                if (this.transaction != null) {
                    this.transaction.getClass().getDeclaredMethod(name, parameterTypes).invoke((Object)this.transaction, args);
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public synchronized String discard() {
        String reply = this.transaction.discard();
        this.transaction = null;
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> exec() throws ExecWithoutMultiException {
        List ret = null;
        JedisIRedisClientMulti jedisIRedisClientMulti = this;
        synchronized (jedisIRedisClientMulti) {
            if (this.transaction == null) {
                throw new ExecWithoutMultiException();
            }
            try {
                ret = this.transaction.exec();
            }
            catch (JedisDataException jedisDataException) {
            }
            finally {
                if (this.pool != null && this.jedis != null) {
                    this.jedis.close();
                }
            }
        }
        return ret;
    }

    @Override
    public IRedisClient multi() {
        return this;
    }
}

