/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.richfaces.component.AbstractInplaceInput;
import org.richfaces.component.InplaceComponent;
import org.richfaces.component.InplaceState;
import org.richfaces.renderkit.ComponentAttribute;
import org.richfaces.renderkit.InputRendererBase;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.util.HtmlDimensions;

@ResourceDependencies(value={@ResourceDependency(library="org.richfaces", name="ajax.reslib"), @ResourceDependency(library="org.richfaces", name="base-component.reslib"), @ResourceDependency(name="richfaces-event.js"), @ResourceDependency(library="org.richfaces", name="inputBase.js"), @ResourceDependency(library="org.richfaces", name="inplaceBase.js"), @ResourceDependency(library="org.richfaces", name="inplaceInput.js"), @ResourceDependency(library="org.richfaces", name="inplaceInput.ecss")})
public class InplaceInputRendererBase
extends InputRendererBase {
    protected static final Map<String, ComponentAttribute> INPLACE_INPUT_HANDLER_ATTRIBUTES = Collections.unmodifiableMap(ComponentAttribute.createMap(new ComponentAttribute("onclick").setEventNames("inputclick").setComponentAttributeName("oninputclick"), new ComponentAttribute("ondblclick").setEventNames("inputdblclick").setComponentAttributeName("oninputdblclick"), new ComponentAttribute("onmousedown").setEventNames("inputmousedown").setComponentAttributeName("oninputmousedown"), new ComponentAttribute("onmouseup").setEventNames("inputmouseup").setComponentAttributeName("oninputmouseup"), new ComponentAttribute("onmouseover").setEventNames("inputmouseover").setComponentAttributeName("oninputmouseover"), new ComponentAttribute("onmousemove").setEventNames("inputmousemove").setComponentAttributeName("oninputmousemove"), new ComponentAttribute("onmouseout").setEventNames("inputmouseout").setComponentAttributeName("oninputmouseout"), new ComponentAttribute("onkeypress").setEventNames("inputkeypress").setComponentAttributeName("oninputkeypress"), new ComponentAttribute("onkeydown").setEventNames("inputkeydown").setComponentAttributeName("oninputkeydown"), new ComponentAttribute("onkeyup").setEventNames("inputkeyup").setComponentAttributeName("oninputkeyup"), new ComponentAttribute("onselect").setEventNames("inputselect").setComponentAttributeName("oninputselect")));

    public void renderInputHandlers(FacesContext facesContext, UIComponent component) throws IOException {
        RenderKitUtils.renderPassThroughAttributesOptimized(facesContext, component, INPLACE_INPUT_HANDLER_ATTRIBUTES);
    }

    public InplaceState getInplaceState(UIComponent component) {
        InplaceState state = ((InplaceComponent)component).getState();
        if (state == null) {
            state = InplaceState.ready;
        }
        return state;
    }

    public String getValue(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractInplaceInput inplaceInput = (AbstractInplaceInput)component;
        String value = this.getInputValue(facesContext, (UIComponent)inplaceInput);
        if (!inplaceInput.isDisabled() && (value == null || "".equals(value))) {
            value = inplaceInput.getDefaultLabel();
        }
        return value;
    }

    public String getStateStyleClass(UIComponent component, InplaceState inplaceState) {
        InplaceComponent inplaceComponent = (InplaceComponent)component;
        String style = this.getReadyStateCss(inplaceComponent);
        if (!inplaceComponent.isDisabled()) {
            switch (inplaceState) {
                case edit: {
                    style = this.concatClasses(style, this.getEditStateCss(inplaceComponent));
                    break;
                }
                case changed: {
                    style = this.concatClasses(style, this.getChangedStateCss(inplaceComponent));
                    break;
                }
            }
        } else {
            style = this.concatClasses(style, this.getDisableStateCss(inplaceComponent));
        }
        return style;
    }

    public String getContainerStyleClasses(UIComponent component) {
        InplaceComponent inplaceComponent = (InplaceComponent)component;
        String style = "rf-ii";
        if (inplaceComponent.isDisabled()) {
            style = this.concatClasses(style, this.getDisableStateCss(inplaceComponent));
        }
        return style;
    }

    public String getEditStyleClass(UIComponent component, InplaceState inplaceState) {
        InplaceComponent inplaceComponent = (InplaceComponent)component;
        return InplaceState.edit != inplaceState ? this.concatClasses(this.getEditCss(inplaceComponent), this.getNoneCss(inplaceComponent)) : this.getEditCss(inplaceComponent);
    }

    public String getReadyStateCss(InplaceComponent component) {
        return "rf-ii";
    }

    public String getEditStateCss(InplaceComponent component) {
        String css = component.getActiveClass();
        return this.concatClasses("rf-ii-act", css);
    }

    public String getChangedStateCss(InplaceComponent component) {
        String css = component.getChangedClass();
        return this.concatClasses("rf-ii-chng", css);
    }

    public String getDisableStateCss(InplaceComponent component) {
        String css = component.getDisabledClass();
        return this.concatClasses("rf-ii-dis", css);
    }

    public String getEditCss(InplaceComponent component) {
        return "rf-ii-fld-cntr";
    }

    public String getNoneCss(InplaceComponent component) {
        return "rf-ii-none";
    }

    protected String getInputWidth(UIComponent component) {
        String value = ((AbstractInplaceInput)component).getInputWidth();
        if (value == null || "".equals(value)) {
            value = "100%";
        }
        return HtmlDimensions.formatSize((String)value);
    }

    protected String getEditEvent(UIComponent component) {
        String value = ((InplaceComponent)component).getEditEvent();
        if (value == null || "".equals(value)) {
            value = "click";
        }
        return value;
    }
}

