/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows.support.v4;

import android.content.Context;
import android.support.v4.content.AsyncTaskLoader;
import java.util.concurrent.Callable;
import org.robolectric.Robolectric;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.SimpleFuture;

@Implements(value=AsyncTaskLoader.class)
public class ShadowAsyncTaskLoader<D> {
    @RealObject
    private AsyncTaskLoader<D> realLoader;
    private SimpleFuture<D> future;

    public void __constructor__(Context context) {
        BackgroundWorker worker = new BackgroundWorker();
        this.future = new SimpleFuture<D>(worker){

            protected void done() {
                try {
                    final Object result = this.get();
                    Robolectric.getForegroundThreadScheduler().post(new Runnable(){

                        @Override
                        public void run() {
                            ShadowAsyncTaskLoader.this.realLoader.deliverResult(result);
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
    }

    @Implementation
    public void onForceLoad() {
        Robolectric.getBackgroundThreadScheduler().post(new Runnable(){

            @Override
            public void run() {
                ShadowAsyncTaskLoader.this.future.run();
            }
        });
    }

    private final class BackgroundWorker
    implements Callable<D> {
        private BackgroundWorker() {
        }

        @Override
        public D call() throws Exception {
            return ShadowAsyncTaskLoader.this.realLoader.loadInBackground();
        }
    }
}

