/*
 * Decompiled with CFR 0.152.
 */
package scala.io;

import java.io.PrintStream;
import java.rmi.RemoteException;
import java.util.NoSuchElementException;
import scala.BufferedIterator;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Iterator;
import scala.Iterator$class;
import scala.List;
import scala.Option;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.Seq;
import scala.StringBuilder;
import scala.Tuple2;
import scala.collection.mutable.Buffer;
import scala.io.Position$;
import scala.io.Source$;
import scala.runtime.BoxedArray;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Source
implements Iterator<Character>,
ScalaObject {
    private int tabinc = 4;
    private int nwarnings = 0;
    private int nerrors = 0;
    private String descr = "";
    private char ch;
    private int pos = 0;
    private int ccol = 1;
    private int cline = 1;

    public Source() {
        Iterator$class.$init$(this);
    }

    public abstract Source reset();

    public void reportWarning(int pos, String msg, PrintStream out) {
        this.nwarnings_$eq(this.nwarnings() + 1);
        this.report(pos, new StringBuilder().append((Object)"warning! ").append((Object)msg).toString(), out);
    }

    public void reportWarning(int pos, String msg) {
        this.reportWarning(pos, msg, System.out);
    }

    public void report(int pos, String msg, PrintStream out) {
        StringBuilder buf = new StringBuilder();
        int line = Position$.MODULE$.line(pos);
        int col = Position$.MODULE$.column(pos);
        buf.append(new StringBuilder().append((Object)this.descr()).append((Object)":").append(BoxesRunTime.boxToInteger(line)).append((Object)":").append(BoxesRunTime.boxToInteger(col)).append((Object)": ").append((Object)msg).toString());
        buf.append(this.getLine(line));
        for (int i = 1; i < col; ++i) {
            buf.append(' ');
        }
        buf.append('^');
        out.println(buf.toString());
    }

    public void reportError(int pos, String msg, PrintStream out) {
        this.nerrors_$eq(this.nerrors() + 1);
        this.report(pos, msg, out);
    }

    public void reportError(int pos, String msg) {
        this.reportError(pos, msg, System.out);
    }

    @Override
    public char next() {
        this.ch_$eq(BoxesRunTime.unboxToChar(this.iter().next()));
        this.pos_$eq(Position$.MODULE$.encode(this.cline(), this.ccol()));
        char c = this.ch();
        switch (c) {
            default: {
                this.ccol_$eq(this.ccol() + 1);
                break;
            }
            case '\t': {
                this.ccol_$eq(this.ccol() + this.tabinc());
                break;
            }
            case '\n': {
                this.ccol_$eq(1);
                this.cline_$eq(this.cline() + 1);
            }
        }
        return this.ch();
    }

    @Override
    public boolean hasNext() {
        return this.iter().hasNext();
    }

    public Iterator<String> getLines() {
        return new $anon$6(this);
    }

    public String getLine(int line) {
        if (line < 1) {
            throw new IllegalArgumentException(((Object)BoxesRunTime.boxToInteger(line)).toString());
        }
        StringBuilder buf = new StringBuilder();
        Source it = this.reset();
        int i = 0;
        while (it.hasNext() && i < line - 1) {
            if ('\n' != it.next()) continue;
            ++i;
        }
        if (it.hasNext()) {
            char ch = it.next();
            while (it.hasNext() && '\n' != ch) {
                buf.append(ch);
                ch = it.next();
            }
            if ('\n' != ch) {
                buf.append(ch);
            }
            String res = buf.toString();
            buf.setLength(0);
            return res;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"line ").append(BoxesRunTime.boxToInteger(line)).append((Object)" does not exist").toString());
    }

    public void tabinc_$eq(int x$1) {
        this.tabinc = x$1;
    }

    public int tabinc() {
        return this.tabinc;
    }

    public void nwarnings_$eq(int x$1) {
        this.nwarnings = x$1;
    }

    public int nwarnings() {
        return this.nwarnings;
    }

    public void nerrors_$eq(int x$1) {
        this.nerrors = x$1;
    }

    public int nerrors() {
        return this.nerrors;
    }

    public void descr_$eq(String x$1) {
        this.descr = x$1;
    }

    public String descr() {
        return this.descr;
    }

    public void ch_$eq(char x$1) {
        this.ch = x$1;
    }

    public char ch() {
        return this.ch;
    }

    public void pos_$eq(int x$1) {
        this.pos = x$1;
    }

    public int pos() {
        return this.pos;
    }

    public void ccol_$eq(int x$1) {
        this.ccol = x$1;
    }

    public int ccol() {
        return this.ccol;
    }

    public void cline_$eq(int x$1) {
        this.cline = x$1;
    }

    public int cline() {
        return this.cline;
    }

    public abstract Iterator<Character> iter();

    @Override
    public int $tag() throws RemoteException {
        return ScalaObject$class.$tag(this);
    }

    @Override
    public String toString() {
        return Iterator$class.toString(this);
    }

    @Override
    public StringBuilder addString(StringBuilder x$1, String x$2, String x$3, String x$4) {
        return Iterator$class.addString(this, x$1, x$2, x$3, x$4);
    }

    @Override
    public String mkString() {
        return Iterator$class.mkString(this);
    }

    @Override
    public String mkString(String x$1) {
        return Iterator$class.mkString(this, x$1);
    }

    @Override
    public String mkString(String x$1, String x$2, String x$3) {
        return Iterator$class.mkString(this, x$1, x$2, x$3);
    }

    @Override
    public Seq collect() {
        return Iterator$class.collect(this);
    }

    @Override
    public List toList() {
        return Iterator$class.toList(this);
    }

    @Override
    public void copyToBuffer(Buffer x$1) {
        Iterator$class.copyToBuffer(this, x$1);
    }

    public void readInto(BoxedArray x$1) {
        Iterator$class.readInto(this, x$1);
    }

    public void readInto(BoxedArray x$1, int x$2) {
        Iterator$class.readInto(this, x$1, x$2);
    }

    public void readInto(BoxedArray x$1, int x$2, int x$3) {
        Iterator$class.readInto(this, x$1, x$2, x$3);
    }

    public void copyToArray(BoxedArray x$1, int x$2) {
        Iterator$class.copyToArray(this, x$1, x$2);
    }

    @Override
    public Tuple2 duplicate() {
        return Iterator$class.duplicate(this);
    }

    @Override
    public Object counted() {
        return Iterator$class.counted(this);
    }

    @Override
    public BufferedIterator buffered() {
        return Iterator$class.buffered(this);
    }

    @Override
    public Object reduceRight(Function2 x$1) throws UnsupportedOperationException {
        return Iterator$class.reduceRight(this, x$1);
    }

    @Override
    public Object reduceLeft(Function2 x$1) throws UnsupportedOperationException {
        return Iterator$class.reduceLeft(this, x$1);
    }

    @Override
    public Object $colon$bslash(Object x$1, Function2 x$2) {
        return Iterator$class.$colon$bslash(this, x$1, x$2);
    }

    @Override
    public Object $div$colon(Object x$1, Function2 x$2) {
        return Iterator$class.$div$colon(this, x$1, x$2);
    }

    @Override
    public Object foldRight(Object x$1, Function2 x$2) {
        return Iterator$class.foldRight(this, x$1, x$2);
    }

    @Override
    public Object foldLeft(Object x$1, Function2 x$2) {
        return Iterator$class.foldLeft(this, x$1, x$2);
    }

    @Override
    public int indexOf(Object x$1) {
        return Iterator$class.indexOf(this, x$1);
    }

    @Override
    public int findIndexOf(Function1 x$1) {
        return Iterator$class.findIndexOf(this, x$1);
    }

    @Override
    public Option find(Function1 x$1) {
        return Iterator$class.find(this, x$1);
    }

    @Override
    public boolean contains(Object x$1) {
        return Iterator$class.contains(this, x$1);
    }

    @Override
    public boolean exists(Function1 x$1) {
        return Iterator$class.exists(this, x$1);
    }

    @Override
    public boolean forall(Function1 x$1) {
        return Iterator$class.forall(this, x$1);
    }

    @Override
    public void foreach(Function1 x$1) {
        Iterator$class.foreach(this, x$1);
    }

    @Override
    public Object zipWithIndex() {
        return Iterator$class.zipWithIndex(this);
    }

    @Override
    public Object zip(Iterator x$1) {
        return Iterator$class.zip(this, x$1);
    }

    @Override
    public Iterator dropWhile(Function1 x$1) {
        return Iterator$class.dropWhile(this, x$1);
    }

    @Override
    public Iterator takeWhile(Function1 x$1) {
        return Iterator$class.takeWhile(this, x$1);
    }

    @Override
    public Iterator filter(Function1 x$1) {
        return Iterator$class.filter(this, x$1);
    }

    @Override
    public Iterator flatMap(Function1 x$1) throws NoSuchElementException {
        return Iterator$class.flatMap(this, x$1);
    }

    @Override
    public Object $plus$plus(Function0 x$1) {
        return Iterator$class.$plus$plus(this, x$1);
    }

    @Override
    public Object append(Iterator x$1) {
        return Iterator$class.append(this, x$1);
    }

    @Override
    public Iterator map(Function1 x$1) {
        return Iterator$class.map(this, x$1);
    }

    @Override
    public Iterator slice(int x$1, int x$2) {
        return Iterator$class.slice(this, x$1, x$2);
    }

    @Override
    public Iterator drop(int x$1) {
        return Iterator$class.drop(this, x$1);
    }

    @Override
    public Iterator take(int x$1) throws NoSuchElementException {
        return Iterator$class.take(this, x$1);
    }
}

