/*
 * Decompiled with CFR 0.152.
 */
package org_scala_tools_maven;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org_scala_tools_maven.ScalaMojoSupport;
import org_scala_tools_maven_executions.MainHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScalaSourceMojoSupport
extends ScalaMojoSupport {
    protected boolean sendJavaToScalac = true;
    protected Set<String> includes = new HashSet<String>();
    protected Set<String> excludes = new HashSet<String>();
    private boolean _filterPrinted = false;

    protected abstract List<File> getSourceDirectories() throws Exception;

    protected List<File> findSourceWithFilters() throws Exception {
        List<File> sourceRootDirs = this.getSourceDirectories();
        ArrayList<File> sourceFiles = new ArrayList<File>();
        if (this.includes.isEmpty()) {
            this.includes.add("**/*.scala");
            if (this.sendJavaToScalac && this.isJavaSupportedByCompiler()) {
                this.includes.add("**/*.java");
            }
        }
        if (!this._filterPrinted && this.getLog().isInfoEnabled()) {
            StringBuilder builder = new StringBuilder("includes = [");
            for (String include : this.includes) {
                builder.append(include).append(",");
            }
            builder.append("]");
            this.getLog().info((CharSequence)builder.toString());
            builder = new StringBuilder("excludes = [");
            for (String exclude : this.excludes) {
                builder.append(exclude).append(",");
            }
            builder.append("]");
            this.getLog().info((CharSequence)builder.toString());
            this._filterPrinted = true;
        }
        for (File dir : sourceRootDirs) {
            String[] tmpFiles;
            for (String tmpLocalFile : tmpFiles = MainHelper.findFiles(dir, this.includes.toArray(new String[this.includes.size()]), this.excludes.toArray(new String[this.excludes.size()]))) {
                File tmpAbsFile = this.normalize(new File(dir, tmpLocalFile));
                sourceFiles.add(tmpAbsFile);
            }
        }
        Collections.sort(sourceFiles);
        return sourceFiles;
    }

    protected File normalize(File f) {
        try {
            f = f.getCanonicalFile();
        }
        catch (IOException exc) {
            f = f.getAbsoluteFile();
        }
        return f;
    }

    protected List<File> normalize(List<String> compileSourceRootsList) {
        ArrayList<File> newCompileSourceRootsList = new ArrayList<File>();
        if (compileSourceRootsList != null) {
            for (String srcDir : compileSourceRootsList) {
                File srcDirFile = this.normalize(new File(srcDir));
                if (newCompileSourceRootsList.contains(srcDirFile) || !srcDirFile.exists()) continue;
                newCompileSourceRootsList.add(srcDirFile);
            }
        }
        return newCompileSourceRootsList;
    }
}

