/*
 * Decompiled with CFR 0.152.
 */
package breeze.linalg;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.operators.BinaryUpdateOp;
import breeze.linalg.operators.CanAxpy;
import breeze.linalg.operators.OpSet;
import breeze.math.Semiring;
import breeze.util.ArrayUtil$;
import scala.Predef$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.ScalaRunTime$;

public abstract class DenseVector_GenericOps$class {
    public static BinaryUpdateOp canSet_DV_Generic(DenseVector$ $this) {
        return new BinaryUpdateOp<DenseVector<V>, V, OpSet>($this){

            public void apply(DenseVector<V> a, V b) {
                Object ad = a.data();
                if (a.stride() == 1) {
                    ArrayUtil$.MODULE$.fill(ad, a.offset(), a.length(), b);
                    return;
                }
                int aoff = a.offset();
                for (int i = 0; i < a.length(); ++i) {
                    ScalaRunTime$.MODULE$.array_update(ad, aoff, b);
                    aoff += a.stride();
                }
            }
        };
    }

    public static BinaryUpdateOp canSet_DV_DV_Generic(DenseVector$ $this) {
        return new BinaryUpdateOp<DenseVector<V>, DenseVector<V>, OpSet>($this){

            public void apply(DenseVector<V> a, DenseVector<V> b) {
                boolean bl = b.length() == a.length();
                Predef$ predef$ = Predef$.MODULE$;
                if (!bl) {
                    throw new IllegalArgumentException(new StringBuilder().append((Object)"requirement failed: ").append((Object)"Vectors must be the same length!").toString());
                }
                if (a.stride() == b.stride() && a.stride() == 1) {
                    System.arraycopy(b.data(), b.offset(), a.data(), a.offset(), a.length());
                    return;
                }
                Object ad = a.data();
                Object bd = b.data();
                int aoff = a.offset();
                int boff = b.offset();
                for (int i = 0; i < a.length(); ++i) {
                    ScalaRunTime$.MODULE$.array_update(ad, aoff, ScalaRunTime$.MODULE$.array_apply(bd, boff));
                    aoff += a.stride();
                    boff += b.stride();
                }
            }
        };
    }

    public static CanAxpy canGaxpy(DenseVector$ $this, Semiring evidence$12) {
        return new CanAxpy<V, DenseVector<V>, DenseVector<V>>($this, evidence$12){
            private final Semiring<V> ring;

            private Semiring<V> ring() {
                return this.ring;
            }

            public void apply(V s, DenseVector<V> b, DenseVector<V> a) {
                boolean bl = b.length() == a.length();
                Predef$ predef$ = Predef$.MODULE$;
                if (!bl) {
                    throw new IllegalArgumentException(new StringBuilder().append((Object)"requirement failed: ").append((Object)"Vectors must be the same length!").toString());
                }
                Object ad = a.data();
                Object bd = b.data();
                int aoff = a.offset();
                int boff = b.offset();
                for (int i = 0; i < a.length(); ++i) {
                    ScalaRunTime$.MODULE$.array_update(ad, aoff, this.ring().$plus(ScalaRunTime$.MODULE$.array_apply(ad, aoff), this.ring().$times(s, ScalaRunTime$.MODULE$.array_apply(bd, boff))));
                    aoff += a.stride();
                    boff += b.stride();
                }
            }
            {
                Predef$ predef$ = Predef$.MODULE$;
                this.ring = evidence$12$1;
            }
        };
    }

    public static void $init$(DenseVector$ $this) {
    }
}

