/*
 * Decompiled with CFR 0.152.
 */
package breeze.linalg;

import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.DenseVector$mcD$sp;
import breeze.linalg.LinearAlgebra;
import breeze.linalg.LinearAlgebra$;
import breeze.linalg.Matrix;
import breeze.linalg.MatrixConstructors$class;
import breeze.linalg.MatrixEmptyException;
import breeze.linalg.MatrixNotSquareException;
import breeze.linalg.MatrixNotSymmetricException;
import breeze.linalg.MatrixSingularException;
import breeze.linalg.NotConvergedException;
import breeze.linalg.NotConvergedException$;
import breeze.linalg.NotConvergedException$Iterations$;
import breeze.linalg.NumericOps;
import breeze.linalg.NumericOps$Arrays$;
import breeze.linalg.Vector;
import breeze.linalg.operators.BinaryOp;
import breeze.linalg.operators.CanTranspose;
import breeze.linalg.package$;
import breeze.linalg.support.CanNorm;
import breeze.linalg.support.CanNorm$;
import breeze.linalg.support.NativeBlasDeferrer$;
import breeze.math.Ring;
import breeze.math.Ring$;
import breeze.math.Semiring;
import breeze.math.Semiring$;
import breeze.storage.DefaultArrayValue;
import org.jblas.NativeBlas;
import org.netlib.lapack.LAPACK;
import org.netlib.util.intW;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.immutable.Range;
import scala.collection.immutable.Range$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;

public abstract class LinearAlgebra$class {
    private static void requireNonEmptyMatrix(LinearAlgebra $this, Matrix mat) {
        if (mat.cols() == 0 || mat.rows() == 0) {
            throw new MatrixEmptyException();
        }
    }

    public static void breeze$linalg$LinearAlgebra$$requireSquareMatrix(LinearAlgebra $this, Matrix mat) {
        if (mat.rows() != mat.cols()) {
            throw new MatrixNotSquareException();
        }
    }

    private static void requireSymmetricMatrix(LinearAlgebra $this, Matrix mat) {
        LinearAlgebra$class.breeze$linalg$LinearAlgebra$$requireSquareMatrix($this, mat);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), mat.rows()).foreach$mVc$sp((Function1)new Serializable($this, mat){
            public static final long serialVersionUID = 0L;
            public final Matrix mat$3;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void apply$mcVI$sp(int i) {
                Predef$ predef$ = Predef$.MODULE$;
                Serializable serializable = new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ LinearAlgebra$.anonfun.requireSymmetricMatrix.1 $outer;
                    private final int i$1;

                    public final void apply(int j) {
                        this.apply$mcVI$sp(j);
                    }

                    public void apply$mcVI$sp(int j) {
                        E e = this.$outer.mat$3.apply(j, this.i$1);
                        E e2 = this.$outer.mat$3.apply(this.i$1, j);
                        boolean bl = e2 != e ? (e2 != null ? (!(e2 instanceof Number) ? (!(e2 instanceof Character) ? e2.equals(e) : BoxesRunTime.equalsCharObject((Character)((Character)e2), e)) : BoxesRunTime.equalsNumObject((Number)((Number)e2), e)) : false) : true;
                        if (bl) {
                            return;
                        }
                        throw new MatrixNotSymmetricException();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.i$1 = i$1;
                    }
                };
                Range range = RichInt$.MODULE$.until$extension0(0, i);
                if (!range.validateRangeBoundaries((Function1)serializable)) return;
                int n = range.start();
                int n2 = range.terminalElement();
                int n3 = range.step();
                while (n != n2) {
                    serializable.apply$mcVI$sp(n);
                    n += n3;
                }
                return;
            }
            {
                this.mat$3 = mat$3;
            }
        });
    }

    public static Tuple3 eig(LinearAlgebra $this, Matrix m) {
        LinearAlgebra$class.requireNonEmptyMatrix($this, m);
        LinearAlgebra$class.breeze$linalg$LinearAlgebra$$requireSquareMatrix($this, m);
        int n = m.rows();
        DenseVector<Object> Wr = DenseVector$.MODULE$.zeros$mDc$sp(n, (ClassTag<Object>)ClassTag$.MODULE$.Double(), (DefaultArrayValue<Object>)DefaultArrayValue.DoubleDefaultArrayValue$.MODULE$);
        DenseVector<Object> Wi = DenseVector$.MODULE$.zeros$mDc$sp(n, (ClassTag<Object>)ClassTag$.MODULE$.Double(), (DefaultArrayValue<Object>)DefaultArrayValue.DoubleDefaultArrayValue$.MODULE$);
        Matrix Vr = DenseMatrix$.MODULE$.zeros$mDc$sp(n, n, ClassTag$.MODULE$.Double(), (DefaultArrayValue)DefaultArrayValue.DoubleDefaultArrayValue$.MODULE$);
        double[] worksize = (double[])Array$.MODULE$.ofDim(1, ClassTag$.MODULE$.Double());
        intW info = new intW(0);
        LAPACK.getInstance().dgeev("N", "V", n, (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()), scala.math.package$.MODULE$.max(1, n), (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()), (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()), (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()), scala.math.package$.MODULE$.max(1, n), (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()), scala.math.package$.MODULE$.max(1, n), worksize, -1, info);
        int lwork = info.val != 0 ? scala.math.package$.MODULE$.max(1, 4 * n) : scala.math.package$.MODULE$.max(1, (int)worksize[0]);
        double[] work = (double[])Array$.MODULE$.ofDim(lwork, ClassTag$.MODULE$.Double());
        Matrix A = DenseMatrix$.MODULE$.zeros$mDc$sp(n, n, ClassTag$.MODULE$.Double(), (DefaultArrayValue)DefaultArrayValue.DoubleDefaultArrayValue$.MODULE$);
        A.$colon$eq(m, DenseMatrix$.MODULE$.canSetInto_DV_V_Double_def());
        if (package$.MODULE$.useNativeLibraries()) {
            int i;
            info.val = i = NativeBlasDeferrer$.MODULE$.dgeev('N', 'V', n, ((DenseMatrix)A).data$mcD$sp(), 0, scala.math.package$.MODULE$.max(1, n), Wr.data$mcD$sp(), 0, Wi.data$mcD$sp(), 0, (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()), 0, scala.math.package$.MODULE$.max(1, n), ((DenseMatrix)Vr).data$mcD$sp(), 0, scala.math.package$.MODULE$.max(1, n));
        } else {
            LAPACK.getInstance().dgeev("N", "V", n, ((DenseMatrix)A).data$mcD$sp(), scala.math.package$.MODULE$.max(1, n), Wr.data$mcD$sp(), Wi.data$mcD$sp(), (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()), scala.math.package$.MODULE$.max(1, n), ((DenseMatrix)Vr).data$mcD$sp(), scala.math.package$.MODULE$.max(1, n), work, work.length, info);
        }
        if (info.val > 0) {
            throw new NotConvergedException(NotConvergedException$Iterations$.MODULE$, NotConvergedException$.MODULE$.$lessinit$greater$default$2());
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return new Tuple3(Wr, Wi, (Object)Vr);
    }

    public static Tuple3 svd(LinearAlgebra $this, DenseMatrix mat) {
        LinearAlgebra$class.requireNonEmptyMatrix($this, mat);
        int m = mat.rows();
        int n = mat.cols();
        Predef$ predef$ = Predef$.MODULE$;
        DenseVector<Object> S = DenseVector$.MODULE$.zeros$mDc$sp(RichInt$.MODULE$.min$extension(m, n), (ClassTag<Object>)ClassTag$.MODULE$.Double(), (DefaultArrayValue<Object>)DefaultArrayValue.DoubleDefaultArrayValue$.MODULE$);
        Matrix U = DenseMatrix$.MODULE$.zeros$mDc$sp(m, m, ClassTag$.MODULE$.Double(), (DefaultArrayValue)DefaultArrayValue.DoubleDefaultArrayValue$.MODULE$);
        Matrix Vt = DenseMatrix$.MODULE$.zeros$mDc$sp(n, n, ClassTag$.MODULE$.Double(), (DefaultArrayValue)DefaultArrayValue.DoubleDefaultArrayValue$.MODULE$);
        Predef$ predef$2 = Predef$.MODULE$;
        int[] iwork = new int[8 * RichInt$.MODULE$.min$extension(m, n)];
        int workSize = 3 * scala.math.package$.MODULE$.min(m, n) * scala.math.package$.MODULE$.min(m, n) + scala.math.package$.MODULE$.max(scala.math.package$.MODULE$.max(m, n), 4 * scala.math.package$.MODULE$.min(m, n) * scala.math.package$.MODULE$.min(m, n) + 4 * scala.math.package$.MODULE$.min(m, n));
        double[] work = new double[workSize];
        intW info = new intW(0);
        DenseMatrix cm = package$.MODULE$.copy(mat, DenseMatrix$.MODULE$.canCopyDenseMatrix(ClassTag$.MODULE$.Double()));
        if (package$.MODULE$.useNativeLibraries()) {
            int i;
            info.val = i = NativeBlasDeferrer$.MODULE$.dgesvd('A', 'A', m, n, cm.data$mcD$sp(), 0, scala.math.package$.MODULE$.max(1, m), S.data$mcD$sp(), 0, ((DenseMatrix)U).data$mcD$sp(), 0, scala.math.package$.MODULE$.max(1, m), ((DenseMatrix)Vt).data$mcD$sp(), 0, scala.math.package$.MODULE$.max(1, n));
        } else {
            LAPACK.getInstance().dgesdd("A", m, n, cm.data$mcD$sp(), scala.math.package$.MODULE$.max(1, m), S.data$mcD$sp(), ((DenseMatrix)U).data$mcD$sp(), scala.math.package$.MODULE$.max(1, m), ((DenseMatrix)Vt).data$mcD$sp(), scala.math.package$.MODULE$.max(1, n), work, work.length, iwork, info);
        }
        if (info.val > 0) {
            throw new NotConvergedException(NotConvergedException$Iterations$.MODULE$, NotConvergedException$.MODULE$.$lessinit$greater$default$2());
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return new Tuple3((Object)U, S, (Object)Vt);
    }

    public static DenseMatrix kron(LinearAlgebra $this, DenseMatrix a, Object b, BinaryOp mul, Predef.$less$colon$less asMat, ClassTag man, DefaultArrayValue dfv) {
        Matrix result = DenseMatrix$.MODULE$.zeros(a.rows() * ((Matrix)asMat.apply(b)).rows(), a.cols() * ((Matrix)asMat.apply(b)).cols(), man, dfv);
        a.activeIterator().withFilter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Tuple2<Object, Object>, V1> check$ifrefutable$1) {
                boolean bl = check$ifrefutable$1 != null && check$ifrefutable$1._1() != null;
                return bl;
            }
        }).foreach((Function1)new Serializable($this, (DenseMatrix)result, b, mul, asMat){
            public static final long serialVersionUID = 0L;
            private final DenseMatrix result$1;
            private final Object b$1;
            private final BinaryOp mul$1;
            private final Predef.$less$colon$less asMat$1;

            public final DenseMatrix<RV> apply(Tuple2<Tuple2<Object, Object>, V1> x$6) {
                if (x$6 != null && x$6._1() != null) {
                    int n = ((Tuple2)x$6._1())._1$mcI$sp() * ((Matrix)this.asMat$1.apply(this.b$1)).rows();
                    Predef$ predef$ = Predef$.MODULE$;
                    int n2 = ((Tuple2)x$6._1())._2$mcI$sp() * ((Matrix)this.asMat$1.apply(this.b$1)).cols();
                    Predef$ predef$2 = Predef$.MODULE$;
                    return (DenseMatrix)((NumericOps)this.result$1.apply(RichInt$.MODULE$.until$extension0(n, (((Tuple2)x$6._1())._1$mcI$sp() + 1) * ((Matrix)this.asMat$1.apply(this.b$1)).rows()), RichInt$.MODULE$.until$extension0(n2, (((Tuple2)x$6._1())._2$mcI$sp() + 1) * ((Matrix)this.asMat$1.apply(this.b$1)).cols()), DenseMatrix$.MODULE$.canSliceColsAndRows())).$colon$eq(this.mul$1.apply(x$6._2(), this.b$1), DenseMatrix$.MODULE$.setDMDM());
                }
                throw new MatchError(x$6);
            }
            {
                this.result$1 = result$1;
                this.b$1 = b$1;
                this.mul$1 = mul$1;
                this.asMat$1 = asMat$1;
            }
        });
        return result;
    }

    public static DenseVector cross(LinearAlgebra $this, DenseVector a, DenseVector b, Ring ring, ClassTag man) {
        Predef$.MODULE$.require(a.length() == 3);
        Predef$.MODULE$.require(b.length() == 3);
        return (DenseVector)DenseVector$.MODULE$.apply(Predef$.MODULE$.genericWrapArray((Object)new Object[]{ring.$minus(ring.$times(a.apply(1), b.apply(2)), ring.$times(a.apply(2), b.apply(1))), ring.$minus(ring.$times(a.apply(2), b.apply(0)), ring.$times(a.apply(0), b.apply(2))), ring.$minus(ring.$times(a.apply(0), b.apply(1)), ring.$times(a.apply(1), b.apply(0)))}), man);
    }

    public static double[] ranks(LinearAlgebra $this, Vector x, Ordering evidence$3) {
        int numTiedValuesAtI;
        IndexedSeq as = x.argsort(evidence$3);
        double[] rv = new double[as.length()];
        for (int i = 0; i < as.length(); i += numTiedValuesAtI) {
            numTiedValuesAtI = 1;
            while (i + numTiedValuesAtI < as.length()) {
                Object v = x.apply(as.apply(i));
                Object v2 = x.apply(as.apply(i + numTiedValuesAtI));
                boolean bl = v2 != v ? (v2 != null ? (!(v2 instanceof Number) ? (!(v2 instanceof Character) ? v2.equals(v) : BoxesRunTime.equalsCharObject((Character)((Character)v2), v)) : BoxesRunTime.equalsNumObject((Number)((Number)v2), v)) : false) : true;
                if (!bl) break;
                ++numTiedValuesAtI;
            }
            double rank2 = (double)(1 + i) + (double)(numTiedValuesAtI - 1) / 2.0;
            for (int j = 0; j < numTiedValuesAtI; ++j) {
                rv[BoxesRunTime.unboxToInt((Object)as.apply((int)(i + j)))] = rank2;
            }
        }
        return rv;
    }

    public static DenseMatrix lowerTriangular(LinearAlgebra $this, Matrix X, Semiring evidence$4, ClassTag evidence$5, DefaultArrayValue evidence$6) {
        int N = X.rows();
        Serializable serializable = new Serializable($this, X, evidence$4){
            public static final long serialVersionUID = 0L;
            private final Matrix X$1;
            private final Semiring evidence$4$1;

            public final T apply(int i, int j) {
                Object object;
                if (j <= i) {
                    object = this.X$1.apply(i, j);
                } else {
                    Semiring semiring = this.evidence$4$1;
                    Predef$ predef$ = Predef$.MODULE$;
                    object = semiring.zero();
                }
                return (T)object;
            }
            {
                this.X$1 = X$1;
                this.evidence$4$1 = evidence$4$1;
            }
        };
        return (DenseMatrix)MatrixConstructors$class.tabulate(DenseMatrix$.MODULE$, N, N, (Function2)serializable, evidence$5, evidence$6);
    }

    public static DenseMatrix upperTriangular(LinearAlgebra $this, Matrix X, Semiring evidence$7, ClassTag evidence$8, DefaultArrayValue evidence$9) {
        int N = X.rows();
        Serializable serializable = new Serializable($this, X, evidence$7){
            public static final long serialVersionUID = 0L;
            private final Matrix X$2;
            private final Semiring evidence$7$1;

            public final T apply(int i, int j) {
                Object object;
                if (j >= i) {
                    object = this.X$2.apply(i, j);
                } else {
                    Semiring semiring = this.evidence$7$1;
                    Predef$ predef$ = Predef$.MODULE$;
                    object = semiring.zero();
                }
                return (T)object;
            }
            {
                this.X$2 = X$2;
                this.evidence$7$1 = evidence$7$1;
            }
        };
        return (DenseMatrix)MatrixConstructors$class.tabulate(DenseMatrix$.MODULE$, N, N, (Function2)serializable, evidence$8, evidence$9);
    }

    /*
     * WARNING - void declaration
     */
    public static DenseMatrix cholesky(LinearAlgebra $this, Matrix X) {
        void var2_2;
        LinearAlgebra$class.requireNonEmptyMatrix($this, X);
        LinearAlgebra$class.requireSymmetricMatrix($this, X);
        DenseMatrix<Object> A = $this.lowerTriangular(X, Semiring$.MODULE$.semiringD(), ClassTag$.MODULE$.Double(), DefaultArrayValue.DoubleDefaultArrayValue$.MODULE$);
        int N = X.rows();
        intW info = new intW(0);
        if (package$.MODULE$.useNativeLibraries()) {
            int i;
            info.val = i = NativeBlasDeferrer$.MODULE$.dpotrf('L', N, A.data$mcD$sp(), 0, scala.math.package$.MODULE$.max(1, N));
        } else {
            LAPACK.getInstance().dpotrf("L", N, A.data$mcD$sp(), scala.math.package$.MODULE$.max(1, N), info);
        }
        Predef$.MODULE$.assert(info.val >= 0);
        if (info.val > 0) {
            throw new NotConvergedException(NotConvergedException$Iterations$.MODULE$, NotConvergedException$.MODULE$.$lessinit$greater$default$2());
        }
        return var2_2;
    }

    /*
     * Unable to fully structure code
     */
    public static Tuple4 qrp(LinearAlgebra $this, DenseMatrix A) {
        m = A.rows();
        n = A.cols();
        lapack = LAPACK.getInstance();
        work = new double[1];
        info = new intW(0);
        lapack.dgeqrf(m, n, null, m, null, work, -1, info);
        lwork1 = info.val != 0 ? n : (int)work[0];
        lapack.dorgqr(m, m, scala.math.package$.MODULE$.min(m, n), null, m, null, work, -1, info);
        lwork2 = info.val != 0 ? n : (int)work[0];
        workspace = new double[scala.math.package$.MODULE$.max(lwork1, lwork2)];
        maxd = scala.math.package$.MODULE$.max(m, n);
        AFact = DenseMatrix$.MODULE$.zeros$mDc$sp(m, maxd, ClassTag$.MODULE$.Double(), (DefaultArrayValue)DefaultArrayValue.DoubleDefaultArrayValue$.MODULE$);
        pvt = new int[n];
        tau = new double[scala.math.package$.MODULE$.min(m, n)];
        var5_14 = Predef$.MODULE$;
        var37_15 = new Serializable($this, n, (DenseMatrix)AFact, A){
            public static final long serialVersionUID = 0L;
            public final int n$2;
            public final DenseMatrix AFact$1;
            public final DenseMatrix A$1;

            public final void apply(int r) {
                this.apply$mcVI$sp(r);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void apply$mcVI$sp(int r) {
                Predef$ predef$ = Predef$.MODULE$;
                Serializable serializable = new Serializable(this, r){
                    public static final long serialVersionUID = 0L;
                    public final /* synthetic */ LinearAlgebra$.anonfun.qrp.1 $outer;
                    public final int r$1;

                    public final void apply(int c) {
                        this.apply$mcVI$sp(c);
                    }

                    public void apply$mcVI$sp(int c) {
                        this.$outer.AFact$1.update$mcD$sp(this.r$1, c, this.$outer.A$1.apply$mcD$sp(this.r$1, c));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.r$1 = r$1;
                    }
                };
                Range range = RichInt$.MODULE$.until$extension0(0, this.n$2);
                if (!range.validateRangeBoundaries((Function1)serializable)) return;
                int n = range.start();
                int n2 = range.terminalElement();
                int n3 = range.step();
                while (n != n2) {
                    serializable.apply$mcVI$sp(n);
                    n += n3;
                }
                return;
            }
            {
                this.n$2 = n$2;
                this.AFact$1 = AFact$1;
                this.A$1 = A$1;
            }
        };
        var6_16 = Range$.MODULE$.apply(0, m);
        if (!var6_16.validateRangeBoundaries((Function1)var37_15)) ** GOTO lbl24
        var43_17 = var6_16.start();
        var7_18 = var6_16.terminalElement();
        var41_19 = var6_16.step();
        block0: while (true) {
            block14: {
                if (var43_17 != var7_18) break block14;
lbl24:
                // 2 sources

                lapack.dgeqp3(m, n, AFact.data$mcD$sp(), m, pvt, tau, workspace, workspace.length, info);
                if (info.val > 0) {
                    var8_26 = NotConvergedException$.MODULE$;
                    throw new NotConvergedException(NotConvergedException$Iterations$.MODULE$, "");
                }
                if (info.val < 0) {
                    throw new IllegalArgumentException();
                }
                R = DenseMatrix$.MODULE$.zeros$mDc$sp(m, n, ClassTag$.MODULE$.Double(), (DefaultArrayValue)DefaultArrayValue.DoubleDefaultArrayValue$.MODULE$);
                var9_28 = Predef$.MODULE$;
                Range$.MODULE$.apply(0, maxd).withFilter((Function1)new Serializable($this, n){
                    public static final long serialVersionUID = 0L;
                    private final int n$2;

                    public final boolean apply(int c) {
                        return this.apply$mcZI$sp(c);
                    }

                    public boolean apply$mcZI$sp(int c) {
                        return c < this.n$2;
                    }
                    {
                        this.n$2 = n$2;
                    }
                }).foreach((Function1)new Serializable($this, m, (DenseMatrix)AFact, (DenseMatrix)R){
                    public static final long serialVersionUID = 0L;
                    private final int m$1;
                    public final DenseMatrix AFact$1;
                    public final DenseMatrix R$1;

                    public final void apply(int c) {
                        this.apply$mcVI$sp(c);
                    }

                    public void apply$mcVI$sp(int c) {
                        Predef$ predef$ = Predef$.MODULE$;
                        RichInt$.MODULE$.until$extension0(0, this.m$1).withFilter((Function1)new Serializable(this, c){
                            public static final long serialVersionUID = 0L;
                            private final int c$1;

                            public final boolean apply(int r) {
                                return this.apply$mcZI$sp(r);
                            }

                            public boolean apply$mcZI$sp(int r) {
                                return r <= this.c$1;
                            }
                            {
                                this.c$1 = c$1;
                            }
                        }).foreach((Function1)new Serializable(this, c){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ LinearAlgebra$.anonfun.qrp.3 $outer;
                            private final int c$1;

                            public final void apply(int r) {
                                this.apply$mcVI$sp(r);
                            }

                            public void apply$mcVI$sp(int r) {
                                this.$outer.R$1.update$mcD$sp(r, this.c$1, this.$outer.AFact$1.apply$mcD$sp(r, this.c$1));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.c$1 = c$1;
                            }
                        });
                    }
                    {
                        this.m$1 = m$1;
                        this.AFact$1 = AFact$1;
                        this.R$1 = R$1;
                    }
                });
                Q = DenseMatrix$.MODULE$.zeros$mDc$sp(m, m, ClassTag$.MODULE$.Double(), (DefaultArrayValue)DefaultArrayValue.DoubleDefaultArrayValue$.MODULE$);
                lapack.dorgqr(m, m, scala.math.package$.MODULE$.min(m, n), AFact.data$mcD$sp(), m, tau, workspace, workspace.length, info);
                var13_30 = Predef$.MODULE$;
                var32_31 = new Serializable($this, m, maxd, (DenseMatrix)AFact, (DenseMatrix)Q){
                    public static final long serialVersionUID = 0L;
                    public final int m$1;
                    public final int maxd$1;
                    public final DenseMatrix AFact$1;
                    public final DenseMatrix Q$1;

                    public final void apply(int r) {
                        this.apply$mcVI$sp(r);
                    }

                    public void apply$mcVI$sp(int r) {
                        Predef$ predef$ = Predef$.MODULE$;
                        RichInt$.MODULE$.until$extension0(0, this.maxd$1).withFilter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ LinearAlgebra$.anonfun.qrp.4 $outer;

                            public final boolean apply(int c) {
                                return this.apply$mcZI$sp(c);
                            }

                            public boolean apply$mcZI$sp(int c) {
                                return c < this.$outer.m$1;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }).foreach((Function1)new Serializable(this, r){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ LinearAlgebra$.anonfun.qrp.4 $outer;
                            private final int r$2;

                            public final void apply(int c) {
                                this.apply$mcVI$sp(c);
                            }

                            public void apply$mcVI$sp(int c) {
                                this.$outer.Q$1.update$mcD$sp(this.r$2, c, this.$outer.AFact$1.apply$mcD$sp(this.r$2, c));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.r$2 = r$2;
                            }
                        });
                    }
                    {
                        this.m$1 = m$1;
                        this.maxd$1 = maxd$1;
                        this.AFact$1 = AFact$1;
                        this.Q$1 = Q$1;
                    }
                };
                var15_32 = RichInt$.MODULE$.until$extension0(0, m);
                if (!var15_32.validateRangeBoundaries((Function1)var32_31)) ** GOTO lbl44
                var34_33 = var15_32.start();
                var16_34 = var15_32.terminalElement();
                var33_35 = var15_32.step();
                while (true) {
                    block15: {
                        if (var34_33 != var16_34) break block15;
lbl44:
                        // 2 sources

                        if (info.val > 0) {
                            var17_37 = NotConvergedException$.MODULE$;
                            throw new NotConvergedException(NotConvergedException$Iterations$.MODULE$, "");
                        }
                        if (info.val < 0) {
                            throw new IllegalArgumentException();
                        }
                        var19_38 = NumericOps$Arrays$.MODULE$;
                        new NumericOps.Arrays.ArrayIsNumericOps<V>(pvt).$minus$eq(BoxesRunTime.boxToInteger((int)1), NumericOps.ArraysLowPriority.class.binaryUpdateOpFromDVOp(NumericOps$Arrays$.MODULE$, DenseVector$.MODULE$.canSubInto_DV_S_Int(), ClassTag$.MODULE$.Nothing()));
                        P = DenseMatrix$.MODULE$.zeros$mIc$sp(n, n, ClassTag$.MODULE$.Int(), (DefaultArrayValue)DefaultArrayValue.IntDefaultArrayValue$.MODULE$);
                        var20_40 = Predef$.MODULE$;
                        var21_41 = new Serializable($this, pvt, (DenseMatrix)P){
                            public static final long serialVersionUID = 0L;
                            public final int[] pvt$1;
                            public final DenseMatrix P$1;

                            public final void apply(int i) {
                                this.apply$mcVI$sp(i);
                            }

                            public void apply$mcVI$sp(int i) {
                                this.P$1.update$mcI$sp(this.pvt$1[i], i, 1);
                            }
                            {
                                this.pvt$1 = pvt$1;
                                this.P$1 = P$1;
                            }
                        };
                        var22_42 = Range$.MODULE$.apply(0, n);
                        if (!var22_42.validateRangeBoundaries((Function1)var21_41)) ** GOTO lbl62
                        var29_43 = var22_42.start();
                        var23_44 = var22_42.terminalElement();
                        var28_45 = var22_42.step();
                        while (true) {
                            block16: {
                                if (var29_43 != var23_44) break block16;
lbl62:
                                // 2 sources

                                return new Tuple4((Object)Q, (Object)R, (Object)P, (Object)pvt);
                            }
                            var26_39.update$mcI$sp((int)var27_12[var29_43], var29_43, 1);
                            var29_43 += var28_45;
                        }
                    }
                    var30_36 = Predef$.MODULE$;
                    RichInt$.MODULE$.until$extension0(0, (int)var31_10).withFilter((Function1)new /* invalid duplicate definition of identical inner class */).foreach((Function1)new /* invalid duplicate definition of identical inner class */);
                    var34_33 += var33_35;
                }
            }
            var35_20 = Predef$.MODULE$;
            var38_21 = new /* invalid duplicate definition of identical inner class */;
            var39_22 = RichInt$.MODULE$.until$extension0(0, (int)var36_3);
            if (!var39_22.validateRangeBoundaries((Function1)var38_21)) ** GOTO lbl82
            var45_25 = var39_22.start();
            var40_23 = var39_22.terminalElement();
            var44_24 = var39_22.step();
            while (true) {
                block17: {
                    if (var45_25 != var40_23) break block17;
lbl82:
                    // 2 sources

                    var43_17 += var41_19;
                    continue block0;
                }
                var42_11.update$mcD$sp(var43_17, var45_25, A.apply$mcD$sp(var43_17, var45_25));
                var45_25 += var44_24;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static Tuple2 qr(LinearAlgebra $this, DenseMatrix A, boolean skipQ) {
        m = A.rows();
        n = A.cols();
        lapack = LAPACK.getInstance();
        work = new double[1];
        info = new intW(0);
        lapack.dgeqrf(m, n, null, m, null, work, -1, info);
        lwork1 = info.val != 0 ? n : (int)work[0];
        lapack.dorgqr(m, m, scala.math.package$.MODULE$.min(m, n), null, m, null, work, -1, info);
        lwork2 = info.val != 0 ? n : (int)work[0];
        workspace = new double[scala.math.package$.MODULE$.max(lwork1, lwork2)];
        maxd = scala.math.package$.MODULE$.max(m, n);
        mind = scala.math.package$.MODULE$.min(m, n);
        tau = new double[mind];
        outputMat = DenseMatrix$.MODULE$.zeros$mDc$sp(m, maxd, ClassTag$.MODULE$.Double(), (DefaultArrayValue)DefaultArrayValue.DoubleDefaultArrayValue$.MODULE$);
        var7_15 = Predef$.MODULE$;
        var30_16 = new Serializable($this, n, (DenseMatrix)outputMat, A){
            public static final long serialVersionUID = 0L;
            public final int n$3;
            public final DenseMatrix outputMat$1;
            public final DenseMatrix A$2;

            public final void apply(int r) {
                this.apply$mcVI$sp(r);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void apply$mcVI$sp(int r) {
                Predef$ predef$ = Predef$.MODULE$;
                Serializable serializable = new Serializable(this, r){
                    public static final long serialVersionUID = 0L;
                    public final /* synthetic */ LinearAlgebra$.anonfun.qr.1 $outer;
                    public final int r$3;

                    public final void apply(int c) {
                        this.apply$mcVI$sp(c);
                    }

                    public void apply$mcVI$sp(int c) {
                        this.$outer.outputMat$1.update$mcD$sp(this.r$3, c, this.$outer.A$2.apply$mcD$sp(this.r$3, c));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.r$3 = r$3;
                    }
                };
                Range range = RichInt$.MODULE$.until$extension0(0, this.n$3);
                if (!range.validateRangeBoundaries((Function1)serializable)) return;
                int n = range.start();
                int n2 = range.terminalElement();
                int n3 = range.step();
                while (n != n2) {
                    serializable.apply$mcVI$sp(n);
                    n += n3;
                }
                return;
            }
            {
                this.n$3 = n$3;
                this.outputMat$1 = outputMat$1;
                this.A$2 = A$2;
            }
        };
        var8_17 = Range$.MODULE$.apply(0, m);
        if (!var8_17.validateRangeBoundaries((Function1)var30_16)) ** GOTO lbl24
        var36_18 = var8_17.start();
        var9_19 = var8_17.terminalElement();
        var34_20 = var8_17.step();
        block0: while (true) {
            block13: {
                block14: {
                    if (var36_18 != var9_19) break block13;
lbl24:
                    // 2 sources

                    lapack.dgeqrf(m, n, outputMat.data$mcD$sp(), m, tau, workspace, workspace.length, info);
                    if (info.val > 0) {
                        var10_27 = NotConvergedException$.MODULE$;
                        throw new NotConvergedException(NotConvergedException$Iterations$.MODULE$, "");
                    }
                    if (info.val < 0) {
                        throw new IllegalArgumentException();
                    }
                    R = DenseMatrix$.MODULE$.zeros$mDc$sp(m, n, ClassTag$.MODULE$.Double(), (DefaultArrayValue)DefaultArrayValue.DoubleDefaultArrayValue$.MODULE$);
                    var11_29 = Predef$.MODULE$;
                    Range$.MODULE$.apply(0, maxd).withFilter((Function1)new Serializable($this, n){
                        public static final long serialVersionUID = 0L;
                        private final int n$3;

                        public final boolean apply(int c) {
                            return this.apply$mcZI$sp(c);
                        }

                        public boolean apply$mcZI$sp(int c) {
                            return c < this.n$3;
                        }
                        {
                            this.n$3 = n$3;
                        }
                    }).foreach((Function1)new Serializable($this, m, (DenseMatrix)outputMat, (DenseMatrix)R){
                        public static final long serialVersionUID = 0L;
                        private final int m$2;
                        public final DenseMatrix outputMat$1;
                        public final DenseMatrix R$2;

                        public final void apply(int c) {
                            this.apply$mcVI$sp(c);
                        }

                        public void apply$mcVI$sp(int c) {
                            Predef$ predef$ = Predef$.MODULE$;
                            RichInt$.MODULE$.until$extension0(0, this.m$2).withFilter((Function1)new Serializable(this, c){
                                public static final long serialVersionUID = 0L;
                                private final int c$2;

                                public final boolean apply(int r) {
                                    return this.apply$mcZI$sp(r);
                                }

                                public boolean apply$mcZI$sp(int r) {
                                    return r <= this.c$2;
                                }
                                {
                                    this.c$2 = c$2;
                                }
                            }).foreach((Function1)new Serializable(this, c){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ LinearAlgebra$.anonfun.qr.3 $outer;
                                private final int c$2;

                                public final void apply(int r) {
                                    this.apply$mcVI$sp(r);
                                }

                                public void apply$mcVI$sp(int r) {
                                    this.$outer.R$2.update$mcD$sp(r, this.c$2, this.$outer.outputMat$1.apply$mcD$sp(r, this.c$2));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.c$2 = c$2;
                                }
                            });
                        }
                        {
                            this.m$2 = m$2;
                            this.outputMat$1 = outputMat$1;
                            this.R$2 = R$2;
                        }
                    });
                    if (!skipQ) break block14;
                    v0 = new Tuple2(null, (Object)R);
                    ** GOTO lbl54
                }
                Q = DenseMatrix$.MODULE$.zeros$mDc$sp(m, m, ClassTag$.MODULE$.Double(), (DefaultArrayValue)DefaultArrayValue.DoubleDefaultArrayValue$.MODULE$);
                lapack.dorgqr(m, m, scala.math.package$.MODULE$.min(m, n), outputMat.data$mcD$sp(), m, tau, workspace, workspace.length, info);
                var15_31 = Predef$.MODULE$;
                var25_32 = new Serializable($this, m, maxd, (DenseMatrix)outputMat, (DenseMatrix)Q){
                    public static final long serialVersionUID = 0L;
                    public final int m$2;
                    public final int maxd$2;
                    public final DenseMatrix outputMat$1;
                    public final DenseMatrix Q$2;

                    public final void apply(int r) {
                        this.apply$mcVI$sp(r);
                    }

                    public void apply$mcVI$sp(int r) {
                        Predef$ predef$ = Predef$.MODULE$;
                        RichInt$.MODULE$.until$extension0(0, this.maxd$2).withFilter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ LinearAlgebra$.anonfun.qr.4 $outer;

                            public final boolean apply(int c) {
                                return this.apply$mcZI$sp(c);
                            }

                            public boolean apply$mcZI$sp(int c) {
                                return c < this.$outer.m$2;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }).foreach((Function1)new Serializable(this, r){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ LinearAlgebra$.anonfun.qr.4 $outer;
                            private final int r$4;

                            public final void apply(int c) {
                                this.apply$mcVI$sp(c);
                            }

                            public void apply$mcVI$sp(int c) {
                                this.$outer.Q$2.update$mcD$sp(this.r$4, c, this.$outer.outputMat$1.apply$mcD$sp(this.r$4, c));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.r$4 = r$4;
                            }
                        });
                    }
                    {
                        this.m$2 = m$2;
                        this.maxd$2 = maxd$2;
                        this.outputMat$1 = outputMat$1;
                        this.Q$2 = Q$2;
                    }
                };
                var17_33 = Range$.MODULE$.apply(0, m);
                if (!var17_33.validateRangeBoundaries((Function1)var25_32)) ** GOTO lbl48
                var27_34 = var17_33.start();
                var18_35 = var17_33.terminalElement();
                var26_36 = var17_33.step();
                while (true) {
                    block15: {
                        if (var27_34 != var18_35) break block15;
lbl48:
                        // 2 sources

                        if (info.val > 0) {
                            var19_38 = NotConvergedException$.MODULE$;
                            throw new NotConvergedException(NotConvergedException$Iterations$.MODULE$, "");
                        }
                        if (info.val < 0) {
                            throw new IllegalArgumentException();
                        }
                        v0 = new Tuple2((Object)Q, (Object)R);
lbl54:
                        // 2 sources

                        return v0;
                    }
                    var23_37 = Predef$.MODULE$;
                    RichInt$.MODULE$.until$extension0(0, maxd).withFilter((Function1)new /* invalid duplicate definition of identical inner class */).foreach((Function1)new /* invalid duplicate definition of identical inner class */);
                    var27_34 += var26_36;
                }
            }
            var28_21 = Predef$.MODULE$;
            var31_22 = new /* invalid duplicate definition of identical inner class */;
            var32_23 = RichInt$.MODULE$.until$extension0(0, n);
            if (!var32_23.validateRangeBoundaries((Function1)var31_22)) ** GOTO lbl70
            var38_26 = var32_23.start();
            var33_24 = var32_23.terminalElement();
            var37_25 = var32_23.step();
            while (true) {
                block16: {
                    if (var38_26 != var33_24) break block16;
lbl70:
                    // 2 sources

                    var36_18 += var34_20;
                    continue block0;
                }
                outputMat.update$mcD$sp(var36_18, var38_26, A.apply$mcD$sp(var36_18, var38_26));
                var38_26 += var37_25;
            }
            break;
        }
    }

    public static boolean qr$default$2(LinearAlgebra $this) {
        return false;
    }

    public static Tuple2 eigSym(LinearAlgebra $this, Matrix X, boolean rightEigenvectors) {
        LinearAlgebra$class.requireNonEmptyMatrix($this, X);
        LinearAlgebra$class.requireSymmetricMatrix($this, X);
        DenseMatrix<Object> A = $this.lowerTriangular(X, Semiring$.MODULE$.semiringD(), ClassTag$.MODULE$.Double(), DefaultArrayValue.DoubleDefaultArrayValue$.MODULE$);
        int N = X.rows();
        DenseVector<Object> evs = DenseVector$.MODULE$.zeros$mDc$sp(N, (ClassTag<Object>)ClassTag$.MODULE$.Double(), (DefaultArrayValue<Object>)DefaultArrayValue.DoubleDefaultArrayValue$.MODULE$);
        int lwork = scala.math.package$.MODULE$.max(1, 3 * N - 1);
        double[] work = (double[])Array$.MODULE$.ofDim(lwork, ClassTag$.MODULE$.Double());
        intW info = new intW(0);
        if (package$.MODULE$.useNativeLibraries()) {
            int i;
            info.val = i = NativeBlasDeferrer$.MODULE$.dsyev(rightEigenvectors ? (char)'V' : 'N', 'L', N, A.data$mcD$sp(), 0, scala.math.package$.MODULE$.max(1, N), evs.data$mcD$sp(), 0);
        } else {
            LAPACK.getInstance().dsyev(rightEigenvectors ? "V" : "N", "L", N, A.data$mcD$sp(), scala.math.package$.MODULE$.max(1, N), evs.data$mcD$sp(), work, lwork, info);
        }
        Predef$.MODULE$.assert(info.val >= 0);
        if (info.val > 0) {
            throw new NotConvergedException(NotConvergedException$Iterations$.MODULE$, NotConvergedException$.MODULE$.$lessinit$greater$default$2());
        }
        return new Tuple2(evs, rightEigenvectors ? new Some(A) : None$.MODULE$);
    }

    public static Tuple2 LU(LinearAlgebra $this, Matrix X, Function1 td) {
        LinearAlgebra$class.requireNonEmptyMatrix($this, X);
        int M = X.rows();
        int N = X.cols();
        DefaultArrayValue.DoubleDefaultArrayValue$ doubleDefaultArrayValue$ = DefaultArrayValue.DoubleDefaultArrayValue$.MODULE$;
        ClassTag classTag = ClassTag$.MODULE$.Double();
        Serializable serializable = new Serializable($this, X, td){
            public static final long serialVersionUID = 0L;
            private final Matrix X$3;
            private final Function1 td$1;

            public final double apply(int x$7, int x$8) {
                return this.apply$mcDII$sp(x$7, x$8);
            }

            public double apply$mcDII$sp(int x$7, int x$8) {
                return BoxesRunTime.unboxToDouble((Object)this.td$1.apply(this.X$3.apply(x$7, x$8)));
            }
            {
                this.X$3 = X$3;
                this.td$1 = td$1;
            }
        };
        DenseMatrix Y = (DenseMatrix)MatrixConstructors$class.tabulate$mDc$sp(DenseMatrix$.MODULE$, M, N, (Function2)serializable, classTag, (DefaultArrayValue)doubleDefaultArrayValue$);
        int[] ipiv = (int[])Array$.MODULE$.ofDim(scala.math.package$.MODULE$.min(M, N), ClassTag$.MODULE$.Int());
        intW info = new intW(0);
        if (package$.MODULE$.useNativeLibraries()) {
            int i;
            int n = scala.math.package$.MODULE$.max(1, M);
            double[] dArray = Y.data$mcD$sp();
            NativeBlasDeferrer$ nativeBlasDeferrer$ = NativeBlasDeferrer$.MODULE$;
            info.val = i = NativeBlas.dgetrf((int)M, (int)N, (double[])dArray, (int)0, (int)n, (int[])ipiv, (int)0);
        } else {
            LAPACK.getInstance().dgetrf(M, N, Y.data$mcD$sp(), scala.math.package$.MODULE$.max(1, M), ipiv, info);
        }
        Predef$.MODULE$.assert(info.val >= 0);
        return new Tuple2((Object)Y, (Object)ipiv);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double det(LinearAlgebra $this, Matrix X, Function1 td) {
        LinearAlgebra$class.breeze$linalg$LinearAlgebra$$requireSquareMatrix($this, X);
        Tuple2<DenseMatrix<Object>, int[]> tuple2 = $this.LU(X, td);
        if (tuple2 == null || tuple2._1() == null) throw new MatchError(tuple2);
        DenseMatrix denseMatrix = (DenseMatrix)tuple2._1();
        if (tuple2._2() == null) throw new MatchError(tuple2);
        int[] nArray = (int[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)denseMatrix, (Object)nArray);
        DenseMatrix m = (DenseMatrix)tuple22._1();
        int[] ipiv = (int[])tuple22._2();
        Predef$ predef$ = Predef$.MODULE$;
        int[] nArray2 = (int[])new ArrayOps.ofInt(ipiv).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$10) {
                return x$10 - 1;
            }

            public int apply$mcII$sp(int x$10) {
                return x$10 - 1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        Predef$ predef$2 = Predef$.MODULE$;
        Object[] objectArray = (Object[])new ArrayOps.ofInt(nArray2).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        Predef$ predef$3 = Predef$.MODULE$;
        int numExchangedRows = new ArrayOps.ofRef(objectArray).count((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> piv) {
                return piv._1$mcI$sp() != piv._2$mcI$sp();
            }
        });
        DoubleRef acc = numExchangedRows % 2 == 1 ? new DoubleRef(-1.0) : new DoubleRef(1.0);
        Predef$ predef$4 = Predef$.MODULE$;
        int n = m.rows();
        Serializable serializable = new Serializable($this, m, acc){
            public static final long serialVersionUID = 0L;
            public final DenseMatrix m$3;
            public final DoubleRef acc$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.acc$1.elem *= this.m$3.apply$mcD$sp(i, i);
            }
            {
                this.m$3 = m$3;
                this.acc$1 = acc$1;
            }
        };
        Range range = Range$.MODULE$.apply(0, n);
        if (!range.validateRangeBoundaries((Function1)serializable)) return acc.elem;
        int n2 = range.start();
        int n3 = range.terminalElement();
        int n4 = range.step();
        while (n2 != n3) {
            void var19_7;
            var18_15.elem *= var19_7.apply$mcD$sp(n2, n2);
            n2 += n4;
        }
        return acc.elem;
    }

    public static DenseMatrix inv(LinearAlgebra $this, Matrix X, Function1 td) {
        LinearAlgebra$class.breeze$linalg$LinearAlgebra$$requireSquareMatrix($this, X);
        Tuple2<DenseMatrix<Object>, int[]> tuple2 = $this.LU(X, td);
        if (tuple2 != null && tuple2._1() != null) {
            DenseMatrix denseMatrix = (DenseMatrix)tuple2._1();
            if (tuple2._2() != null) {
                int[] nArray = (int[])tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)denseMatrix, (Object)nArray);
                DenseMatrix m = (DenseMatrix)tuple22._1();
                int[] ipiv = (int[])tuple22._2();
                int N = m.rows();
                int lwork = scala.math.package$.MODULE$.max(1, N);
                double[] work = (double[])Array$.MODULE$.ofDim(lwork, ClassTag$.MODULE$.Double());
                intW info = new intW(0);
                LAPACK.getInstance().dgetri(N, m.data$mcD$sp(), scala.math.package$.MODULE$.max(1, N), ipiv, work, lwork, info);
                boolean bl = info.val >= 0;
                Predef$ predef$ = Predef$.MODULE$;
                if (!bl) {
                    Predef$ predef$2 = Predef$.MODULE$;
                    throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)new StringOps("Malformed argument %d (LAPACK)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(-info.val))}))).toString());
                }
                if (info.val > 0) {
                    throw new MatrixSingularException();
                }
                return m;
            }
        }
        throw new MatchError(tuple2);
    }

    public static DenseMatrix pinv(LinearAlgebra $this, DenseMatrix X) {
        LinearAlgebra$class.requireNonEmptyMatrix($this, X);
        return $this.inv((Matrix)((NumericOps)X.t(DenseMatrix$.MODULE$.canTranspose())).$times(X, DenseMatrix$.MODULE$.DenseMatrixDMulDenseMatrixD()), Predef$.MODULE$.conforms()).$times(X.t(DenseMatrix$.MODULE$.canTranspose()), DenseMatrix$.MODULE$.DenseMatrixDMulDenseMatrixD());
    }

    public static DenseMatrix pinv(LinearAlgebra $this, DenseMatrix X, Function1 cast) {
        LinearAlgebra$class.requireNonEmptyMatrix($this, X);
        return $this.pinv((DenseMatrix)X.mapValues(cast, DenseMatrix$.MODULE$.canMapValues(ClassTag$.MODULE$.Double())));
    }

    public static int rank(LinearAlgebra $this, DenseMatrix m, Option tol) {
        Tuple3<DenseMatrix<Object>, DenseVector<Object>, DenseMatrix<Object>> tuple3 = $this.svd(m);
        if (tuple3 != null) {
            Object object;
            Tuple3 tuple32 = new Tuple3(tuple3._1(), tuple3._2(), tuple3._3());
            tuple32._1();
            DenseVector s = (DenseVector)tuple32._2();
            tuple32._3();
            if (!tol.isEmpty()) {
                object = tol.get();
            } else {
                double eps1 = 2.0 * LAPACK.getInstance().dlamch("e");
                object = BoxesRunTime.boxToDouble((double)((double)scala.math.package$.MODULE$.max(m.cols(), m.rows()) * eps1 * s.max$mcD$sp((Ordering<Object>)Ordering.Double$.MODULE$)));
            }
            double useTol = BoxesRunTime.unboxToDouble((Object)object);
            double[] dArray = s.data$mcD$sp();
            Predef$ predef$ = Predef$.MODULE$;
            return new ArrayOps.ofDouble(dArray).count((Function1)new Serializable($this, useTol){
                public static final long serialVersionUID = 0L;
                private final double useTol$1;

                public final boolean apply(double x$13) {
                    return this.apply$mcZD$sp(x$13);
                }

                public boolean apply$mcZD$sp(double x$13) {
                    return x$13 > this.useTol$1;
                }
                {
                    this.useTol$1 = useTol$1;
                }
            });
        }
        throw new MatchError(tuple3);
    }

    public static Option rank$default$2(LinearAlgebra $this) {
        return None$.MODULE$;
    }

    public static DenseMatrix pow(LinearAlgebra $this, DenseMatrix m, double exp) {
        LinearAlgebra$class.breeze$linalg$LinearAlgebra$$requireSquareMatrix($this, m);
        Tuple3<DenseVector<Object>, DenseVector<Object>, DenseMatrix<Object>> tuple3 = $this.eig(m);
        if (tuple3 != null) {
            Tuple3 tuple32 = new Tuple3(tuple3._1(), tuple3._2(), tuple3._3());
            DenseVector real = (DenseVector)tuple32._1();
            DenseVector imag = (DenseVector)tuple32._2();
            DenseMatrix evectors = (DenseMatrix)tuple32._3();
            package$ package$2 = package$.MODULE$;
            Ring<Object> ring = Ring$.MODULE$.ringD();
            Predef.$less$colon$less $less$colon$less2 = Predef$.MODULE$.conforms();
            CanNorm$ canNorm$ = CanNorm$.MODULE$;
            CanNorm canNorm = new CanNorm<T>((Function1)$less$colon$less2, ring){
                private final Function1 tt$1;
                private final Ring ring$1;

                public double apply(T t, double n) {
                    return ((Vector)this.tt$1.apply(t)).norm(n, this.ring$1);
                }
                {
                    this.tt$1 = tt$1;
                    this.ring$1 = ring$1;
                }
            };
            package$ package$3 = package$.MODULE$;
            boolean bl = canNorm.apply(imag, 2.0) == 0.0;
            Predef$ predef$ = Predef$.MODULE$;
            if (!bl) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"requirement failed: ").append((Object)"We cannot handle complex eigenvalues yet.").toString());
            }
            double[] dArray = real.data$mcD$sp();
            Predef$ predef$2 = Predef$.MODULE$;
            DenseVector$mcD$sp exped = new DenseVector$mcD$sp((double[])new ArrayOps.ofDouble(dArray).map((Function1)new Serializable($this, exp){
                public static final long serialVersionUID = 0L;
                public final double exp$1;

                public final double apply(double x$15) {
                    return scala.math.package$.MODULE$.pow(x$15, this.exp$1);
                }

                public double apply$mcDD$sp(double x$15) {
                    return scala.math.package$.MODULE$.pow(x$15, this.exp$1);
                }
                {
                    this.exp$1 = exp$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            DenseMatrix$ denseMatrix$ = DenseMatrix$.MODULE$;
            DenseMatrix$ denseMatrix$2 = DenseMatrix$.MODULE$;
            DenseMatrix$ denseMatrix$3 = DenseMatrix$.MODULE$;
            return (DenseMatrix)((NumericOps)((NumericOps)evectors.t(new CanTranspose<DenseMatrix<V>, DenseMatrix<V>>(){

                public DenseMatrix<V> apply(DenseMatrix<V> from) {
                    Object x$15 = from.data();
                    int x$16 = from.offset();
                    int x$17 = from.rows();
                    int x$18 = from.cols();
                    int x$19 = from.majorStride();
                    boolean x$20 = !from.isTranspose();
                    return new DenseMatrix<V>(x$18, x$17, x$15, x$16, x$19, x$20);
                }
            })).$bslash(((NumericOps)evectors.$times(package$.MODULE$.diag(exped, ClassTag$.MODULE$.Double(), DefaultArrayValue.DoubleDefaultArrayValue$.MODULE$), DenseMatrix$.MODULE$.DenseMatrixDMulDenseMatrixD())).t(new /* invalid duplicate definition of identical inner class */), DenseMatrix$.MODULE$.DenseMatrixCanSolveDenseMatrix())).t(new /* invalid duplicate definition of identical inner class */);
        }
        throw new MatchError(tuple3);
    }

    public static void $init$(LinearAlgebra $this) {
    }
}

