/*
 * Decompiled with CFR 0.152.
 */
package breeze.linalg;

import breeze.linalg.DenseVector;
import breeze.linalg.Vector;
import breeze.math.Ring;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.BitSet$;
import scala.collection.immutable.Set;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public abstract class Vector$class {
    public static Set keySet(Vector $this) {
        Predef$ predef$ = Predef$.MODULE$;
        return (Set)BitSet$.MODULE$.apply((Seq)RichInt$.MODULE$.until$extension0(0, $this.length()));
    }

    public static int size(Vector $this) {
        return $this.length();
    }

    public static Iterator iterator(Vector $this) {
        return scala.package$.MODULE$.Iterator().range(0, $this.size()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Vector $outer;

            public final Tuple2<Object, E> apply(int i) {
                Integer n = BoxesRunTime.boxToInteger((int)i);
                Predef$ predef$ = Predef$.MODULE$;
                V v = this.$outer.apply(BoxesRunTime.boxToInteger((int)i));
                Predef.ArrowAssoc$ arrowAssoc$ = Predef.ArrowAssoc$.MODULE$;
                return new Tuple2((Object)n, v);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static Iterator valuesIterator(Vector $this) {
        return scala.package$.MODULE$.Iterator().range(0, $this.size()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Vector $outer;

            public final E apply(int i) {
                return (E)this.$outer.apply(BoxesRunTime.boxToInteger((int)i));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static Iterator keysIterator(Vector $this) {
        return scala.package$.MODULE$.Iterator().range(0, $this.size());
    }

    public static boolean equals(Vector $this, Object p1) {
        boolean bl;
        if (p1 instanceof Vector) {
            Vector vector = (Vector)p1;
            bl = $this.length() == vector.length() && $this.valuesIterator().sameElements(vector.valuesIterator());
        } else {
            bl = false;
        }
        return bl;
    }

    public static double norm(Vector $this, double n, Ring field) {
        double d;
        if (n == 1.0) {
            DoubleRef sum = new DoubleRef(0.0);
            $this.activeValuesIterator().foreach((Function1)new Serializable($this, sum, field){
                public static final long serialVersionUID = 0L;
                private final DoubleRef sum$1;
                private final Ring field$5;

                public final void apply(E v) {
                    this.sum$1.elem += this.field$5.norm(v);
                }
                {
                    void var3_3;
                    this.sum$1 = sum$1;
                    this.field$5 = var3_3;
                }
            });
            d = sum.elem;
        } else if (n == (double)2) {
            DoubleRef sum = new DoubleRef(0.0);
            $this.activeValuesIterator().foreach((Function1)new Serializable($this, sum, field){
                public static final long serialVersionUID = 0L;
                private final DoubleRef sum$2;
                private final Ring field$5;

                public final void apply(E v) {
                    double nn = this.field$5.norm(v);
                    this.sum$2.elem += nn * nn;
                }
                {
                    void var3_3;
                    this.sum$2 = sum$2;
                    this.field$5 = var3_3;
                }
            });
            d = package$.MODULE$.sqrt(sum.elem);
        } else if (n == Double.POSITIVE_INFINITY) {
            DoubleRef max = new DoubleRef(Double.NEGATIVE_INFINITY);
            $this.activeValuesIterator().foreach((Function1)new Serializable($this, max, field){
                public static final long serialVersionUID = 0L;
                private final DoubleRef max$1;
                private final Ring field$5;

                public final void apply(E v) {
                    double nn = this.field$5.norm(v);
                    if (nn > this.max$1.elem) {
                        this.max$1.elem = nn;
                    }
                }
                {
                    void var3_3;
                    this.max$1 = max$1;
                    this.field$5 = var3_3;
                }
            });
            d = max.elem;
        } else {
            DoubleRef sum = new DoubleRef(0.0);
            $this.activeValuesIterator().foreach((Function1)new Serializable($this, sum, n, field){
                public static final long serialVersionUID = 0L;
                private final DoubleRef sum$3;
                private final double n$1;
                private final Ring field$5;

                public final void apply(E v) {
                    double nn = this.field$5.norm(v);
                    this.sum$3.elem += package$.MODULE$.pow(nn, this.n$1);
                }
                {
                    void var5_4;
                    this.sum$3 = sum$3;
                    this.n$1 = n$1;
                    this.field$5 = var5_4;
                }
            });
            d = package$.MODULE$.pow(sum.elem, 1.0 / n);
        }
        return d;
    }

    public static DenseVector toDenseVector(Vector $this, ClassTag cm) {
        return new DenseVector($this.toArray(cm));
    }

    /*
     * WARNING - void declaration
     */
    public static Object toArray(Vector $this, ClassTag cm) {
        void var3_2;
        Object result = cm.newArray($this.length());
        for (int i = 0; i < $this.length(); ++i) {
            ScalaRunTime$.MODULE$.array_update(result, i, $this.apply(BoxesRunTime.boxToInteger((int)i)));
        }
        return var3_2;
    }

    public static double norm$mcD$sp(Vector $this, double n, Ring field) {
        return $this.norm(n, field);
    }

    public static double norm$mcF$sp(Vector $this, double n, Ring field) {
        return $this.norm(n, field);
    }

    public static double norm$mcI$sp(Vector $this, double n, Ring field) {
        return $this.norm(n, field);
    }

    public static DenseVector toDenseVector$mcD$sp(Vector $this, ClassTag cm) {
        return $this.toDenseVector(cm);
    }

    public static DenseVector toDenseVector$mcF$sp(Vector $this, ClassTag cm) {
        return $this.toDenseVector(cm);
    }

    public static DenseVector toDenseVector$mcI$sp(Vector $this, ClassTag cm) {
        return $this.toDenseVector(cm);
    }

    public static double[] toArray$mcD$sp(Vector $this, ClassTag cm) {
        return (double[])$this.toArray(cm);
    }

    public static float[] toArray$mcF$sp(Vector $this, ClassTag cm) {
        return (float[])$this.toArray(cm);
    }

    public static int[] toArray$mcI$sp(Vector $this, ClassTag cm) {
        return (int[])$this.toArray(cm);
    }

    public static void $init$(Vector $this) {
    }
}

