/*
 * Decompiled with CFR 0.152.
 */
package breeze.linalg;

import breeze.generic.CanCollapseAxis;
import breeze.generic.CanMapValues;
import breeze.generic.URFunc;
import breeze.generic.UReduceable;
import breeze.io.CSVReader$;
import breeze.io.CSVWriter$;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.DenseVector$mcD$sp;
import breeze.linalg.LinearAlgebra;
import breeze.linalg.LinearAlgebra$class;
import breeze.linalg.Matrix;
import breeze.linalg.MatrixConstructors$class;
import breeze.linalg.NumericOps;
import breeze.linalg.Vector;
import breeze.linalg.VectorConstructors$class;
import breeze.linalg.operators.BinaryOp;
import breeze.linalg.operators.CanAxpy;
import breeze.linalg.operators.OpDiv;
import breeze.linalg.operators.OpMulScalar;
import breeze.linalg.operators.OpSub;
import breeze.linalg.package$;
import breeze.linalg.support.CanCopy;
import breeze.linalg.support.CanNorm;
import breeze.math.Ring;
import breeze.math.Semiring;
import breeze.storage.DefaultArrayValue;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import org.jblas.NativeBlas;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.IndexedSeq;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class package$
implements LinearAlgebra {
    public static final package$ MODULE$;
    private boolean _useNativeLibraries;
    private Throwable lastBlasError;
    private final URFunc<Object, Object> mean;
    private final URFunc<Object, Object> sum;
    private final URFunc<Object, Tuple2<Object, Object>> meanAndVariance;
    private final URFunc<Object, Object> variance;
    private final URFunc<Object, Object> stddev;
    private final URFunc<Object, Object> max;
    private final URFunc<Object, Object> min;
    private final URFunc<Object, Object> softmax;

    static {
        new package$();
    }

    @Override
    public Tuple3<DenseVector<Object>, DenseVector<Object>, DenseMatrix<Object>> eig(Matrix<Object> m) {
        return LinearAlgebra$class.eig(this, m);
    }

    @Override
    public Tuple3<DenseMatrix<Object>, DenseVector<Object>, DenseMatrix<Object>> svd(DenseMatrix<Object> mat) {
        return LinearAlgebra$class.svd(this, mat);
    }

    @Override
    public <V1, V2, M, RV> DenseMatrix<RV> kron(DenseMatrix<V1> a, M b, BinaryOp<V1, M, OpMulScalar, DenseMatrix<RV>> mul, Predef.$less$colon$less<M, Matrix<V2>> asMat, ClassTag<RV> man, DefaultArrayValue<RV> dfv) {
        return LinearAlgebra$class.kron(this, a, b, mul, asMat, man, dfv);
    }

    @Override
    public <V1> DenseVector<V1> cross(DenseVector<V1> a, DenseVector<V1> b, Ring<V1> ring, ClassTag<V1> man) {
        return LinearAlgebra$class.cross(this, a, b, ring, man);
    }

    @Override
    public <V> double[] ranks(Vector<V> x, Ordering<V> evidence$3) {
        return LinearAlgebra$class.ranks(this, x, evidence$3);
    }

    @Override
    public <T> DenseMatrix<T> lowerTriangular(Matrix<T> X, Semiring<T> evidence$4, ClassTag<T> evidence$5, DefaultArrayValue<T> evidence$6) {
        return LinearAlgebra$class.lowerTriangular(this, X, evidence$4, evidence$5, evidence$6);
    }

    @Override
    public <T> DenseMatrix<T> upperTriangular(Matrix<T> X, Semiring<T> evidence$7, ClassTag<T> evidence$8, DefaultArrayValue<T> evidence$9) {
        return LinearAlgebra$class.upperTriangular(this, X, evidence$7, evidence$8, evidence$9);
    }

    @Override
    public DenseMatrix<Object> cholesky(Matrix<Object> X) {
        return LinearAlgebra$class.cholesky(this, X);
    }

    @Override
    public Tuple4<DenseMatrix<Object>, DenseMatrix<Object>, DenseMatrix<Object>, int[]> qrp(DenseMatrix<Object> A) {
        return LinearAlgebra$class.qrp(this, A);
    }

    @Override
    public Tuple2<DenseMatrix<Object>, DenseMatrix<Object>> qr(DenseMatrix<Object> A, boolean skipQ) {
        return LinearAlgebra$class.qr(this, A, skipQ);
    }

    @Override
    public Tuple2<DenseVector<Object>, Option<DenseMatrix<Object>>> eigSym(Matrix<Object> X, boolean rightEigenvectors) {
        return LinearAlgebra$class.eigSym(this, X, rightEigenvectors);
    }

    @Override
    public <T> Tuple2<DenseMatrix<Object>, int[]> LU(Matrix<T> X, Function1<T, Object> td) {
        return LinearAlgebra$class.LU(this, X, td);
    }

    @Override
    public <T> double det(Matrix<T> X, Function1<T, Object> td) {
        return LinearAlgebra$class.det(this, X, td);
    }

    @Override
    public <T> DenseMatrix<Object> inv(Matrix<T> X, Function1<T, Object> td) {
        return LinearAlgebra$class.inv(this, X, td);
    }

    @Override
    public DenseMatrix<Object> pinv(DenseMatrix<Object> X) {
        return LinearAlgebra$class.pinv(this, X);
    }

    @Override
    public <V> DenseMatrix<Object> pinv(DenseMatrix<V> X, Function1<V, Object> cast) {
        return LinearAlgebra$class.pinv(this, X, cast);
    }

    @Override
    public int rank(DenseMatrix<Object> m, Option<Object> tol) {
        return LinearAlgebra$class.rank(this, m, tol);
    }

    @Override
    public DenseMatrix<Object> pow(DenseMatrix<Object> m, double exp) {
        return LinearAlgebra$class.pow(this, m, exp);
    }

    @Override
    public boolean qr$default$2() {
        return LinearAlgebra$class.qr$default$2(this);
    }

    @Override
    public Option<Object> rank$default$2() {
        return LinearAlgebra$class.rank$default$2(this);
    }

    public boolean useNativeLibraries() {
        return this._useNativeLibraries();
    }

    private boolean _useNativeLibraries() {
        return this._useNativeLibraries;
    }

    private void _useNativeLibraries_$eq(boolean x$1) {
        this._useNativeLibraries = x$1;
    }

    public boolean canLoadNativeBlas() {
        boolean bl;
        try {
            NativeBlas.dcopy((int)0, (double[])new double[0], (int)0, (int)1, (double[])new double[0], (int)0, (int)1);
            bl = true;
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Couldn't load blas!", throwable);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.lastBlasError_$eq(unsatisfiedLinkError);
            if (System.getProperty("os.name").toLowerCase().contains("linux")) {
                Predef$ predef$ = Predef$.MODULE$;
                System.err.println(new StringOps("NOTE: You probably got an error about an unsatisfied link error. Probably you are\n              |      running an old version of GLIBC. Your program will run, just more slowly.\n              |      Also, I can't suppress the prior message, so one more message won't hurt you.").stripMargin('|'));
            }
            bl = false;
        }
        return bl;
    }

    public void useNativeLibraries_$eq(boolean v) {
        if (v && !this.canLoadNativeBlas()) {
            throw new RuntimeException("Can't load NativeBlasLibraries", this.lastBlasError());
        }
        this._useNativeLibraries_$eq(v);
    }

    private Throwable lastBlasError() {
        return this.lastBlasError;
    }

    private void lastBlasError_$eq(Throwable x$1) {
        this.lastBlasError = x$1;
    }

    public <A, X, Y> void axpy(A a, X x, Y y, CanAxpy<A, X, Y> axpy) {
        axpy.apply(a, x, y);
    }

    public <V> DenseVector<V> diag(DenseMatrix<V> m) {
        boolean bl = m.rows() == m.cols();
        Predef$ predef$ = Predef$.MODULE$;
        if (!bl) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"requirement failed: ").append((Object)"m must be square").toString());
        }
        return new DenseVector(m.data(), m.offset(), m.majorStride() + 1, m.rows());
    }

    public <V> DenseVector<V> diagM(DenseMatrix<V> m) {
        return this.diag(m);
    }

    public <V> DenseMatrix<V> diag(DenseVector<V> t, ClassTag<V> evidence$1, DefaultArrayValue<V> evidence$2) {
        Matrix r = DenseMatrix$.MODULE$.zeros(t.length(), t.length(), (ClassTag)evidence$1, (DefaultArrayValue)evidence$2);
        this.diag((DenseMatrix<V>)r).$colon$eq(t, DenseVector$.MODULE$.canSet_DV_DV_Generic());
        return r;
    }

    public DenseVector<Object> linspace(double a, double b, int length) {
        double increment = (b - a) / (double)(length - 1);
        ClassTag classTag = ClassTag$.MODULE$.Double();
        Serializable serializable = new Serializable(a, increment){
            public static final long serialVersionUID = 0L;
            public final double a$1;
            public final double increment$1;

            public final double apply(int i) {
                return this.a$1 + this.increment$1 * (double)i;
            }

            public double apply$mcDI$sp(int i) {
                return this.a$1 + this.increment$1 * (double)i;
            }
            {
                this.a$1 = a$1;
                this.increment$1 = increment$1;
            }
        };
        return (DenseVector)VectorConstructors$class.tabulate$mDc$sp(DenseVector$.MODULE$, length, (Function1)serializable, classTag);
    }

    public int linspace$default$3() {
        return 100;
    }

    public <T> T copy(T t, CanCopy<T> canCopy) {
        return canCopy.apply(t);
    }

    public <T> double norm(T t, double v, CanNorm<T> canNorm) {
        return canNorm.apply(t, v);
    }

    public <T> double norm$default$2() {
        return 2.0;
    }

    public <T, U> U normalize(T t, double n, BinaryOp<T, Object, OpDiv, U> div, CanNorm<T> canNorm, DefaultArrayValue<T> dav) {
        double norm2 = canNorm.apply(t, n);
        return (U)(norm2 == 0.0 ? t : div.apply(t, BoxesRunTime.boxToDouble((double)norm2)));
    }

    public <T, Axis, V, Result> Result normalize(T value, Axis axis, double n, CanCollapseAxis<T, Axis, V, V, Result> collapse, BinaryOp<V, Object, OpDiv, V> div, CanNorm<V> canNorm, DefaultArrayValue<V> dav) {
        return collapse.apply(value, axis, (Function1<V, V>)new Serializable(n, div, canNorm, dav){
            public static final long serialVersionUID = 0L;
            private final double n$1;
            private final BinaryOp div$1;
            private final CanNorm canNorm$1;
            private final DefaultArrayValue dav$1;

            public final V apply(V v) {
                return (V)package$.MODULE$.normalize(v, this.n$1, this.div$1, this.canNorm$1, this.dav$1);
            }
            {
                this.n$1 = n$1;
                this.div$1 = div$1;
                this.canNorm$1 = canNorm$1;
                this.dav$1 = dav$1;
            }
        });
    }

    public <T, U> double normalize$default$2() {
        return 2.0;
    }

    public <V, K> V logNormalize(V value, Function1<V, NumericOps<V>> view, UReduceable<V, Object> red, BinaryOp<V, Object, OpSub, V> op) {
        double max = BoxesRunTime.unboxToDouble((Object)this.softmax().apply$mcD$sp(value, red));
        return max == Double.NEGATIVE_INFINITY ? value : ((NumericOps)view.apply(value)).$minus(BoxesRunTime.boxToDouble((double)max), op);
    }

    public <T, Axis, V, Result> Result logNormalize(T value, Axis axis, CanCollapseAxis<T, Axis, V, V, Result> collapse, Function1<V, NumericOps<V>> view, UReduceable<V, Object> red, CanMapValues<V, Object, Object, V> map2, BinaryOp<V, Object, OpSub, V> op) {
        return collapse.apply(value, axis, (Function1<V, V>)new Serializable(view, red, op){
            public static final long serialVersionUID = 0L;
            private final Function1 view$2;
            private final UReduceable red$2;
            private final BinaryOp op$2;

            public final V apply(V v) {
                return package$.MODULE$.logNormalize(v, this.view$2, this.red$2, this.op$2);
            }
            {
                this.view$2 = view$2;
                this.red$2 = red$2;
                this.op$2 = op$2;
            }
        });
    }

    public <V> V logAndNormalize(V value, Function1<V, NumericOps<V>> view, UReduceable<V, Object> red, CanMapValues<V, Object, Object, V> map2, BinaryOp<V, Object, OpSub, V> op) {
        return this.logNormalize(breeze.numerics.package$.MODULE$.log().apply(value, map2), view, red, op);
    }

    public <T, Axis, V, Result> Result logAndNormalize(T value, Axis axis, CanCollapseAxis<T, Axis, V, V, Result> collapse, Function1<V, NumericOps<V>> view, UReduceable<V, Object> red, CanMapValues<V, Object, Object, V> map2, BinaryOp<V, Object, OpSub, V> op) {
        return collapse.apply(value, axis, (Function1<V, V>)new Serializable(view, red, map2, op){
            public static final long serialVersionUID = 0L;
            private final Function1 view$1;
            private final UReduceable red$1;
            private final CanMapValues map$1;
            private final BinaryOp op$1;

            public final V apply(V v) {
                return package$.MODULE$.logAndNormalize(v, this.view$1, this.red$1, this.map$1, this.op$1);
            }
            {
                this.view$1 = view$1;
                this.red$1 = red$1;
                this.map$1 = map$1;
                this.op$1 = op$1;
            }
        });
    }

    public URFunc<Object, Object> mean() {
        return this.mean;
    }

    public URFunc<Object, Object> sum() {
        return this.sum;
    }

    public URFunc<Object, Tuple2<Object, Object>> meanAndVariance() {
        return this.meanAndVariance;
    }

    public URFunc<Object, Object> variance() {
        return this.variance;
    }

    public URFunc<Object, Object> stddev() {
        return this.stddev;
    }

    public URFunc<Object, Object> max() {
        return this.max;
    }

    public URFunc<Object, Object> min() {
        return this.min;
    }

    public URFunc<Object, Object> softmax() {
        return this.softmax;
    }

    public DenseMatrix<Object> csvread(File file, char separator, char quote, char escape, int skipLines) {
        FileReader input = new FileReader(file);
        ObjectRef mat = new ObjectRef((Object)CSVReader$.MODULE$.read((Reader)input, separator, quote, escape, skipLines));
        mat.elem = (IndexedSeq)((IndexedSeq)mat.elem).takeWhile((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(IndexedSeq<String> line) {
                if (line.length() == 0) return false;
                String string = (String)line.head();
                Predef$ predef$ = Predef$.MODULE$;
                if (!new StringOps(string).nonEmpty()) return false;
                return true;
            }
        });
        input.close();
        return ((IndexedSeq)mat.elem).length() == 0 ? DenseMatrix$.MODULE$.zeros$mDc$sp(0, 0, ClassTag$.MODULE$.Double(), (DefaultArrayValue)DefaultArrayValue.DoubleDefaultArrayValue$.MODULE$) : (DenseMatrix)MatrixConstructors$class.tabulate$mDc$sp(DenseMatrix$.MODULE$, ((IndexedSeq)mat.elem).length(), ((SeqLike)((IndexedSeq)mat.elem).head()).length(), (Function2)new Serializable(mat){
            public static final long serialVersionUID = 0L;
            private final ObjectRef mat$1;

            public final double apply(int i, int j) {
                return this.apply$mcDII$sp(i, j);
            }

            public double apply$mcDII$sp(int i, int j) {
                String string = (String)((SeqLike)((IndexedSeq)this.mat$1.elem).apply(i)).apply(j);
                Predef$ predef$ = Predef$.MODULE$;
                return new StringOps(string).toDouble();
            }
            {
                this.mat$1 = mat$1;
            }
        }, ClassTag$.MODULE$.Double(), (DefaultArrayValue)DefaultArrayValue.DoubleDefaultArrayValue$.MODULE$);
    }

    public char csvread$default$2() {
        return ',';
    }

    public char csvread$default$3() {
        return '\"';
    }

    public char csvread$default$4() {
        return '\\';
    }

    public int csvread$default$5() {
        return 0;
    }

    public void csvwrite(File file, Matrix<Object> mat, char separator, char quote, char escape, int skipLines) {
        CSVWriter$.MODULE$.writeFile(file, (IndexedSeq)scala.package$.MODULE$.IndexedSeq().tabulate(mat.rows(), mat.cols(), (Function2)new Serializable(mat){
            public static final long serialVersionUID = 0L;
            private final Matrix mat$2;

            public final String apply(int x$4, int x$5) {
                return ((Object)BoxesRunTime.boxToDouble((double)this.mat$2.apply$mcD$sp(x$4, x$5))).toString();
            }
            {
                this.mat$2 = mat$2;
            }
        }), separator, quote, escape);
    }

    public char csvwrite$default$3() {
        return ',';
    }

    public char csvwrite$default$4() {
        return '\u0000';
    }

    public char csvwrite$default$5() {
        return '\\';
    }

    public int csvwrite$default$6() {
        return 0;
    }

    public int RichIntMethods(int x) {
        return x;
    }

    public DenseVector<Object> diag$mDc$sp(DenseMatrix<Object> m) {
        boolean bl = m.rows() == m.cols();
        Predef$ predef$ = Predef$.MODULE$;
        if (!bl) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"requirement failed: ").append((Object)"m must be square").toString());
        }
        return new DenseVector$mcD$sp(m.data$mcD$sp(), m.offset(), m.majorStride() + 1, m.rows());
    }

    public DenseVector<Object> diagM$mDc$sp(DenseMatrix<Object> m) {
        return this.diag$mDc$sp(m);
    }

    private package$() {
        MODULE$ = this;
        LinearAlgebra$class.$init$(this);
        this._useNativeLibraries = this.canLoadNativeBlas();
        this.lastBlasError = null;
        this.mean = new anon.1();
        this.sum = new anon.2();
        this.meanAndVariance = new anon.3();
        this.variance = new anon.4();
        this.stddev = new anon.5();
        this.max = new anon.6();
        this.min = new anon.7();
        this.softmax = new anon.8();
    }
}

