/*
 * Decompiled with CFR 0.152.
 */
package breeze.numerics;

import breeze.linalg.operators.CanAxpy$;
import breeze.numerics.Scaling;
import breeze.numerics.package$;
import scala.runtime.BoxesRunTime;

public abstract class Scaling$class {
    public static int scaleArray(Scaling $this, double[] scores, int currentScale) {
        int scaleDelta = $this.computeScaleDelta(scores);
        if (scaleDelta != 0) {
            for (int i = 0; i < scores.length; ++i) {
                scores[i] = Math.scalb(scores[i], -scaleDelta);
            }
        }
        return currentScale + scaleDelta;
    }

    public static int computeScaleDelta(Scaling $this, double[] scores) {
        int maxScale = -10000;
        for (int i = 0; i < scores.length; ++i) {
            double score = scores[i];
            if (score == 0.0) continue;
            int exp = Math.getExponent(score);
            maxScale = scala.math.package$.MODULE$.max(maxScale, exp);
        }
        return maxScale == -10000 ? 0 : (maxScale > $this.scaleConstant() ? $this.scaleConstant() * (maxScale / $this.scaleConstant()) : (maxScale < -$this.scaleConstant() ? $this.scaleConstant() * (maxScale / $this.scaleConstant()) : 0));
    }

    public static int determineScale(Scaling $this, double score, int oldScale) {
        int maxScale;
        return score != 0.0 ? ((maxScale = Math.getExponent(score)) == -10000 ? oldScale : (maxScale > $this.scaleConstant() ? oldScale + $this.scaleConstant() * (maxScale / $this.scaleConstant()) : (maxScale < -$this.scaleConstant() ? oldScale + $this.scaleConstant() * (maxScale / $this.scaleConstant()) : oldScale))) : Integer.MIN_VALUE;
    }

    public static void scaleArrayToScale(Scaling $this, double[] scores, int currentScale, int targetScale) {
        int scaleDelta = targetScale - currentScale;
        if (scaleDelta != 0) {
            for (int i = 0; i < scores.length; ++i) {
                scores[i] = Math.scalb(scores[i], -scaleDelta);
            }
        }
    }

    public static int sumArrays(Scaling $this, double[] src, int srcScale, double[] dest, int destScale) {
        int n;
        if (destScale == srcScale) {
            breeze.linalg.package$.MODULE$.axpy(BoxesRunTime.boxToDouble((double)1.0), src, dest, CanAxpy$.MODULE$.canAxpyDoubleArray());
            n = destScale;
        } else if (destScale - srcScale > 53 + 2 * $this.scaleConstant()) {
            n = destScale;
        } else if (srcScale - destScale > 53 + 2 * $this.scaleConstant()) {
            System.arraycopy(src, 0, dest, 0, dest.length);
            n = srcScale;
        } else if (srcScale > destScale) {
            $this.scaleArrayToScale(dest, destScale, srcScale);
            for (int i = 0; i < dest.length; ++i) {
                dest[i] = dest[i] + src[i];
            }
            n = srcScale;
        } else {
            int scaleDelta = destScale - srcScale;
            for (int i = 0; i < dest.length; ++i) {
                dest[i] = dest[i] + Math.scalb(src[i], -scaleDelta);
            }
            n = destScale;
        }
        return n;
    }

    public static double unscaleValue(Scaling $this, double score, int currentScale) {
        return Math.scalb(score, currentScale);
    }

    public static double scaleValue(Scaling $this, double score, int currentScale, int targetScale) {
        return Math.scalb(score, currentScale - targetScale);
    }

    public static double toLogSpace(Scaling $this, double score, int currentScale) {
        return package$.MODULE$.log().apply$mcDD$sp(score) + (double)currentScale * package$.MODULE$.log().apply$mcDD$sp(2.0);
    }

    public static void $init$(Scaling $this) {
    }
}

