/*
 * Decompiled with CFR 0.152.
 */
package breeze.numerics;

import breeze.UniversalFuncs;
import breeze.UniversalFuncs$class;
import breeze.generic.CanMapValues;
import breeze.generic.CanTransformValues;
import breeze.generic.UFunc;
import breeze.generic.UFunc$;
import breeze.generic.UFunc$class;
import breeze.generic.URFunc;
import breeze.numerics.package$;
import org.apache.commons.math3.special.Gamma;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble;
import scala.runtime.RichDouble$;

public final class package$
implements UniversalFuncs {
    public static final package$ MODULE$;
    private final double inf;
    private final double Inf;
    private final double nan;
    private final double NaN;
    private final URFunc<Object, Object> lbeta;
    private final UFunc<Object, Object> lgamma;
    private final UFunc<Object, Object> digamma;
    private final UFunc<Object, Object> trigamma;
    private final UFunc<Object, Object> erf;
    private final UFunc<Object, Object> erfc;
    private final UFunc<Object, Object> erfi;
    private final UFunc<Object, Object> erfinv;
    private final UFunc<Object, Object> erfcinv;
    private final UFunc<Object, Object> I;
    private final UFunc<Object, Object> logI;
    private final UFunc<Object, Object> exp;
    private final UFunc<Object, Object> log;
    private final UFunc<Object, Object> log1p;
    private final UFunc<Object, Object> sqrt;
    private final UFunc<Object, Object> sin;
    private final UFunc<Object, Object> cos;
    private final UFunc<Object, Object> tan;
    private final UFunc<Object, Object> asin;
    private final UFunc<Object, Object> acos;
    private final UFunc<Object, Object> atan;
    private final UFunc<Object, Object> toDegrees;
    private final UFunc<Object, Object> toRadians;
    private final UFunc<Object, Object> floor;
    private final UFunc<Object, Object> ceil;
    private final UFunc<Object, Object> round;
    private final UFunc<Object, Object> rint;
    private final UFunc<Object, Object> signum;
    private final UFunc<Object, Object> abs;

    static {
        new package$();
    }

    @Override
    public UFunc<Object, Object> exp() {
        return this.exp;
    }

    @Override
    public UFunc<Object, Object> log() {
        return this.log;
    }

    @Override
    public UFunc<Object, Object> log1p() {
        return this.log1p;
    }

    @Override
    public UFunc<Object, Object> sqrt() {
        return this.sqrt;
    }

    @Override
    public UFunc<Object, Object> sin() {
        return this.sin;
    }

    @Override
    public UFunc<Object, Object> cos() {
        return this.cos;
    }

    @Override
    public UFunc<Object, Object> tan() {
        return this.tan;
    }

    @Override
    public UFunc<Object, Object> asin() {
        return this.asin;
    }

    @Override
    public UFunc<Object, Object> acos() {
        return this.acos;
    }

    @Override
    public UFunc<Object, Object> atan() {
        return this.atan;
    }

    @Override
    public UFunc<Object, Object> toDegrees() {
        return this.toDegrees;
    }

    @Override
    public UFunc<Object, Object> toRadians() {
        return this.toRadians;
    }

    @Override
    public UFunc<Object, Object> floor() {
        return this.floor;
    }

    @Override
    public UFunc<Object, Object> ceil() {
        return this.ceil;
    }

    @Override
    public UFunc<Object, Object> round() {
        return this.round;
    }

    @Override
    public UFunc<Object, Object> rint() {
        return this.rint;
    }

    @Override
    public UFunc<Object, Object> signum() {
        return this.signum;
    }

    @Override
    public UFunc<Object, Object> abs() {
        return this.abs;
    }

    @Override
    public void breeze$UniversalFuncs$_setter_$exp_$eq(UFunc x$1) {
        this.exp = x$1;
    }

    @Override
    public void breeze$UniversalFuncs$_setter_$log_$eq(UFunc x$1) {
        this.log = x$1;
    }

    @Override
    public void breeze$UniversalFuncs$_setter_$log1p_$eq(UFunc x$1) {
        this.log1p = x$1;
    }

    @Override
    public void breeze$UniversalFuncs$_setter_$sqrt_$eq(UFunc x$1) {
        this.sqrt = x$1;
    }

    @Override
    public void breeze$UniversalFuncs$_setter_$sin_$eq(UFunc x$1) {
        this.sin = x$1;
    }

    @Override
    public void breeze$UniversalFuncs$_setter_$cos_$eq(UFunc x$1) {
        this.cos = x$1;
    }

    @Override
    public void breeze$UniversalFuncs$_setter_$tan_$eq(UFunc x$1) {
        this.tan = x$1;
    }

    @Override
    public void breeze$UniversalFuncs$_setter_$asin_$eq(UFunc x$1) {
        this.asin = x$1;
    }

    @Override
    public void breeze$UniversalFuncs$_setter_$acos_$eq(UFunc x$1) {
        this.acos = x$1;
    }

    @Override
    public void breeze$UniversalFuncs$_setter_$atan_$eq(UFunc x$1) {
        this.atan = x$1;
    }

    @Override
    public void breeze$UniversalFuncs$_setter_$toDegrees_$eq(UFunc x$1) {
        this.toDegrees = x$1;
    }

    @Override
    public void breeze$UniversalFuncs$_setter_$toRadians_$eq(UFunc x$1) {
        this.toRadians = x$1;
    }

    @Override
    public void breeze$UniversalFuncs$_setter_$floor_$eq(UFunc x$1) {
        this.floor = x$1;
    }

    @Override
    public void breeze$UniversalFuncs$_setter_$ceil_$eq(UFunc x$1) {
        this.ceil = x$1;
    }

    @Override
    public void breeze$UniversalFuncs$_setter_$round_$eq(UFunc x$1) {
        this.round = x$1;
    }

    @Override
    public void breeze$UniversalFuncs$_setter_$rint_$eq(UFunc x$1) {
        this.rint = x$1;
    }

    @Override
    public void breeze$UniversalFuncs$_setter_$signum_$eq(UFunc x$1) {
        this.signum = x$1;
    }

    @Override
    public void breeze$UniversalFuncs$_setter_$abs_$eq(UFunc x$1) {
        this.abs = x$1;
    }

    public double inf() {
        return this.inf;
    }

    public double Inf() {
        return this.Inf;
    }

    public double nan() {
        return this.nan;
    }

    public double NaN() {
        return this.NaN;
    }

    public URFunc<Object, Object> lbeta() {
        return this.lbeta;
    }

    public UFunc<Object, Object> lgamma() {
        return this.lgamma;
    }

    public UFunc<Object, Object> digamma() {
        return this.digamma;
    }

    public UFunc<Object, Object> trigamma() {
        return this.trigamma;
    }

    public UFunc<Object, Object> erf() {
        return this.erf;
    }

    public UFunc<Object, Object> erfc() {
        return this.erfc;
    }

    public UFunc<Object, Object> erfi() {
        return this.erfi;
    }

    public UFunc<Object, Object> erfinv() {
        return this.erfinv;
    }

    public UFunc<Object, Object> erfcinv() {
        return this.erfcinv;
    }

    public double gammp(double a, double x) {
        return Gamma.regularizedGammaP((double)a, (double)x);
    }

    public double lgamma(double a, double x) {
        return this._lgamma(a, x, this._lgamma$default$3());
    }

    private double _lgamma(double a, double x, double[] lgam) {
        double d;
        if (x < 0.0 || a <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (x == 0.0) {
            d = 0.0;
        } else if (x < a + 1.0) {
            double ap = a;
            double del = 1.0 / a;
            double sum = 1.0 / a;
            double result = Double.NaN;
            for (int n = 0; n < 100; ++n) {
                sum += (del *= x / (ap += 1.0));
                if (!(scala.math.package$.MODULE$.abs(del) < scala.math.package$.MODULE$.abs(sum) * 1.0E-7)) continue;
                result = -x + a * scala.math.package$.MODULE$.log(x) + scala.math.package$.MODULE$.log(sum);
                n = 100;
            }
            if (lgam != null) {
                lgam[0] = Double.NaN;
            }
            if (Predef$.MODULE$.double2Double(result).isNaN()) {
                throw new ArithmeticException("Convergence failed");
            }
            d = result;
        } else {
            double d2;
            double gln = this.lgamma().apply$mcDD$sp(a);
            double b = x + 1.0 - a;
            double c = 9.999999999999999E29;
            double h = d2 = 1.0 / b;
            int n = 0;
            while (n < 100) {
                double an;
                if (scala.math.package$.MODULE$.abs(d2 = (an = (double)(-(++n)) * ((double)n - a)) * d2 + (b += 2.0)) < 1.0E-30) {
                    d2 = 1.0E-30;
                }
                if (scala.math.package$.MODULE$.abs(c = b + an / c) < 1.0E-30) {
                    c = 1.0E-30;
                }
                d2 = 1.0 / d2;
                double del = d2 * c;
                h *= del;
                if (!(scala.math.package$.MODULE$.abs(del - 1.0) < 1.0E-7)) continue;
                n = 101;
            }
            if (lgam != null) {
                lgam[0] = gln;
            }
            if (n == 100) {
                throw new ArithmeticException("Convergence failed");
            }
            d = this.logDiff(gln, -x + a * this.log().apply$mcDD$sp(x) + scala.math.package$.MODULE$.log(h));
        }
        return d;
    }

    private double[] _lgamma$default$3() {
        return null;
    }

    public double logSum(double a, double b) {
        double d;
        Predef$ predef$ = Predef$.MODULE$;
        if (RichDouble$.MODULE$.isNegInfinity$extension(a)) {
            d = b;
        } else {
            Predef$ predef$2 = Predef$.MODULE$;
            d = RichDouble$.MODULE$.isNegInfinity$extension(b) ? a : (a < b ? b + scala.math.package$.MODULE$.log1p(this.exp().apply$mcDD$sp(a - b)) : a + scala.math.package$.MODULE$.log1p(this.exp().apply$mcDD$sp(b - a)));
        }
        return d;
    }

    public double logSum(double a, double b, Seq<Object> c) {
        double d;
        if (c.length() == 0) {
            d = this.logSum(a, b);
        } else {
            double d2 = this.logSum(a, b);
            d = this.logSum((Seq<Object>)((Seq)c.$plus$colon((Object)BoxesRunTime.boxToDouble((double)d2), Seq$.MODULE$.canBuildFrom())));
        }
        return d;
    }

    public double logSum(Iterator<Object> iter, double max) {
        double aux;
        Predef$.MODULE$.require(iter.hasNext());
        return Predef$.MODULE$.double2Double(max).isInfinite() ? max : ((aux = BoxesRunTime.unboxToDouble((Object)iter.$div$colon((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(max){
            public static final long serialVersionUID = 0L;
            private final double max$1;

            public final double apply(double acc, double x) {
                return this.apply$mcDDD$sp(acc, x);
            }

            public double apply$mcDDD$sp(double acc, double x) {
                Predef$ predef$ = Predef$.MODULE$;
                return RichDouble$.MODULE$.isNegInfinity$extension(x) ? acc : acc + package$.MODULE$.exp().apply$mcDD$sp(x - this.max$1);
            }
            {
                this.max$1 = max$1;
            }
        }))) != 0.0 ? max + scala.math.package$.MODULE$.log(aux) : max);
    }

    public double logSum(Seq<Object> a) {
        double d;
        int n = a.length();
        switch (n) {
            default: {
                d = this.logSum((Iterator<Object>)a.iterator(), BoxesRunTime.unboxToDouble((Object)a.reduceLeft((Function2)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x$3, double x$4) {
                        return this.apply$mcDDD$sp(x$3, x$4);
                    }

                    public double apply$mcDDD$sp(double x$3, double x$4) {
                        Predef$ predef$ = Predef$.MODULE$;
                        return BoxesRunTime.unboxToDouble((Object)new RichDouble(x$3).max((Object)BoxesRunTime.boxToDouble((double)x$4)));
                    }
                })));
                break;
            }
            case 2: {
                d = this.logSum(BoxesRunTime.unboxToDouble((Object)a.apply(0)), BoxesRunTime.unboxToDouble((Object)a.apply(1)));
                break;
            }
            case 1: {
                d = BoxesRunTime.unboxToDouble((Object)a.apply(0));
                break;
            }
            case 0: {
                d = Double.NEGATIVE_INFINITY;
            }
        }
        return d;
    }

    public double logSum(double[] a, int length) {
        double d;
        switch (length) {
            default: {
                double m = this.max(a, length);
                if (Predef$.MODULE$.double2Double(m).isInfinite()) {
                    d = m;
                    break;
                }
                double accum = 0.0;
                for (int i = 0; i < length; ++i) {
                    accum += scala.math.package$.MODULE$.exp(a[i] - m);
                }
                d = m + scala.math.package$.MODULE$.log(accum);
                break;
            }
            case 2: {
                d = this.logSum(a[0], a[1]);
                break;
            }
            case 1: {
                d = a[0];
                break;
            }
            case 0: {
                d = Double.NEGATIVE_INFINITY;
            }
        }
        return d;
    }

    public double max(double[] a, int length) {
        double max = a[0];
        for (int i = 1; i < length; ++i) {
            if (!(a[i] > max)) continue;
            max = a[i];
        }
        return max;
    }

    public UFunc<Object, Object> sigmoid() {
        Serializable serializable = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return 1.0 / (1.0 + scala.math.package$.MODULE$.exp(-x));
            }
        };
        UFunc$ uFunc$ = UFunc$.MODULE$;
        return new UFunc<Object, Object>((Function1)serializable){
            private final Function1 f$2;

            public double apply$mcDD$sp(double v) {
                return UFunc$class.apply$mcDD$sp(this, v);
            }

            public float apply$mcDF$sp(double v) {
                return UFunc$class.apply$mcDF$sp(this, v);
            }

            public int apply$mcDI$sp(double v) {
                return UFunc$class.apply$mcDI$sp(this, v);
            }

            public double apply$mcFD$sp(float v) {
                return UFunc$class.apply$mcFD$sp(this, v);
            }

            public float apply$mcFF$sp(float v) {
                return UFunc$class.apply$mcFF$sp(this, v);
            }

            public int apply$mcFI$sp(float v) {
                return UFunc$class.apply$mcFI$sp(this, v);
            }

            public double apply$mcID$sp(int v) {
                return UFunc$class.apply$mcID$sp(this, v);
            }

            public float apply$mcIF$sp(int v) {
                return UFunc$class.apply$mcIF$sp(this, v);
            }

            public int apply$mcII$sp(int v) {
                return UFunc$class.apply$mcII$sp(this, v);
            }

            public <T, U> U apply(T t, CanMapValues<T, Object, Object, U> cmv) {
                return (U)UFunc$class.apply(this, t, cmv);
            }

            public <T, U> U applyActive(T t, CanMapValues<T, Object, Object, U> cmv) {
                return (U)UFunc$class.applyActive(this, t, cmv);
            }

            public <T> void inPlace(T t, CanTransformValues<T, Object, Object> ctv) {
                UFunc$class.inPlace(this, t, ctv);
            }

            public double apply(double v) {
                return this.f$2.apply$mcDD$sp(v);
            }
            {
                this.f$2 = f$2;
                UFunc$class.$init$(this);
            }
        };
    }

    public double logDiff(double a, double b) {
        Predef$.MODULE$.require(a >= b);
        return a > b ? a + this.log().apply$mcDD$sp(1.0 - this.exp().apply$mcDD$sp(b - a)) : Double.NEGATIVE_INFINITY;
    }

    public double polyval(double[] coefs, double x) {
        int i = coefs.length - 1;
        double p = coefs[i];
        while (i > 0) {
            p = p * x + coefs[--i];
        }
        return p;
    }

    public boolean closeTo(double a, double b, double relDiff) {
        return a == b || scala.math.package$.MODULE$.abs(a - b) < scala.math.package$.MODULE$.max(scala.math.package$.MODULE$.max(scala.math.package$.MODULE$.abs(a), scala.math.package$.MODULE$.abs(b)), 1.0) * relDiff;
    }

    public double closeTo$default$3() {
        return 1.0E-4;
    }

    public UFunc<Object, Object> I() {
        return this.I;
    }

    public UFunc<Object, Object> logI() {
        return this.logI;
    }

    private package$() {
        MODULE$ = this;
        UniversalFuncs$class.$init$(this);
        this.inf = Double.POSITIVE_INFINITY;
        this.Inf = Double.POSITIVE_INFINITY;
        this.nan = Double.NaN;
        this.NaN = Double.NaN;
        this.lbeta = new anon.1();
        anonfun.1 var2_1 = new anonfun.1();
        UFunc$ uFunc$ = UFunc$.MODULE$;
        this.lgamma = new /* invalid duplicate definition of identical inner class */;
        anonfun.2 var4_3 = new anonfun.2();
        UFunc$ uFunc$2 = UFunc$.MODULE$;
        this.digamma = new /* invalid duplicate definition of identical inner class */;
        anonfun.3 var6_5 = new anonfun.3();
        UFunc$ uFunc$3 = UFunc$.MODULE$;
        this.trigamma = new /* invalid duplicate definition of identical inner class */;
        this.erf = UFunc$.MODULE$.apply$mDDc$sp((Function1<Object, Object>)new anonfun.4());
        this.erfc = UFunc$.MODULE$.apply$mDDc$sp((Function1<Object, Object>)new anonfun.5());
        this.erfi = new anon.2();
        this.erfinv = UFunc$.MODULE$.apply$mDDc$sp((Function1<Object, Object>)new anonfun.6());
        this.erfcinv = UFunc$.MODULE$.apply$mDDc$sp((Function1<Object, Object>)new anonfun.7());
        this.I = new anon.3();
        this.logI = new anon.4();
    }
}

