/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest;

import java.io.Serializable;
import org.scalatest.Args;
import org.scalatest.Args$;
import org.scalatest.ConfigMap;
import org.scalatest.Distributor;
import org.scalatest.Filter;
import org.scalatest.Reporter;
import org.scalatest.Rerunner;
import org.scalatest.Resources$;
import org.scalatest.Stopper;
import org.scalatest.Suite;
import org.scalatest.Tracker;
import org.scalatest.events.RunAborted;
import org.scalatest.events.RunAborted$;
import org.scalatest.events.RunCompleted;
import org.scalatest.events.RunCompleted$;
import org.scalatest.events.RunStarting;
import org.scalatest.events.RunStarting$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001i3Q!\u0001\u0002\u0001\u0005\u0019\u0011A\u0002V3tiJ+'/\u001e8oKJT!a\u0001\u0003\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\u0003\u0002\u0007=\u0014xm\u0005\u0003\u0001\u000f=\u0019\u0002C\u0001\u0005\u000e\u001b\u0005I!B\u0001\u0006\f\u0003\u0011a\u0017M\\4\u000b\u00031\tAA[1wC&\u0011a\"\u0003\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005A\tR\"\u0001\u0002\n\u0005I\u0011!\u0001\u0003*feVtg.\u001a:\u0011\u0005Q9R\"A\u000b\u000b\u0005YY\u0011AA5p\u0013\tARC\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u001b\u0001\t\u0005\t\u0015!\u0003\u001d\u00039\u0019X/\u001b;f\u00072\f7o\u001d(b[\u0016\u001c\u0001\u0001\u0005\u0002\u001eG9\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\u00051\u0001K]3eK\u001aL!\u0001J\u0013\u0003\rM#(/\u001b8h\u0015\t\u0011s\u0004\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003\u001d\u0003!!Xm\u001d;OC6,\u0007\"B\u0015\u0001\t\u0003Q\u0013A\u0002\u001fj]&$h\bF\u0002,Y5\u0002\"\u0001\u0005\u0001\t\u000biA\u0003\u0019\u0001\u000f\t\u000b\u001dB\u0003\u0019\u0001\u000f\t\u000b=\u0002A\u0011\u0001\u0019\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0011E\"\u0014HP\"I!V\u0003\"A\b\u001a\n\u0005Mz\"\u0001B+oSRDQ!\u000e\u0018A\u0002Y\naA]3q_J$\bC\u0001\t8\u0013\tA$A\u0001\u0005SKB|'\u000f^3s\u0011\u0015Qd\u00061\u0001<\u0003\u001d\u0019Ho\u001c9qKJ\u0004\"\u0001\u0005\u001f\n\u0005u\u0012!aB*u_B\u0004XM\u001d\u0005\u0006\u007f9\u0002\r\u0001Q\u0001\u0007M&dG/\u001a:\u0011\u0005A\t\u0015B\u0001\"\u0003\u0005\u00191\u0015\u000e\u001c;fe\")AI\fa\u0001\u000b\u0006I1m\u001c8gS\u001el\u0015\r\u001d\t\u0003!\u0019K!a\u0012\u0002\u0003\u0013\r{gNZ5h\u001b\u0006\u0004\b\"B%/\u0001\u0004Q\u0015a\u00033jgR\u0014\u0018NY;u_J\u00042AH&N\u0013\tauD\u0001\u0004PaRLwN\u001c\t\u0003!9K!a\u0014\u0002\u0003\u0017\u0011K7\u000f\u001e:jEV$xN\u001d\u0005\u0006#:\u0002\rAU\u0001\biJ\f7m[3s!\t\u00012+\u0003\u0002U\u0005\t9AK]1dW\u0016\u0014\b\"\u0002,/\u0001\u00049\u0016A\u00027pC\u0012,'\u000f\u0005\u0002\t1&\u0011\u0011,\u0003\u0002\f\u00072\f7o\u001d'pC\u0012,'\u000f")
public class TestRerunner
implements Rerunner,
Serializable {
    private final String suiteClassName;
    private final String testName;

    @Override
    public void apply(Reporter report, Stopper stopper, Filter filter2, ConfigMap configMap, Option<Distributor> distributor, Tracker tracker, ClassLoader loader) {
        long runStartTime = System.currentTimeMillis();
        try {
            Class<?> suiteClass = loader.loadClass(this.suiteClassName);
            Suite suite = (Suite)suiteClass.newInstance();
            report.apply(new RunStarting(tracker.nextOrdinal(), 1, configMap, RunStarting$.MODULE$.apply$default$4(), RunStarting$.MODULE$.apply$default$5(), RunStarting$.MODULE$.apply$default$6(), RunStarting$.MODULE$.apply$default$7(), RunStarting$.MODULE$.apply$default$8()));
            suite.run((Option<String>)new Some((Object)this.testName), new Args(report, stopper, filter2, configMap, distributor, tracker, (Set<String>)Predef$.MODULE$.Set().empty(), Args$.MODULE$.apply$default$8(), Args$.MODULE$.apply$default$9(), Args$.MODULE$.apply$default$10()));
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(new RunCompleted(tracker.nextOrdinal(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration)), RunCompleted$.MODULE$.apply$default$3(), RunCompleted$.MODULE$.apply$default$4(), RunCompleted$.MODULE$.apply$default$5(), RunCompleted$.MODULE$.apply$default$6(), RunCompleted$.MODULE$.apply$default$7(), RunCompleted$.MODULE$.apply$default$8()));
        }
        catch (Throwable throwable) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(new RunAborted(tracker.nextOrdinal(), Resources$.MODULE$.bigProblems(throwable), (Option<Throwable>)new Some((Object)throwable), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration)), RunAborted$.MODULE$.apply$default$5(), RunAborted$.MODULE$.apply$default$6(), RunAborted$.MODULE$.apply$default$7(), RunAborted$.MODULE$.apply$default$8(), RunAborted$.MODULE$.apply$default$9(), RunAborted$.MODULE$.apply$default$10()));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(new RunAborted(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotLoadClass", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{noClassDefFoundError.getMessage()})), (Option<Throwable>)new Some((Object)noClassDefFoundError), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration)), RunAborted$.MODULE$.apply$default$5(), RunAborted$.MODULE$.apply$default$6(), RunAborted$.MODULE$.apply$default$7(), RunAborted$.MODULE$.apply$default$8(), RunAborted$.MODULE$.apply$default$9(), RunAborted$.MODULE$.apply$default$10()));
        }
        catch (SecurityException securityException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(new RunAborted(tracker.nextOrdinal(), Resources$.MODULE$.apply("securityWhenRerruning", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{securityException.getMessage()})), (Option<Throwable>)new Some((Object)securityException), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration)), RunAborted$.MODULE$.apply$default$5(), RunAborted$.MODULE$.apply$default$6(), RunAborted$.MODULE$.apply$default$7(), RunAborted$.MODULE$.apply$default$8(), RunAborted$.MODULE$.apply$default$9(), RunAborted$.MODULE$.apply$default$10()));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(new RunAborted(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotFindMethod", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{noSuchMethodException.getMessage()})), (Option<Throwable>)new Some((Object)noSuchMethodException), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration)), RunAborted$.MODULE$.apply$default$5(), RunAborted$.MODULE$.apply$default$6(), RunAborted$.MODULE$.apply$default$7(), RunAborted$.MODULE$.apply$default$8(), RunAborted$.MODULE$.apply$default$9(), RunAborted$.MODULE$.apply$default$10()));
        }
        catch (IllegalAccessException illegalAccessException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(new RunAborted(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotInstantiateSuite", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{illegalAccessException.getMessage()})), (Option<Throwable>)new Some((Object)illegalAccessException), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration)), RunAborted$.MODULE$.apply$default$5(), RunAborted$.MODULE$.apply$default$6(), RunAborted$.MODULE$.apply$default$7(), RunAborted$.MODULE$.apply$default$8(), RunAborted$.MODULE$.apply$default$9(), RunAborted$.MODULE$.apply$default$10()));
        }
        catch (InstantiationException instantiationException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(new RunAborted(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotInstantiateSuite", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{instantiationException.getMessage()})), (Option<Throwable>)new Some((Object)instantiationException), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration)), RunAborted$.MODULE$.apply$default$5(), RunAborted$.MODULE$.apply$default$6(), RunAborted$.MODULE$.apply$default$7(), RunAborted$.MODULE$.apply$default$8(), RunAborted$.MODULE$.apply$default$9(), RunAborted$.MODULE$.apply$default$10()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(new RunAborted(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotLoadSuite", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{classNotFoundException.getMessage()})), (Option<Throwable>)new Some((Object)classNotFoundException), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration)), RunAborted$.MODULE$.apply$default$5(), RunAborted$.MODULE$.apply$default$6(), RunAborted$.MODULE$.apply$default$7(), RunAborted$.MODULE$.apply$default$8(), RunAborted$.MODULE$.apply$default$9(), RunAborted$.MODULE$.apply$default$10()));
        }
    }

    public TestRerunner(String suiteClassName, String testName) {
        this.suiteClassName = suiteClassName;
        this.testName = testName;
        if (suiteClassName == null || testName == null) {
            throw new NullPointerException();
        }
    }
}

