/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.junit;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.scalatest.Reporter;
import org.scalatest.Rerunner;
import org.scalatest.Resources$;
import org.scalatest.Suite$;
import org.scalatest.Tracker;
import org.scalatest.events.Formatter;
import org.scalatest.events.IndentedText;
import org.scalatest.events.MotionToSuppress$;
import org.scalatest.events.TestFailed$;
import org.scalatest.events.TestIgnored$;
import org.scalatest.events.TestStarting$;
import org.scalatest.events.TestSucceeded$;
import org.scalatest.exceptions.PayloadField;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a!B\u0001\u0003\u0001\tA!!D'z%VtG*[:uK:,'O\u0003\u0002\u0004\t\u0005)!.\u001e8ji*\u0011QAB\u0001\ng\u000e\fG.\u0019;fgRT\u0011aB\u0001\u0004_J<7c\u0001\u0001\n%A\u0011!\u0002E\u0007\u0002\u0017)\u0011A\"D\u0001\r]>$\u0018NZ5dCRLwN\u001c\u0006\u0003\u001d=\taA];o]\u0016\u0014(BA\u0002\u0007\u0013\t\t2BA\u0006Sk:d\u0015n\u001d;f]\u0016\u0014\bCA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"aC*dC2\fwJ\u00196fGRD\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IaG\u0001\u0007e\u0016\u0004xN\u001d;\u0004\u0001A\u0011A$H\u0007\u0002\t%\u0011a\u0004\u0002\u0002\t%\u0016\u0004xN\u001d;fe\"A\u0001\u0005\u0001B\u0001B\u0003%\u0011%\u0001\u0004d_:4\u0017n\u001a\t\u0005E\u0015B3F\u0004\u0002\u0014G%\u0011A\u0005F\u0001\u0007!J,G-\u001a4\n\u0005\u0019:#aA'ba*\u0011A\u0005\u0006\t\u0003E%J!AK\u0014\u0003\rM#(/\u001b8h!\t\u0019B&\u0003\u0002.)\t\u0019\u0011I\\=\t\u0011=\u0002!\u0011!Q\u0001\nA\n!\u0002\u001e5f)J\f7m[3s!\ta\u0012'\u0003\u00023\t\t9AK]1dW\u0016\u0014\b\"\u0002\u001b\u0001\t\u0003)\u0014A\u0002\u001fj]&$h\b\u0006\u00037qeR\u0004CA\u001c\u0001\u001b\u0005\u0011\u0001\"B\r4\u0001\u0004Y\u0002\"\u0002\u00114\u0001\u0004\t\u0003\"B\u00184\u0001\u0004\u0001\u0004b\u0002\u001f\u0001\u0005\u0004%\t!P\u0001\fM\u0006LG.\u001a3UKN$8/F\u0001?!\ryD\tK\u0007\u0002\u0001*\u0011\u0011IQ\u0001\u0005kRLGNC\u0001D\u0003\u0011Q\u0017M^1\n\u0005\u0015\u0003%aA*fi\"1q\t\u0001Q\u0001\ny\nABZ1jY\u0016$G+Z:ug\u0002BQ!\u0013\u0001\u0005B)\u000b1\u0002^3ti\u001a\u000b\u0017\u000e\\;sKR\u00111J\u0014\t\u0003'1K!!\u0014\u000b\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u001f\"\u0003\r\u0001U\u0001\bM\u0006LG.\u001e:f!\tQ\u0011+\u0003\u0002S\u0017\t9a)Y5mkJ,\u0007\"\u0002+\u0001\t\u0003*\u0016\u0001\u0004;fgR4\u0015N\\5tQ\u0016$GCA&W\u0011\u001596\u000b1\u0001Y\u0003-!Wm]2sSB$\u0018n\u001c8\u0011\u0005eSV\"A\u0007\n\u0005mk!a\u0003#fg\u000e\u0014\u0018\u000e\u001d;j_:DQ!\u0018\u0001\u0005By\u000b1\u0002^3ti&;gn\u001c:fIR\u00111j\u0018\u0005\u0006/r\u0003\r\u0001\u0017\u0005\u0006C\u0002!\tEY\u0001\u0010i\u0016\u001cHOU;o\r&t\u0017n\u001d5fIR\u00111j\u0019\u0005\u0006I\u0002\u0004\r!Z\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0011\u0005e3\u0017BA4\u000e\u0005\u0019\u0011Vm];mi\")\u0011\u000e\u0001C!U\u0006qA/Z:u%Vt7\u000b^1si\u0016$GCA&l\u0011\u00159\u0006\u000e1\u0001Y\u0011\u0015i\u0007\u0001\"\u0011o\u0003-!Xm\u001d;Ti\u0006\u0014H/\u001a3\u0015\u0005-{\u0007\"B,m\u0001\u0004A\u0006bB9\u0001\u0005\u0004%\tA]\u0001\u0019)\u0016\u001bFk\u0018#F'\u000e\u0013\u0016\n\u0015+J\u001f:{\u0006+\u0011+U\u000bJsU#A:\u0011\u0005Q<X\"A;\u000b\u0005Y\u0004\u0015!\u0002:fO\u0016D\u0018B\u0001=v\u0005\u001d\u0001\u0016\r\u001e;fe:DaA\u001f\u0001!\u0002\u0013\u0019\u0018!\u0007+F'R{F)R*D%&\u0003F+S(O?B\u000bE\u000bV#S\u001d\u0002BQ\u0001 \u0001\u0005\nu\fA\u0003]1sg\u0016$Vm\u001d;EKN\u001c'/\u001b9uS>tGc\u0001@\u0002\u0004A)1c \u0015)Q%\u0019\u0011\u0011\u0001\u000b\u0003\rQ+\b\u000f\\34\u0011\u001596\u00101\u0001Y\u0001")
public class MyRunListener
extends RunListener
implements ScalaObject {
    private final Reporter report;
    private final Tracker theTracker;
    private final Set<String> failedTests;
    private final Pattern TEST_DESCRIPTION_PATTERN;

    public Set<String> failedTests() {
        return this.failedTests;
    }

    public void testFailure(Failure failure) {
        this.failedTests().add(failure.getDescription().getDisplayName());
        Tuple3<String, String, String> tuple3 = this.parseTestDescription(failure.getDescription());
        if (tuple3 != null) {
            Tuple3 tuple32 = new Tuple3(tuple3._1(), tuple3._2(), tuple3._3());
            String testName = (String)tuple32._1();
            String testClass = (String)tuple32._2();
            String testClassName = (String)tuple32._3();
            Throwable throwableOrNull = failure.getException();
            None$ throwable = throwableOrNull == null ? None$.MODULE$ : new Some((Object)throwableOrNull);
            String message = throwableOrNull == null ? Resources$.MODULE$.apply("jUnitTestFailed") : throwableOrNull.toString();
            IndentedText formatter = Suite$.MODULE$.getIndentedText(testName, 1, true);
            None$ none$ = throwable;
            Option<Object> payload = none$ instanceof Option && none$ instanceof PayloadField ? ((PayloadField)none$).payload() : None$.MODULE$;
            this.report.apply(TestFailed$.MODULE$.apply(this.theTracker.nextOrdinal(), message, testClassName, (Option<String>)new Some((Object)testClass), testName, (Option<Throwable>)throwable, (Option<Object>)None$.MODULE$, (Option<Formatter>)new Some((Object)formatter), (Option<Rerunner>)None$.MODULE$, payload));
            return;
        }
        throw new MatchError(tuple3);
    }

    public void testFinished(Description description) {
        Tuple3<String, String, String> tuple3;
        block3: {
            block2: {
                if (this.failedTests().contains(description.getDisplayName())) break block2;
                tuple3 = this.parseTestDescription(description);
                if (tuple3 == null) break block3;
                Tuple3 tuple32 = new Tuple3(tuple3._1(), tuple3._2(), tuple3._3());
                String testName = (String)tuple32._1();
                String testClass = (String)tuple32._2();
                String testClassName = (String)tuple32._3();
                IndentedText formatter = Suite$.MODULE$.getIndentedText(testName, 1, true);
                this.report.apply(TestSucceeded$.MODULE$.apply(this.theTracker.nextOrdinal(), testClassName, (Option<String>)new Some((Object)testClass), testName, (Option<Object>)None$.MODULE$, (Option<Formatter>)new Some((Object)formatter), (Option<Rerunner>)None$.MODULE$));
            }
            return;
        }
        throw new MatchError(tuple3);
    }

    public void testIgnored(Description description) {
        Tuple3<String, String, String> tuple3 = this.parseTestDescription(description);
        if (tuple3 != null) {
            Tuple3 tuple32 = new Tuple3(tuple3._1(), tuple3._2(), tuple3._3());
            String testName = (String)tuple32._1();
            String testClass = (String)tuple32._2();
            String testClassName = (String)tuple32._3();
            String testSucceededIcon = Resources$.MODULE$.apply("testSucceededIconChar");
            String formattedText = Resources$.MODULE$.apply("iconPlusShortName", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{testSucceededIcon, testName}));
            this.report.apply(TestIgnored$.MODULE$.apply(this.theTracker.nextOrdinal(), testClassName, (Option<String>)new Some((Object)testClass), testName, (Option<Formatter>)new Some((Object)new IndentedText(formattedText, testName, 1))));
            return;
        }
        throw new MatchError(tuple3);
    }

    public void testRunFinished(Result result) {
    }

    public void testRunStarted(Description description) {
    }

    public void testStarted(Description description) {
        Tuple3<String, String, String> tuple3 = this.parseTestDescription(description);
        if (tuple3 != null) {
            Tuple3 tuple32 = new Tuple3(tuple3._1(), tuple3._2(), tuple3._3());
            String testName = (String)tuple32._1();
            String testClass = (String)tuple32._2();
            String testClassName = (String)tuple32._3();
            this.report.apply(TestStarting$.MODULE$.apply(this.theTracker.nextOrdinal(), testClassName, (Option<String>)new Some((Object)testClass), testName, (Option<Formatter>)new Some((Object)MotionToSuppress$.MODULE$), (Option<Rerunner>)None$.MODULE$));
            return;
        }
        throw new MatchError(tuple3);
    }

    public Pattern TEST_DESCRIPTION_PATTERN() {
        return this.TEST_DESCRIPTION_PATTERN;
    }

    private Tuple3<String, String, String> parseTestDescription(Description description) {
        Matcher matcher = this.TEST_DESCRIPTION_PATTERN().matcher(description.getDisplayName());
        if (matcher.find()) {
            String testName = matcher.group(1);
            String testClass = matcher.group(2);
            String testClassName = testClass.replaceAll(".*\\.", "");
            return new Tuple3((Object)testName, (Object)testClass, (Object)testClassName);
        }
        throw new RuntimeException(new StringBuilder().append((Object)"unexpected displayName [").append((Object)description.getDisplayName()).append((Object)"]").toString());
    }

    public MyRunListener(Reporter report, Map<String, Object> config, Tracker theTracker) {
        this.report = report;
        this.theTracker = theTracker;
        this.failedTests = Collections.synchronizedSet(new HashSet());
        this.TEST_DESCRIPTION_PATTERN = Pattern.compile("^(.*)\\((.*)\\)");
    }
}

