/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra.cql;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.scassandra.cql.CqlAscii;
import org.scassandra.cql.CqlBigInt;
import org.scassandra.cql.CqlBlob;
import org.scassandra.cql.CqlBoolean;
import org.scassandra.cql.CqlCounter;
import org.scassandra.cql.CqlDate;
import org.scassandra.cql.CqlDecimal;
import org.scassandra.cql.CqlDouble;
import org.scassandra.cql.CqlFloat;
import org.scassandra.cql.CqlInet;
import org.scassandra.cql.CqlInt;
import org.scassandra.cql.CqlSmallInt;
import org.scassandra.cql.CqlText;
import org.scassandra.cql.CqlTime;
import org.scassandra.cql.CqlTimestamp;
import org.scassandra.cql.CqlTimeuuid;
import org.scassandra.cql.CqlTinyInt;
import org.scassandra.cql.CqlType;
import org.scassandra.cql.CqlUuid;
import org.scassandra.cql.CqlVarchar;
import org.scassandra.cql.CqlVarint;

public abstract class PrimitiveType
extends CqlType {
    private static final Map<String, PrimitiveType> mapping = new HashMap<String, PrimitiveType>();
    public static final PrimitiveType VARCHAR = PrimitiveType.registerPrimitive(new CqlVarchar());
    public static final PrimitiveType TEXT = PrimitiveType.registerPrimitive(new CqlText());
    public static final PrimitiveType ASCII = PrimitiveType.registerPrimitive(new CqlAscii());
    public static final PrimitiveType DOUBLE = PrimitiveType.registerPrimitive(new CqlDouble());
    public static final PrimitiveType FLOAT = PrimitiveType.registerPrimitive(new CqlFloat());
    public static final PrimitiveType INET = PrimitiveType.registerPrimitive(new CqlInet());
    public static final PrimitiveType INT = PrimitiveType.registerPrimitive(new CqlInt());
    public static final PrimitiveType BIG_INT = PrimitiveType.registerPrimitive(new CqlBigInt());
    public static final PrimitiveType TIMESTAMP = PrimitiveType.registerPrimitive(new CqlTimestamp());
    public static final PrimitiveType TIMEUUID = PrimitiveType.registerPrimitive(new CqlTimeuuid());
    public static final PrimitiveType UUID = PrimitiveType.registerPrimitive(new CqlUuid());
    public static final PrimitiveType VAR_INT = PrimitiveType.registerPrimitive(new CqlVarint());
    public static final PrimitiveType BLOB = PrimitiveType.registerPrimitive(new CqlBlob());
    public static final PrimitiveType BOOLEAN = PrimitiveType.registerPrimitive(new CqlBoolean());
    public static final PrimitiveType COUNTER = PrimitiveType.registerPrimitive(new CqlCounter());
    public static final PrimitiveType DECIMAL = PrimitiveType.registerPrimitive(new CqlDecimal());
    public static final PrimitiveType DATE = PrimitiveType.registerPrimitive(new CqlDate());
    public static final PrimitiveType SMALL_INT = PrimitiveType.registerPrimitive(new CqlSmallInt());
    public static final PrimitiveType TIME = PrimitiveType.registerPrimitive(new CqlTime());
    public static final PrimitiveType TINY_INT = PrimitiveType.registerPrimitive(new CqlTinyInt());
    private final String columnType;

    private static PrimitiveType registerPrimitive(PrimitiveType primitiveType) {
        mapping.put(primitiveType.serialise(), primitiveType);
        return primitiveType;
    }

    public static PrimitiveType fromName(String name) {
        return mapping.get(name);
    }

    PrimitiveType(String columnType) {
        this.columnType = columnType;
    }

    @Override
    public String serialise() {
        return this.columnType;
    }

    public String toString() {
        return this.serialise();
    }

    @Override
    public boolean equals(Object expected, Object actual) {
        return false;
    }

    protected boolean equalsForLongType(Object expected, Object actual, CqlType columnTypes) {
        if (expected == null) {
            return actual == null;
        }
        if (actual == null) {
            return false;
        }
        Long typedActual = this.getActualValueLong(actual);
        if (expected instanceof Integer) {
            return ((Integer)expected).longValue() == typedActual.longValue();
        }
        if (expected instanceof Long) {
            return expected.equals(typedActual);
        }
        if (expected instanceof BigInteger) {
            return expected.equals(new BigInteger(typedActual.toString()));
        }
        if (expected instanceof String) {
            return this.compareStringInteger(expected, typedActual, columnTypes);
        }
        throw this.throwInvalidType(expected, actual, columnTypes);
    }

    protected long getActualValueLong(Object actual) {
        if (actual instanceof Double) {
            return ((Double)actual).longValue();
        }
        return Long.parseLong(actual.toString());
    }

    protected boolean compareStringInteger(Object expected, Long actual, CqlType instance) {
        try {
            return new BigInteger((String)expected).equals(new BigInteger(actual.toString()));
        }
        catch (NumberFormatException e) {
            throw this.throwInvalidType(expected, actual, instance);
        }
    }

    protected IllegalArgumentException throwNullError(Object actual, CqlType instance) {
        return new IllegalArgumentException(String.format("Invalid expected value (null) for variable of types %s, the value was %s for valid types see: %s", instance.serialise(), actual, "http://www.scassandra.org/java-client/column-types/"));
    }

    protected boolean equalsDecimalType(Object expected, Object actual, CqlType columnTypes) {
        if (expected == null) {
            throw this.throwNullError(actual, columnTypes);
        }
        if (actual == null) {
            return false;
        }
        if (expected instanceof String) {
            try {
                return new BigDecimal(expected.toString()).compareTo(new BigDecimal(actual.toString())) == 0;
            }
            catch (NumberFormatException e) {
                throw this.throwInvalidType(expected, actual, columnTypes);
            }
        }
        if (expected instanceof BigDecimal) {
            return ((BigDecimal)expected).compareTo(new BigDecimal(actual.toString())) == 0;
        }
        throw this.throwInvalidType(expected, actual, columnTypes);
    }

    protected boolean equalsForUUID(Object expected, Object actual, CqlType columnTypes) {
        if (expected == null) {
            return actual == null;
        }
        if (actual == null) {
            return false;
        }
        if (expected instanceof String) {
            try {
                return java.util.UUID.fromString(expected.toString()).equals(java.util.UUID.fromString(actual.toString()));
            }
            catch (Exception e) {
                throw this.throwInvalidType(expected, actual, columnTypes);
            }
        }
        if (expected instanceof UUID) {
            return expected.toString().equals(actual);
        }
        throw this.throwInvalidType(expected, actual, columnTypes);
    }
}

