/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v99.input.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class TouchPoint {
    private final Number x;
    private final Number y;
    private final Optional<Number> radiusX;
    private final Optional<Number> radiusY;
    private final Optional<Number> rotationAngle;
    private final Optional<Number> force;
    private final Optional<Number> tangentialPressure;
    private final Optional<Integer> tiltX;
    private final Optional<Integer> tiltY;
    private final Optional<Integer> twist;
    private final Optional<Number> id;

    public TouchPoint(Number x, Number y, Optional<Number> radiusX, Optional<Number> radiusY, Optional<Number> rotationAngle, Optional<Number> force, Optional<Number> tangentialPressure, Optional<Integer> tiltX, Optional<Integer> tiltY, Optional<Integer> twist, Optional<Number> id) {
        this.x = Objects.requireNonNull(x, "x is required");
        this.y = Objects.requireNonNull(y, "y is required");
        this.radiusX = radiusX;
        this.radiusY = radiusY;
        this.rotationAngle = rotationAngle;
        this.force = force;
        this.tangentialPressure = tangentialPressure;
        this.tiltX = tiltX;
        this.tiltY = tiltY;
        this.twist = twist;
        this.id = id;
    }

    public Number getX() {
        return this.x;
    }

    public Number getY() {
        return this.y;
    }

    public Optional<Number> getRadiusX() {
        return this.radiusX;
    }

    public Optional<Number> getRadiusY() {
        return this.radiusY;
    }

    public Optional<Number> getRotationAngle() {
        return this.rotationAngle;
    }

    public Optional<Number> getForce() {
        return this.force;
    }

    @Beta
    public Optional<Number> getTangentialPressure() {
        return this.tangentialPressure;
    }

    @Beta
    public Optional<Integer> getTiltX() {
        return this.tiltX;
    }

    @Beta
    public Optional<Integer> getTiltY() {
        return this.tiltY;
    }

    @Beta
    public Optional<Integer> getTwist() {
        return this.twist;
    }

    public Optional<Number> getId() {
        return this.id;
    }

    private static TouchPoint fromJson(JsonInput input) {
        Number x = 0;
        Number y = 0;
        Optional<Number> radiusX = Optional.empty();
        Optional<Number> radiusY = Optional.empty();
        Optional<Number> rotationAngle = Optional.empty();
        Optional<Number> force = Optional.empty();
        Optional<Number> tangentialPressure = Optional.empty();
        Optional<Integer> tiltX = Optional.empty();
        Optional<Integer> tiltY = Optional.empty();
        Optional<Integer> twist = Optional.empty();
        Optional<Number> id = Optional.empty();
        input.beginObject();
        block26: while (input.hasNext()) {
            switch (input.nextName()) {
                case "x": {
                    x = input.nextNumber();
                    continue block26;
                }
                case "y": {
                    y = input.nextNumber();
                    continue block26;
                }
                case "radiusX": {
                    radiusX = Optional.ofNullable(input.nextNumber());
                    continue block26;
                }
                case "radiusY": {
                    radiusY = Optional.ofNullable(input.nextNumber());
                    continue block26;
                }
                case "rotationAngle": {
                    rotationAngle = Optional.ofNullable(input.nextNumber());
                    continue block26;
                }
                case "force": {
                    force = Optional.ofNullable(input.nextNumber());
                    continue block26;
                }
                case "tangentialPressure": {
                    tangentialPressure = Optional.ofNullable(input.nextNumber());
                    continue block26;
                }
                case "tiltX": {
                    tiltX = Optional.ofNullable(input.nextNumber().intValue());
                    continue block26;
                }
                case "tiltY": {
                    tiltY = Optional.ofNullable(input.nextNumber().intValue());
                    continue block26;
                }
                case "twist": {
                    twist = Optional.ofNullable(input.nextNumber().intValue());
                    continue block26;
                }
                case "id": {
                    id = Optional.ofNullable(input.nextNumber());
                    continue block26;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new TouchPoint(x, y, radiusX, radiusY, rotationAngle, force, tangentialPressure, tiltX, tiltY, twist, id);
    }
}

