/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.UnexpectedTagNameException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Select {
    private final WebElement element;
    private boolean isMulti;

    public Select(WebElement element) {
        String tagName = element.getTagName();
        if (null == tagName || !"select".equals(tagName.toLowerCase())) {
            throw new UnexpectedTagNameException("select", tagName);
        }
        this.element = element;
        String value = element.getAttribute("multiple");
        this.isMulti = value != null && !"false".equals(value);
    }

    public boolean isMultiple() {
        return this.isMulti;
    }

    public List<WebElement> getOptions() {
        return this.element.findElements(By.tagName((String)"option"));
    }

    public List<WebElement> getAllSelectedOptions() {
        ArrayList<WebElement> toReturn = new ArrayList<WebElement>();
        for (WebElement option : this.getOptions()) {
            if (!option.isSelected()) continue;
            toReturn.add(option);
        }
        return toReturn;
    }

    public WebElement getFirstSelectedOption() {
        for (WebElement option : this.getOptions()) {
            if (!option.isSelected()) continue;
            return option;
        }
        throw new NoSuchElementException("No options are selected");
    }

    public void selectByVisibleText(String text) {
        List options = this.element.findElements(By.xpath((String)(".//option[. = " + this.escapeQuotes(text) + "]")));
        boolean matched = false;
        for (WebElement option : options) {
            this.setSelected(option);
            if (!this.isMultiple()) {
                return;
            }
            matched = true;
        }
        if (options.size() == 0 && text.contains(" ")) {
            String subStringWithoutSpace = this.getLongestSubstringWithoutSpace(text);
            List candidates = "".equals(subStringWithoutSpace) ? this.element.findElements(By.tagName((String)"option")) : this.element.findElements(By.xpath((String)(".//option[contains(., " + this.escapeQuotes(subStringWithoutSpace) + ")]")));
            for (WebElement option : candidates) {
                if (!text.equals(option.getText())) continue;
                this.setSelected(option);
                if (!this.isMultiple()) {
                    return;
                }
                matched = true;
            }
        }
        if (!matched) {
            throw new NoSuchElementException("Cannot locate element with text: " + text);
        }
    }

    private String getLongestSubstringWithoutSpace(String s) {
        String result = "";
        StringTokenizer st = new StringTokenizer(s, " ");
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (t.length() <= result.length()) continue;
            result = t;
        }
        return result;
    }

    public void selectByIndex(int index) {
        String match = String.valueOf(index);
        boolean matched = false;
        for (WebElement option : this.getOptions()) {
            if (!match.equals(option.getAttribute("index"))) continue;
            this.setSelected(option);
            if (!this.isMultiple()) {
                return;
            }
            matched = true;
        }
        if (!matched) {
            throw new NoSuchElementException("Cannot locate option with index: " + index);
        }
    }

    public void selectByValue(String value) {
        StringBuilder builder = new StringBuilder(".//option[@value = ");
        builder.append(this.escapeQuotes(value));
        builder.append("]");
        List options = this.element.findElements(By.xpath((String)builder.toString()));
        boolean matched = false;
        for (WebElement option : options) {
            this.setSelected(option);
            if (!this.isMultiple()) {
                return;
            }
            matched = true;
        }
        if (!matched) {
            throw new NoSuchElementException("Cannot locate option with value: " + value);
        }
    }

    public void deselectAll() {
        if (!this.isMultiple()) {
            throw new UnsupportedOperationException("You may only deselect all options of a multi-select");
        }
        for (WebElement option : this.getOptions()) {
            if (!option.isSelected()) continue;
            option.click();
        }
    }

    public void deselectByValue(String value) {
        StringBuilder builder = new StringBuilder(".//option[@value = ");
        builder.append(this.escapeQuotes(value));
        builder.append("]");
        List options = this.element.findElements(By.xpath((String)builder.toString()));
        for (WebElement option : options) {
            if (!option.isSelected()) continue;
            option.click();
        }
    }

    public void deselectByIndex(int index) {
        String match = String.valueOf(index);
        for (WebElement option : this.getOptions()) {
            if (!match.equals(option.getAttribute("index")) || !option.isSelected()) continue;
            option.click();
        }
    }

    public void deselectByVisibleText(String text) {
        StringBuilder builder = new StringBuilder(".//option[. = ");
        builder.append(this.escapeQuotes(text));
        builder.append("]");
        List options = this.element.findElements(By.xpath((String)builder.toString()));
        for (WebElement option : options) {
            if (!option.isSelected()) continue;
            option.click();
        }
    }

    protected String escapeQuotes(String toEscape) {
        if (toEscape.indexOf("\"") > -1 && toEscape.indexOf("'") > -1) {
            boolean quoteIsLast = false;
            if (toEscape.indexOf("\"") == toEscape.length() - 1) {
                quoteIsLast = true;
            }
            String[] substrings = toEscape.split("\"");
            StringBuilder quoted = new StringBuilder("concat(");
            for (int i = 0; i < substrings.length; ++i) {
                quoted.append("\"").append(substrings[i]).append("\"");
                quoted.append(i == substrings.length - 1 ? (quoteIsLast ? ", '\"')" : ")") : ", '\"', ");
            }
            return quoted.toString();
        }
        if (toEscape.indexOf("\"") > -1) {
            return String.format("'%s'", toEscape);
        }
        return String.format("\"%s\"", toEscape);
    }

    private void setSelected(WebElement option) {
        if (!option.isSelected()) {
            option.click();
        }
    }
}

