/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.lib.internal.facade.inprocess;

import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.scanner.lib.internal.batch.IsolatedLauncher;
import org.sonarsource.scanner.lib.internal.cache.CachedFile;
import org.sonarsource.scanner.lib.internal.cache.FileCache;
import org.sonarsource.scanner.lib.internal.facade.inprocess.ClassloadRules;
import org.sonarsource.scanner.lib.internal.facade.inprocess.IsolatedClassloader;
import org.sonarsource.scanner.lib.internal.facade.inprocess.IsolatedLauncherProxy;
import org.sonarsource.scanner.lib.internal.facade.inprocess.LegacyScannerEngineDownloader;
import org.sonarsource.scanner.lib.internal.facade.inprocess.LegacyScannerEngineDownloaderFactory;
import org.sonarsource.scanner.lib.internal.facade.inprocess.ScannerException;
import org.sonarsource.scanner.lib.internal.facade.inprocess.TempCleaning;
import org.sonarsource.scanner.lib.internal.http.ScannerHttpClient;

public class IsolatedLauncherFactory {
    private static final Logger LOG = LoggerFactory.getLogger(IsolatedLauncherFactory.class);
    static final String ISOLATED_LAUNCHER_IMPL = "org.sonarsource.scanner.lib.internal.batch.BatchIsolatedLauncher";
    private final TempCleaning tempCleaning;
    private final String launcherImplClassName;

    IsolatedLauncherFactory(String isolatedLauncherClassName, TempCleaning tempCleaning) {
        this.tempCleaning = tempCleaning;
        this.launcherImplClassName = isolatedLauncherClassName;
    }

    public IsolatedLauncherFactory() {
        this(ISOLATED_LAUNCHER_IMPL, new TempCleaning());
    }

    private IsolatedClassloader createClassLoader(List<Path> jarFiles, ClassloadRules maskRules) {
        IsolatedClassloader classloader = new IsolatedClassloader(this.getClass().getClassLoader(), maskRules);
        classloader.addFiles(jarFiles);
        return classloader;
    }

    public IsolatedLauncherAndClassloader createLauncher(ScannerHttpClient scannerHttpClient, FileCache fileCache) {
        HashSet<String> unmaskRules = new HashSet<String>();
        unmaskRules.add("org.sonarsource.scanner.lib.internal.batch.");
        ClassloadRules rules = new ClassloadRules(Collections.emptySet(), unmaskRules);
        LegacyScannerEngineDownloader legacyScannerEngineDownloader = new LegacyScannerEngineDownloaderFactory(scannerHttpClient, fileCache).create();
        return this.createLauncher(legacyScannerEngineDownloader, rules);
    }

    IsolatedLauncherAndClassloader createLauncher(LegacyScannerEngineDownloader legacyScannerEngineDownloader, ClassloadRules rules) {
        try {
            List<CachedFile> jarFiles = legacyScannerEngineDownloader.getOrDownload();
            LOG.debug("Create isolated classloader...");
            IsolatedClassloader cl = this.createClassLoader(jarFiles.stream().map(CachedFile::getPathInCache).collect(Collectors.toList()), rules);
            IsolatedLauncher objProxy = IsolatedLauncherProxy.create((ClassLoader)cl, IsolatedLauncher.class, this.launcherImplClassName);
            this.tempCleaning.clean();
            return new IsolatedLauncherAndClassloader(objProxy, cl, jarFiles.stream().allMatch(CachedFile::isCacheHit));
        }
        catch (Exception e) {
            throw new ScannerException("Unable to execute SonarScanner analysis", e);
        }
    }

    public static class IsolatedLauncherAndClassloader
    implements AutoCloseable {
        private final IsolatedLauncher launcher;
        private final URLClassLoader classloader;
        private final boolean engineCacheHit;

        public IsolatedLauncherAndClassloader(IsolatedLauncher launcher, @Nullable URLClassLoader classloader, boolean engineCacheHit) {
            this.launcher = launcher;
            this.classloader = classloader;
            this.engineCacheHit = engineCacheHit;
        }

        public IsolatedLauncher getLauncher() {
            return this.launcher;
        }

        @Override
        public void close() throws Exception {
            if (this.classloader != null) {
                this.classloader.close();
            }
        }

        public boolean wasEngineCacheHit() {
            return this.engineCacheHit;
        }
    }
}

