/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.fs.internal.DefaultIndexedFile;
import org.sonar.api.batch.fs.internal.DefaultInputComponent;
import org.sonar.api.batch.fs.internal.DefaultTextPointer;
import org.sonar.api.batch.fs.internal.DefaultTextRange;
import org.sonar.api.batch.fs.internal.Metadata;
import org.sonar.api.internal.google.common.base.Preconditions;

public class DefaultInputFile
extends DefaultInputComponent
implements InputFile {
    private final DefaultIndexedFile indexedFile;
    private final Consumer<DefaultInputFile> metadataGenerator;
    private InputFile.Status status;
    private Charset charset;
    private Metadata metadata;
    private boolean publish;

    public DefaultInputFile(DefaultIndexedFile indexedFile, Consumer<DefaultInputFile> metadataGenerator) {
        super(indexedFile.batchId());
        this.indexedFile = indexedFile;
        this.metadataGenerator = metadataGenerator;
        this.metadata = null;
        this.publish = false;
    }

    public void checkMetadata() {
        if (this.metadata == null) {
            this.metadataGenerator.accept(this);
        }
    }

    public DefaultInputFile setPublish(boolean publish) {
        this.publish = publish;
        return this;
    }

    public boolean publish() {
        return this.publish;
    }

    @Override
    public String relativePath() {
        return this.indexedFile.relativePath();
    }

    @Override
    public String absolutePath() {
        return this.indexedFile.absolutePath();
    }

    @Override
    public File file() {
        return this.indexedFile.file();
    }

    @Override
    public Path path() {
        return this.indexedFile.path();
    }

    @Override
    @CheckForNull
    public String language() {
        return this.indexedFile.language();
    }

    @Override
    public InputFile.Type type() {
        return this.indexedFile.type();
    }

    @Override
    public String key() {
        return this.indexedFile.key();
    }

    public String moduleKey() {
        return this.indexedFile.moduleKey();
    }

    @Override
    public int hashCode() {
        return this.indexedFile.hashCode();
    }

    @Override
    public String toString() {
        return this.indexedFile.toString();
    }

    @Override
    public InputFile.Status status() {
        this.checkMetadata();
        return this.status;
    }

    @Override
    public int lines() {
        this.checkMetadata();
        return this.metadata.lines();
    }

    @Override
    public boolean isEmpty() {
        this.checkMetadata();
        return this.metadata.lastValidOffset() == 0;
    }

    @Override
    public Charset charset() {
        this.checkMetadata();
        return this.charset;
    }

    public int lastValidOffset() {
        this.checkMetadata();
        Preconditions.checkState(this.metadata.lastValidOffset() >= 0, "InputFile is not properly initialized.");
        return this.metadata.lastValidOffset();
    }

    public String hash() {
        this.checkMetadata();
        return this.metadata.hash();
    }

    public int nonBlankLines() {
        this.checkMetadata();
        return this.metadata.nonBlankLines();
    }

    public int[] originalLineOffsets() {
        this.checkMetadata();
        Preconditions.checkState(this.metadata.originalLineOffsets() != null, "InputFile is not properly initialized.");
        Preconditions.checkState(this.metadata.originalLineOffsets().length == this.metadata.lines(), "InputFile is not properly initialized. 'originalLineOffsets' property length should be equal to 'lines'");
        return this.metadata.originalLineOffsets();
    }

    @Override
    public TextPointer newPointer(int line, int lineOffset) {
        this.checkMetadata();
        DefaultTextPointer textPointer = new DefaultTextPointer(line, lineOffset);
        this.checkValid(textPointer, "pointer");
        return textPointer;
    }

    @Override
    public TextRange newRange(TextPointer start, TextPointer end) {
        this.checkMetadata();
        this.checkValid(start, "start pointer");
        this.checkValid(end, "end pointer");
        return DefaultInputFile.newRangeValidPointers(start, end, false);
    }

    @Override
    public TextRange newRange(int startLine, int startLineOffset, int endLine, int endLineOffset) {
        this.checkMetadata();
        TextPointer start = this.newPointer(startLine, startLineOffset);
        TextPointer end = this.newPointer(endLine, endLineOffset);
        return DefaultInputFile.newRangeValidPointers(start, end, false);
    }

    @Override
    public TextRange selectLine(int line) {
        this.checkMetadata();
        TextPointer startPointer = this.newPointer(line, 0);
        TextPointer endPointer = this.newPointer(line, this.lineLength(line));
        return DefaultInputFile.newRangeValidPointers(startPointer, endPointer, true);
    }

    public void validate(TextRange range) {
        this.checkMetadata();
        this.checkValid(range.start(), "start pointer");
        this.checkValid(range.end(), "end pointer");
    }

    public TextRange newRange(int startOffset, int endOffset) {
        this.checkMetadata();
        return DefaultInputFile.newRangeValidPointers(this.newPointer(startOffset), this.newPointer(endOffset), false);
    }

    public TextPointer newPointer(int globalOffset) {
        this.checkMetadata();
        Preconditions.checkArgument(globalOffset >= 0, "%s is not a valid offset for a file", globalOffset);
        Preconditions.checkArgument(globalOffset <= this.lastValidOffset(), "%s is not a valid offset for file %s. Max offset is %s", globalOffset, this, this.lastValidOffset());
        int line = this.findLine(globalOffset);
        int startLineOffset = this.originalLineOffsets()[line - 1];
        return new DefaultTextPointer(line, globalOffset - startLineOffset);
    }

    public DefaultInputFile setStatus(InputFile.Status status) {
        this.status = status;
        return this;
    }

    public DefaultInputFile setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    private void checkValid(TextPointer pointer, String owner) {
        Preconditions.checkArgument(pointer.line() >= 1, "%s is not a valid line for a file", pointer.line());
        Preconditions.checkArgument(pointer.line() <= this.metadata.lines(), "%s is not a valid line for %s. File %s has %s line(s)", pointer.line(), owner, this, this.metadata.lines());
        Preconditions.checkArgument(pointer.lineOffset() >= 0, "%s is not a valid line offset for a file", pointer.lineOffset());
        int lineLength = this.lineLength(pointer.line());
        Preconditions.checkArgument(pointer.lineOffset() <= lineLength, "%s is not a valid line offset for %s. File %s has %s character(s) at line %s", pointer.lineOffset(), owner, this, lineLength, pointer.line());
    }

    private int lineLength(int line) {
        return this.lastValidGlobalOffsetForLine(line) - this.originalLineOffsets()[line - 1];
    }

    private int lastValidGlobalOffsetForLine(int line) {
        return line < this.metadata.lines() ? this.originalLineOffsets()[line] - 1 : this.lastValidOffset();
    }

    private static TextRange newRangeValidPointers(TextPointer start, TextPointer end, boolean acceptEmptyRange) {
        Preconditions.checkArgument(acceptEmptyRange ? start.compareTo(end) <= 0 : start.compareTo(end) < 0, "Start pointer %s should be before end pointer %s", start, end);
        return new DefaultTextRange(start, end);
    }

    private int findLine(int globalOffset) {
        return Math.abs(Arrays.binarySearch(this.originalLineOffsets(), globalOffset) + 1);
    }

    public DefaultInputFile setMetadata(Metadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultInputFile)) {
            return false;
        }
        DefaultInputFile that = (DefaultInputFile)o;
        return this.moduleKey().equals(that.moduleKey()) && this.relativePath().equals(that.relativePath());
    }

    @Override
    public boolean isFile() {
        return true;
    }
}

