/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.binarysortable;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.binarysortable.InputByteBuffer;
import org.apache.hadoop.hive.serde2.binarysortable.OutputByteBuffer;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardUnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.BaseCharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class BinarySortableSerDe
extends AbstractSerDe {
    public static final Log LOG = LogFactory.getLog((String)BinarySortableSerDe.class.getName());
    List<String> columnNames;
    List<TypeInfo> columnTypes;
    TypeInfo rowTypeInfo;
    StructObjectInspector rowObjectInspector;
    boolean[] columnSortOrderIsDesc;
    private static byte[] decimalBuffer = null;
    private static Charset decimalCharSet = Charset.forName("US-ASCII");
    ArrayList<Object> row;
    InputByteBuffer inputByteBuffer = new InputByteBuffer();
    BytesWritable serializeBytesWritable = new BytesWritable();
    OutputByteBuffer outputByteBuffer = new OutputByteBuffer();

    @Override
    public void initialize(Configuration conf, Properties tbl) throws SerDeException {
        String columnNameProperty = tbl.getProperty("columns");
        String columnTypeProperty = tbl.getProperty("columns.types");
        this.columnNames = columnNameProperty.length() == 0 ? new ArrayList<String>() : Arrays.asList(columnNameProperty.split(","));
        this.columnTypes = columnTypeProperty.length() == 0 ? new ArrayList<TypeInfo>() : TypeInfoUtils.getTypeInfosFromTypeString(columnTypeProperty);
        assert (this.columnNames.size() == this.columnTypes.size());
        this.rowTypeInfo = TypeInfoFactory.getStructTypeInfo(this.columnNames, this.columnTypes);
        this.rowObjectInspector = (StructObjectInspector)TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo(this.rowTypeInfo);
        this.row = new ArrayList(this.columnNames.size());
        for (int i = 0; i < this.columnNames.size(); ++i) {
            this.row.add(null);
        }
        String columnSortOrder = tbl.getProperty("serialization.sort.order");
        this.columnSortOrderIsDesc = new boolean[this.columnNames.size()];
        for (int i = 0; i < this.columnSortOrderIsDesc.length; ++i) {
            this.columnSortOrderIsDesc[i] = columnSortOrder != null && columnSortOrder.charAt(i) == '-';
        }
    }

    @Override
    public Class<? extends Writable> getSerializedClass() {
        return BytesWritable.class;
    }

    @Override
    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.rowObjectInspector;
    }

    @Override
    public Object deserialize(Writable blob) throws SerDeException {
        BytesWritable data = (BytesWritable)blob;
        this.inputByteBuffer.reset(data.getBytes(), 0, data.getLength());
        try {
            for (int i = 0; i < this.columnNames.size(); ++i) {
                this.row.set(i, BinarySortableSerDe.deserialize(this.inputByteBuffer, this.columnTypes.get(i), this.columnSortOrderIsDesc[i], this.row.get(i)));
            }
        }
        catch (IOException e) {
            throw new SerDeException(e);
        }
        return this.row;
    }

    static Object deserialize(InputByteBuffer buffer, TypeInfo type, boolean invert, Object reuse) throws IOException {
        byte isNull = buffer.read(invert);
        if (isNull == 0) {
            return null;
        }
        assert (isNull == 1);
        switch (type.getCategory()) {
            case PRIMITIVE: {
                PrimitiveTypeInfo ptype = (PrimitiveTypeInfo)type;
                switch (ptype.getPrimitiveCategory()) {
                    case VOID: {
                        return null;
                    }
                    case BOOLEAN: {
                        BooleanWritable r = reuse == null ? new BooleanWritable() : (BooleanWritable)reuse;
                        byte b = buffer.read(invert);
                        assert (b == 1 || b == 2);
                        r.set(b == 2);
                        return r;
                    }
                    case BYTE: {
                        ByteWritable r = reuse == null ? new ByteWritable() : (ByteWritable)reuse;
                        r.set((byte)(buffer.read(invert) ^ 0x80));
                        return r;
                    }
                    case SHORT: {
                        ShortWritable r = reuse == null ? new ShortWritable() : (ShortWritable)reuse;
                        int v = buffer.read(invert) ^ 0x80;
                        v = (v << 8) + (buffer.read(invert) & 0xFF);
                        r.set((short)v);
                        return r;
                    }
                    case INT: {
                        IntWritable r = reuse == null ? new IntWritable() : (IntWritable)reuse;
                        r.set(BinarySortableSerDe.deserializeInt(buffer, invert));
                        return r;
                    }
                    case LONG: {
                        LongWritable r = reuse == null ? new LongWritable() : (LongWritable)reuse;
                        long v = buffer.read(invert) ^ 0x80;
                        for (int i = 0; i < 7; ++i) {
                            v = (v << 8) + (long)(buffer.read(invert) & 0xFF);
                        }
                        r.set(v);
                        return r;
                    }
                    case FLOAT: {
                        FloatWritable r = reuse == null ? new FloatWritable() : (FloatWritable)reuse;
                        int v = 0;
                        for (int i = 0; i < 4; ++i) {
                            v = (v << 8) + (buffer.read(invert) & 0xFF);
                        }
                        v = (v & Integer.MIN_VALUE) == 0 ? (v ^= 0xFFFFFFFF) : (v ^= Integer.MIN_VALUE);
                        r.set(Float.intBitsToFloat(v));
                        return r;
                    }
                    case DOUBLE: {
                        DoubleWritable r = reuse == null ? new DoubleWritable() : (DoubleWritable)reuse;
                        long v = 0L;
                        for (int i = 0; i < 8; ++i) {
                            v = (v << 8) + (long)(buffer.read(invert) & 0xFF);
                        }
                        v = (v & Long.MIN_VALUE) == 0L ? (v ^= 0xFFFFFFFFFFFFFFFFL) : (v ^= Long.MIN_VALUE);
                        r.set(Double.longBitsToDouble(v));
                        return r;
                    }
                    case STRING: {
                        Text r = reuse == null ? new Text() : (Text)reuse;
                        return BinarySortableSerDe.deserializeText(buffer, invert, r);
                    }
                    case CHAR: {
                        HiveCharWritable r = reuse == null ? new HiveCharWritable() : (HiveCharWritable)reuse;
                        BinarySortableSerDe.deserializeText(buffer, invert, r.getTextValue());
                        r.enforceMaxLength(BinarySortableSerDe.getCharacterMaxLength(type));
                        return r;
                    }
                    case VARCHAR: {
                        HiveVarcharWritable r = reuse == null ? new HiveVarcharWritable() : (HiveVarcharWritable)reuse;
                        BinarySortableSerDe.deserializeText(buffer, invert, r.getTextValue());
                        r.enforceMaxLength(BinarySortableSerDe.getCharacterMaxLength(type));
                        return r;
                    }
                    case BINARY: {
                        byte b;
                        BytesWritable bw = new BytesWritable();
                        int start = buffer.tell();
                        int length = 0;
                        while ((b = buffer.read(invert)) != 0) {
                            if (b == 1) {
                                buffer.read(invert);
                            }
                            ++length;
                        }
                        if (length == buffer.tell() - start) {
                            bw.set(buffer.getData(), start, length);
                        } else {
                            bw.set(buffer.getData(), start, length);
                            buffer.seek(start);
                            byte[] rdata = bw.getBytes();
                            for (int i = 0; i < length; ++i) {
                                byte b2 = buffer.read(invert);
                                if (b2 == 1) {
                                    b2 = (byte)(buffer.read(invert) - 1);
                                }
                                rdata[i] = b2;
                            }
                            byte b3 = buffer.read(invert);
                            assert (b3 == 0);
                        }
                        return bw;
                    }
                    case DATE: {
                        DateWritable d = reuse == null ? new DateWritable() : (DateWritable)reuse;
                        d.set(BinarySortableSerDe.deserializeInt(buffer, invert));
                        return d;
                    }
                    case TIMESTAMP: {
                        TimestampWritable t = reuse == null ? new TimestampWritable() : (TimestampWritable)reuse;
                        byte[] bytes = new byte[11];
                        for (int i = 0; i < bytes.length; ++i) {
                            bytes[i] = buffer.read(invert);
                        }
                        t.setBinarySortable(bytes, 0);
                        return t;
                    }
                    case DECIMAL: {
                        HiveDecimalWritable bdw = reuse == null ? new HiveDecimalWritable() : (HiveDecimalWritable)reuse;
                        int b = buffer.read(invert) - 1;
                        assert (b == 1 || b == -1 || b == 0);
                        boolean positive = b != -1;
                        int factor = buffer.read(invert) ^ 0x80;
                        for (int i = 0; i < 3; ++i) {
                            factor = (factor << 8) + (buffer.read(invert) & 0xFF);
                        }
                        if (!positive) {
                            factor = -factor;
                        }
                        int start = buffer.tell();
                        int length = 0;
                        while (true) {
                            b = buffer.read(positive ? invert : !invert);
                            assert (b != 1);
                            if (b == 0) break;
                            ++length;
                        }
                        if (decimalBuffer == null || decimalBuffer.length < length) {
                            decimalBuffer = new byte[length];
                        }
                        buffer.seek(start);
                        for (int i = 0; i < length; ++i) {
                            BinarySortableSerDe.decimalBuffer[i] = buffer.read(positive ? invert : !invert);
                        }
                        buffer.read(positive ? invert : !invert);
                        String digits = new String(decimalBuffer, 0, length, decimalCharSet);
                        BigInteger bi = new BigInteger(digits);
                        HiveDecimal bd = HiveDecimal.create((BigInteger)bi).scaleByPowerOfTen(factor - length);
                        if (!positive) {
                            bd = bd.negate();
                        }
                        bdw.set(bd);
                        return bdw;
                    }
                }
                throw new RuntimeException("Unrecognized type: " + (Object)((Object)ptype.getPrimitiveCategory()));
            }
            case LIST: {
                byte more;
                ListTypeInfo ltype = (ListTypeInfo)type;
                TypeInfo etype = ltype.getListElementTypeInfo();
                ArrayList<Object> r = reuse == null ? new ArrayList<Object>() : (ArrayList)reuse;
                int size = 0;
                while ((more = buffer.read(invert)) != 0) {
                    assert (more == 1);
                    if (size == r.size()) {
                        r.add(null);
                    }
                    r.set(size, BinarySortableSerDe.deserialize(buffer, etype, invert, r.get(size)));
                    ++size;
                }
                while (r.size() > size) {
                    r.remove(r.size() - 1);
                }
                return r;
            }
            case MAP: {
                byte more;
                HashMap<Object, Object> r;
                MapTypeInfo mtype = (MapTypeInfo)type;
                TypeInfo ktype = mtype.getMapKeyTypeInfo();
                TypeInfo vtype = mtype.getMapValueTypeInfo();
                if (reuse == null) {
                    r = new HashMap<Object, Object>();
                } else {
                    r = (HashMap<Object, Object>)reuse;
                    r.clear();
                }
                while ((more = buffer.read(invert)) != 0) {
                    assert (more == 1);
                    Object k = BinarySortableSerDe.deserialize(buffer, ktype, invert, null);
                    Object v = BinarySortableSerDe.deserialize(buffer, vtype, invert, null);
                    r.put(k, v);
                }
                return r;
            }
            case STRUCT: {
                ArrayList<Object> r;
                StructTypeInfo stype = (StructTypeInfo)type;
                ArrayList<TypeInfo> fieldTypes = stype.getAllStructFieldTypeInfos();
                int size = fieldTypes.size();
                ArrayList<Object> arrayList = r = reuse == null ? new ArrayList<Object>(size) : (ArrayList)reuse;
                assert (r.size() <= size);
                while (r.size() < size) {
                    r.add(null);
                }
                for (int eid = 0; eid < size; ++eid) {
                    r.set(eid, BinarySortableSerDe.deserialize(buffer, (TypeInfo)fieldTypes.get(eid), invert, r.get(eid)));
                }
                return r;
            }
            case UNION: {
                UnionTypeInfo utype = (UnionTypeInfo)type;
                StandardUnionObjectInspector.StandardUnion r = reuse == null ? new StandardUnionObjectInspector.StandardUnion() : (StandardUnionObjectInspector.StandardUnion)reuse;
                byte tag = buffer.read(invert);
                r.setTag(tag);
                r.setObject(BinarySortableSerDe.deserialize(buffer, utype.getAllUnionObjectTypeInfos().get(tag), invert, null));
                return r;
            }
        }
        throw new RuntimeException("Unrecognized type: " + (Object)((Object)type.getCategory()));
    }

    private static int deserializeInt(InputByteBuffer buffer, boolean invert) throws IOException {
        int v = buffer.read(invert) ^ 0x80;
        for (int i = 0; i < 3; ++i) {
            v = (v << 8) + (buffer.read(invert) & 0xFF);
        }
        return v;
    }

    static int getCharacterMaxLength(TypeInfo type) {
        return ((BaseCharTypeInfo)type).getLength();
    }

    static Text deserializeText(InputByteBuffer buffer, boolean invert, Text r) throws IOException {
        byte b;
        int start = buffer.tell();
        int length = 0;
        while ((b = buffer.read(invert)) != 0) {
            if (b == 1) {
                buffer.read(invert);
            }
            ++length;
        }
        if (length == buffer.tell() - start) {
            r.set(buffer.getData(), start, length);
        } else {
            r.set(buffer.getData(), start, length);
            buffer.seek(start);
            byte[] rdata = r.getBytes();
            for (int i = 0; i < length; ++i) {
                byte b2 = buffer.read(invert);
                if (b2 == 1) {
                    b2 = (byte)(buffer.read(invert) - 1);
                }
                rdata[i] = b2;
            }
            byte b3 = buffer.read(invert);
            assert (b3 == 0);
        }
        return r;
    }

    @Override
    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        this.outputByteBuffer.reset();
        StructObjectInspector soi = (StructObjectInspector)objInspector;
        List<? extends StructField> fields = soi.getAllStructFieldRefs();
        for (int i = 0; i < this.columnNames.size(); ++i) {
            BinarySortableSerDe.serialize(this.outputByteBuffer, soi.getStructFieldData(obj, fields.get(i)), fields.get(i).getFieldObjectInspector(), this.columnSortOrderIsDesc[i]);
        }
        this.serializeBytesWritable.set(this.outputByteBuffer.getData(), 0, this.outputByteBuffer.getLength());
        return this.serializeBytesWritable;
    }

    static void serialize(OutputByteBuffer buffer, Object o, ObjectInspector oi, boolean invert) throws SerDeException {
        if (o == null) {
            buffer.write((byte)0, invert);
            return;
        }
        buffer.write((byte)1, invert);
        switch (oi.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)oi;
                switch (poi.getPrimitiveCategory()) {
                    case VOID: {
                        return;
                    }
                    case BOOLEAN: {
                        boolean v = ((BooleanObjectInspector)poi).get(o);
                        buffer.write((byte)(v ? 2 : 1), invert);
                        return;
                    }
                    case BYTE: {
                        ByteObjectInspector boi = (ByteObjectInspector)poi;
                        byte v = boi.get(o);
                        buffer.write((byte)(v ^ 0x80), invert);
                        return;
                    }
                    case SHORT: {
                        ShortObjectInspector spoi = (ShortObjectInspector)poi;
                        short v = spoi.get(o);
                        buffer.write((byte)(v >> 8 ^ 0x80), invert);
                        buffer.write((byte)v, invert);
                        return;
                    }
                    case INT: {
                        IntObjectInspector ioi = (IntObjectInspector)poi;
                        int v = ioi.get(o);
                        BinarySortableSerDe.serializeInt(buffer, v, invert);
                        return;
                    }
                    case LONG: {
                        LongObjectInspector loi = (LongObjectInspector)poi;
                        long v = loi.get(o);
                        buffer.write((byte)(v >> 56 ^ 0x80L), invert);
                        buffer.write((byte)(v >> 48), invert);
                        buffer.write((byte)(v >> 40), invert);
                        buffer.write((byte)(v >> 32), invert);
                        buffer.write((byte)(v >> 24), invert);
                        buffer.write((byte)(v >> 16), invert);
                        buffer.write((byte)(v >> 8), invert);
                        buffer.write((byte)v, invert);
                        return;
                    }
                    case FLOAT: {
                        FloatObjectInspector foi = (FloatObjectInspector)poi;
                        int v = Float.floatToIntBits(foi.get(o));
                        v = (v & Integer.MIN_VALUE) != 0 ? (v ^= 0xFFFFFFFF) : (v ^= Integer.MIN_VALUE);
                        buffer.write((byte)(v >> 24), invert);
                        buffer.write((byte)(v >> 16), invert);
                        buffer.write((byte)(v >> 8), invert);
                        buffer.write((byte)v, invert);
                        return;
                    }
                    case DOUBLE: {
                        DoubleObjectInspector doi = (DoubleObjectInspector)poi;
                        long v = Double.doubleToLongBits(doi.get(o));
                        v = (v & Long.MIN_VALUE) != 0L ? (v ^= 0xFFFFFFFFFFFFFFFFL) : (v ^= Long.MIN_VALUE);
                        buffer.write((byte)(v >> 56), invert);
                        buffer.write((byte)(v >> 48), invert);
                        buffer.write((byte)(v >> 40), invert);
                        buffer.write((byte)(v >> 32), invert);
                        buffer.write((byte)(v >> 24), invert);
                        buffer.write((byte)(v >> 16), invert);
                        buffer.write((byte)(v >> 8), invert);
                        buffer.write((byte)v, invert);
                        return;
                    }
                    case STRING: {
                        StringObjectInspector soi = (StringObjectInspector)poi;
                        Text t = soi.getPrimitiveWritableObject(o);
                        BinarySortableSerDe.serializeBytes(buffer, t.getBytes(), t.getLength(), invert);
                        return;
                    }
                    case CHAR: {
                        HiveCharObjectInspector hcoi = (HiveCharObjectInspector)poi;
                        HiveCharWritable hc = hcoi.getPrimitiveWritableObject(o);
                        Text t = hc.getStrippedValue();
                        BinarySortableSerDe.serializeBytes(buffer, t.getBytes(), t.getLength(), invert);
                        return;
                    }
                    case VARCHAR: {
                        HiveVarcharObjectInspector hcoi = (HiveVarcharObjectInspector)poi;
                        HiveVarcharWritable hc = hcoi.getPrimitiveWritableObject(o);
                        Text t = hc.getTextValue();
                        BinarySortableSerDe.serializeBytes(buffer, t.getBytes(), t.getLength(), invert);
                        return;
                    }
                    case BINARY: {
                        BinaryObjectInspector baoi = (BinaryObjectInspector)poi;
                        BytesWritable ba = baoi.getPrimitiveWritableObject(o);
                        byte[] toSer = new byte[ba.getLength()];
                        System.arraycopy(ba.getBytes(), 0, toSer, 0, ba.getLength());
                        BinarySortableSerDe.serializeBytes(buffer, toSer, ba.getLength(), invert);
                        return;
                    }
                    case DATE: {
                        DateObjectInspector doi = (DateObjectInspector)poi;
                        int v = doi.getPrimitiveWritableObject(o).getDays();
                        BinarySortableSerDe.serializeInt(buffer, v, invert);
                        return;
                    }
                    case TIMESTAMP: {
                        TimestampObjectInspector toi = (TimestampObjectInspector)poi;
                        TimestampWritable t = toi.getPrimitiveWritableObject(o);
                        byte[] data = t.getBinarySortable();
                        for (int i = 0; i < data.length; ++i) {
                            buffer.write(data[i], invert);
                        }
                        return;
                    }
                    case DECIMAL: {
                        HiveDecimalObjectInspector boi = (HiveDecimalObjectInspector)poi;
                        HiveDecimal dec = boi.getPrimitiveJavaObject(o);
                        int sign = dec.compareTo(HiveDecimal.ZERO);
                        dec = dec.abs();
                        int factor = dec.precision() - dec.scale();
                        factor = sign == 1 ? factor : -factor;
                        dec.scaleByPowerOfTen(Math.abs(dec.scale()));
                        String digits = dec.unscaledValue().toString();
                        buffer.write((byte)(sign + 1), invert);
                        buffer.write((byte)(factor >> 24 ^ 0x80), invert);
                        buffer.write((byte)(factor >> 16), invert);
                        buffer.write((byte)(factor >> 8), invert);
                        buffer.write((byte)factor, invert);
                        BinarySortableSerDe.serializeBytes(buffer, digits.getBytes(decimalCharSet), digits.length(), sign == -1 ? !invert : invert);
                        return;
                    }
                }
                throw new RuntimeException("Unrecognized type: " + (Object)((Object)poi.getPrimitiveCategory()));
            }
            case LIST: {
                ListObjectInspector loi = (ListObjectInspector)oi;
                ObjectInspector eoi = loi.getListElementObjectInspector();
                int size = loi.getListLength(o);
                for (int eid = 0; eid < size; ++eid) {
                    buffer.write((byte)1, invert);
                    BinarySortableSerDe.serialize(buffer, loi.getListElement(o, eid), eoi, invert);
                }
                buffer.write((byte)0, invert);
                return;
            }
            case MAP: {
                MapObjectInspector moi = (MapObjectInspector)oi;
                ObjectInspector koi = moi.getMapKeyObjectInspector();
                ObjectInspector voi = moi.getMapValueObjectInspector();
                Map<?, ?> map = moi.getMap(o);
                for (Map.Entry<?, ?> entry : map.entrySet()) {
                    buffer.write((byte)1, invert);
                    BinarySortableSerDe.serialize(buffer, entry.getKey(), koi, invert);
                    BinarySortableSerDe.serialize(buffer, entry.getValue(), voi, invert);
                }
                buffer.write((byte)0, invert);
                return;
            }
            case STRUCT: {
                StructObjectInspector soi = (StructObjectInspector)oi;
                List<? extends StructField> fields = soi.getAllStructFieldRefs();
                for (int i = 0; i < fields.size(); ++i) {
                    BinarySortableSerDe.serialize(buffer, soi.getStructFieldData(o, fields.get(i)), fields.get(i).getFieldObjectInspector(), invert);
                }
                return;
            }
            case UNION: {
                UnionObjectInspector uoi = (UnionObjectInspector)oi;
                byte tag = uoi.getTag(o);
                buffer.write(tag, invert);
                BinarySortableSerDe.serialize(buffer, uoi.getField(o), uoi.getObjectInspectors().get(tag), invert);
                return;
            }
        }
        throw new RuntimeException("Unrecognized type: " + (Object)((Object)oi.getCategory()));
    }

    private static void serializeBytes(OutputByteBuffer buffer, byte[] data, int length, boolean invert) {
        for (int i = 0; i < length; ++i) {
            if (data[i] == 0 || data[i] == 1) {
                buffer.write((byte)1, invert);
                buffer.write((byte)(data[i] + 1), invert);
                continue;
            }
            buffer.write(data[i], invert);
        }
        buffer.write((byte)0, invert);
    }

    private static void serializeInt(OutputByteBuffer buffer, int v, boolean invert) {
        buffer.write((byte)(v >> 24 ^ 0x80), invert);
        buffer.write((byte)(v >> 16), invert);
        buffer.write((byte)(v >> 8), invert);
        buffer.write((byte)v, invert);
    }

    @Override
    public SerDeStats getSerDeStats() {
        return null;
    }
}

