/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.cassandra.mapping.CassandraType;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.util.Assert;

public class CassandraParameters
extends Parameters<CassandraParameters, CassandraParameter> {
    public CassandraParameters(Method method) {
        super(method);
    }

    private CassandraParameters(List<CassandraParameter> originals) {
        super(originals);
    }

    protected CassandraParameter createParameter(MethodParameter parameter) {
        return new CassandraParameter(parameter);
    }

    protected CassandraParameters createFrom(List<CassandraParameter> parameters) {
        return new CassandraParameters(parameters);
    }

    static class AnnotatedParameter
    implements AnnotatedElement {
        private final MethodParameter methodParameter;

        AnnotatedParameter(MethodParameter methodParameter) {
            this.methodParameter = methodParameter;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return (T)this.methodParameter.getParameterAnnotation(annotationClass);
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.methodParameter.getParameterAnnotations();
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return this.methodParameter.getParameterAnnotations();
        }
    }

    class CassandraParameter
    extends Parameter {
        private final CassandraType cassandraType;

        protected CassandraParameter(MethodParameter parameter) {
            super(parameter);
            AnnotatedParameter annotatedParameter = new AnnotatedParameter(parameter);
            if (AnnotatedElementUtils.hasAnnotation((AnnotatedElement)annotatedParameter, CassandraType.class)) {
                CassandraType cassandraType = (CassandraType)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)annotatedParameter, CassandraType.class);
                Assert.notNull((Object)cassandraType.type(), (String)String.format("You must specify the type() when annotating method parameters with @%s", CassandraType.class.getSimpleName()));
                this.cassandraType = cassandraType;
            } else {
                this.cassandraType = null;
            }
        }

        public CassandraType getCassandraType() {
            return this.cassandraType;
        }
    }
}

