/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.CbTracing;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.transaction.CoreTransactionAttemptContext;
import com.couchbase.client.core.transaction.support.SpanWrapper;
import com.couchbase.client.core.transaction.util.DebugUtil;
import com.couchbase.client.java.AsyncCollection;
import com.couchbase.client.java.kv.PersistTo;
import com.couchbase.client.java.kv.ReplaceOptions;
import com.couchbase.client.java.kv.ReplicateTo;
import com.couchbase.client.java.transactions.internal.ConverterUtil;
import java.time.Duration;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.ReactiveReplaceByIdOperation;
import org.springframework.data.couchbase.core.ReactiveTemplateSupport;
import org.springframework.data.couchbase.core.TransactionalSupport;
import org.springframework.data.couchbase.core.mapping.CouchbaseDocument;
import org.springframework.data.couchbase.core.query.OptionsBuilder;
import org.springframework.data.couchbase.core.support.PseudoArgs;
import org.springframework.data.couchbase.transaction.CouchbaseResourceHolder;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveReplaceByIdOperationSupport
implements ReactiveReplaceByIdOperation {
    private final ReactiveCouchbaseTemplate template;
    private static final Logger LOG = LoggerFactory.getLogger(ReactiveReplaceByIdOperationSupport.class);

    public ReactiveReplaceByIdOperationSupport(ReactiveCouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ReactiveReplaceByIdOperation.ReactiveReplaceById<T> replaceById(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null!");
        return new ReactiveReplaceByIdSupport<T>(this.template, domainType, OptionsBuilder.getScopeFrom(domainType), OptionsBuilder.getCollectionFrom(domainType), null, OptionsBuilder.getPersistTo(domainType), OptionsBuilder.getReplicateTo(domainType), OptionsBuilder.getDurabilityLevel(domainType, this.template.getConverter()), null, this.template.support());
    }

    static class ReactiveReplaceByIdSupport<T>
    implements ReactiveReplaceByIdOperation.ReactiveReplaceById<T> {
        private final ReactiveCouchbaseTemplate template;
        private final Class<T> domainType;
        private final String scope;
        private final String collection;
        private final ReplaceOptions options;
        private final PersistTo persistTo;
        private final ReplicateTo replicateTo;
        private final DurabilityLevel durabilityLevel;
        private final Duration expiry;
        private final ReactiveTemplateSupport support;

        ReactiveReplaceByIdSupport(ReactiveCouchbaseTemplate template, Class<T> domainType, String scope, String collection, ReplaceOptions options, PersistTo persistTo, ReplicateTo replicateTo, DurabilityLevel durabilityLevel, Duration expiry, ReactiveTemplateSupport support) {
            this.template = template;
            this.domainType = domainType;
            this.scope = scope;
            this.collection = collection;
            this.options = options;
            this.persistTo = persistTo;
            this.replicateTo = replicateTo;
            this.durabilityLevel = durabilityLevel;
            this.expiry = expiry;
            this.support = support;
        }

        @Override
        public Mono<T> one(T object) {
            PseudoArgs<ReplaceOptions> pArgs = new PseudoArgs<ReplaceOptions>(this.template, this.scope, this.collection, this.options, this.domainType);
            if (LOG.isDebugEnabled()) {
                LOG.debug("replaceById object={} {}", object, pArgs);
            }
            return Mono.just((Object)this.template.getCouchbaseClientFactory().withScope(pArgs.getScope()).getCollection(pArgs.getCollection())).flatMap(collection -> this.support.encodeEntity(object).flatMap(converted -> TransactionalSupport.checkForTransactionInThreadLocalStorage().flatMap(ctxOpt -> {
                if (!ctxOpt.isPresent()) {
                    return collection.reactive().replace(converted.getId().toString(), converted.export(), this.buildReplaceOptions((ReplaceOptions)pArgs.getOptions(), object, (CouchbaseDocument)converted)).flatMap(result -> this.support.applyResult(object, (CouchbaseDocument)converted, converted.getId(), result.cas(), null, null));
                }
                this.rejectInvalidTransactionalOptions();
                Long cas = this.support.getCas(object);
                if (cas == null || cas == 0L) {
                    throw new IllegalArgumentException("cas must be supplied in object for tx replace. object=" + object);
                }
                CollectionIdentifier collId = ConverterUtil.makeCollectionIdentifier((AsyncCollection)collection.async());
                CoreTransactionAttemptContext ctx = ((CouchbaseResourceHolder)((Object)((Object)((Object)((Object)ctxOpt.get()))))).getCore();
                ctx.logger().info(ctx.attemptId(), "refetching %s for Spring replace", new Object[]{DebugUtil.docId((CollectionIdentifier)collId, (String)converted.getId().toString())});
                Mono gr = ctx.get(collId, converted.getId().toString());
                return gr.flatMap(getResult -> {
                    if (getResult.cas() != cas.longValue()) {
                        return Mono.error((Throwable)TransactionalSupport.retryTransactionOnCasMismatch(ctx, getResult.cas(), cas));
                    }
                    CoreTransactionAttemptContext internal = ((CouchbaseResourceHolder)((Object)((Object)((Object)((Object)((Object)ctxOpt.get())))))).getCore();
                    RequestSpan span = CbTracing.newSpan((CoreContext)internal.core().context(), (String)"transaction_replace", (RequestSpan)internal.span());
                    span.attribute("db.operation", "transaction_replace");
                    return ctx.replace(getResult, this.template.getCouchbaseClientFactory().getCluster().environment().transcoder().encode(converted.export()).encoded(), new SpanWrapper(span));
                }).flatMap(result -> this.support.applyResult(object, (CouchbaseDocument)converted, converted.getId(), result.cas(), null, null));
            })).onErrorMap(throwable -> {
                if (throwable instanceof RuntimeException) {
                    return this.template.potentiallyConvertRuntimeException((RuntimeException)throwable);
                }
                return throwable;
            }));
        }

        private void rejectInvalidTransactionalOptions() {
            if (this.persistTo != null && this.persistTo != PersistTo.NONE || this.replicateTo != null && this.replicateTo != ReplicateTo.NONE) {
                throw new IllegalArgumentException("withDurability PersistTo and ReplicateTo overload is not supported in a transaction");
            }
            if (this.expiry != null) {
                throw new IllegalArgumentException("withExpiry is not supported in a transaction");
            }
            if (this.durabilityLevel != null && this.durabilityLevel != DurabilityLevel.NONE) {
                throw new IllegalArgumentException("withDurability is not supported in a transaction");
            }
            if (this.options != null) {
                throw new IllegalArgumentException("withOptions is not supported in a transaction");
            }
        }

        @Override
        public Flux<? extends T> all(Collection<? extends T> objects) {
            return Flux.fromIterable(objects).flatMap(this::one);
        }

        private ReplaceOptions buildReplaceOptions(ReplaceOptions options, T object, CouchbaseDocument doc) {
            return OptionsBuilder.buildReplaceOptions(options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry, this.support.getCas(object), doc);
        }

        @Override
        public ReactiveReplaceByIdOperation.TerminatingReplaceById<T> withOptions(ReplaceOptions options) {
            Assert.notNull((Object)options, (String)"Options must not be null.");
            return new ReactiveReplaceByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry, this.support);
        }

        @Override
        public ReactiveReplaceByIdOperation.ReplaceByIdWithDurability<T> inCollection(String collection) {
            return new ReactiveReplaceByIdSupport<T>(this.template, this.domainType, this.scope, collection != null ? collection : this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry, this.support);
        }

        @Override
        public ReactiveReplaceByIdOperation.ReplaceByIdInCollection<T> inScope(String scope) {
            return new ReactiveReplaceByIdSupport<T>(this.template, this.domainType, scope != null ? scope : this.scope, this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry, this.support);
        }

        @Override
        public ReactiveReplaceByIdOperation.ReplaceByIdInScope<T> withDurability(DurabilityLevel durabilityLevel) {
            Assert.notNull((Object)durabilityLevel, (String)"Durability Level must not be null.");
            return new ReactiveReplaceByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, this.persistTo, this.replicateTo, durabilityLevel, this.expiry, this.support);
        }

        @Override
        public ReactiveReplaceByIdOperation.ReplaceByIdInScope<T> withDurability(PersistTo persistTo, ReplicateTo replicateTo) {
            Assert.notNull((Object)persistTo, (String)"PersistTo must not be null.");
            Assert.notNull((Object)replicateTo, (String)"ReplicateTo must not be null.");
            return new ReactiveReplaceByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, persistTo, replicateTo, this.durabilityLevel, this.expiry, this.support);
        }

        @Override
        public ReactiveReplaceByIdOperation.ReplaceByIdWithDurability<T> withExpiry(Duration expiry) {
            Assert.notNull((Object)expiry, (String)"expiry must not be null.");
            return new ReactiveReplaceByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, expiry, this.support);
        }
    }
}

