/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.json.JsonValue;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.mapping.CouchbaseDocument;
import org.springframework.data.couchbase.core.mapping.CouchbaseList;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.core.mapping.Expiration;
import org.springframework.data.couchbase.core.query.N1QLExpression;
import org.springframework.data.couchbase.core.query.StringQuery;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.N1qlQueryCreator;
import org.springframework.data.couchbase.repository.query.support.N1qlUtils;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

public class StringBasedN1qlQueryParser {
    public static final String SPEL_PREFIX = "n1ql";
    public static final String SPEL_SELECT_FROM_CLAUSE = "#n1ql.selectEntity";
    public static final String SPEL_BUCKET = "#n1ql.bucket";
    public static final String SPEL_SCOPE = "#n1ql.scope";
    public static final String SPEL_COLLECTION = "#n1ql.collection";
    public static final String SPEL_ENTITY = "#n1ql.fields";
    public static final String SPEL_FILTER = "#n1ql.filter";
    public static final String SPEL_DELETE = "#n1ql.delete";
    public static final String SPEL_RETURNING = "#n1ql.returning";
    public static final Pattern NAMED_PLACEHOLDER_PATTERN = Pattern.compile("\\W(\\$\\p{Alpha}\\p{Alnum}*)\\b");
    public static final Pattern POSITIONAL_PLACEHOLDER_PATTERN = Pattern.compile("\\W(\\$\\p{Digit}+)\\b");
    public static final Pattern SPEL_EXPRESSION_PATTERN = Pattern.compile("(#\\{[^\\}]*\\})");
    public static final Pattern QUOTE_DETECTION_PATTERN = Pattern.compile("[\"'](?:[^\"'\\\\]*(?:\\\\.)?)*[\"']");
    private static final Logger LOGGER = LoggerFactory.getLogger(StringBasedN1qlQueryParser.class);
    private final String statement;
    private final CouchbaseQueryMethod queryMethod;
    private PlaceholderType placeHolderType;
    private final N1qlSpelValues statementContext;
    private final CouchbaseConverter couchbaseConverter;
    private final Collection<String> parameterNames = new HashSet<String>();
    public final N1QLExpression parsedExpression;

    public StringBasedN1qlQueryParser(String statement, CouchbaseQueryMethod queryMethod, String bucketName, String scope, String collection, CouchbaseConverter couchbaseConverter, String typeField, String typeValue, ParameterAccessor accessor, SpelExpressionParser spelExpressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        this.statement = statement;
        this.queryMethod = queryMethod;
        this.couchbaseConverter = couchbaseConverter;
        this.statementContext = queryMethod == null ? null : this.createN1qlSpelValues(collection != null ? collection : bucketName, scope, collection, queryMethod.getEntityInformation().getJavaType(), typeField, typeValue, queryMethod.isCountQuery(), null, null);
        this.parsedExpression = this.getExpression(statement, queryMethod, accessor, spelExpressionParser, evaluationContextProvider);
    }

    public StringBasedN1qlQueryParser(String bucketName, String scope, String collection, CouchbaseConverter couchbaseConverter, Class<?> domainClass, Class<?> resultClass, String typeField, String typeValue, boolean isCount, String[] distinctFields, String[] fields) {
        this.statement = null;
        this.queryMethod = null;
        this.couchbaseConverter = couchbaseConverter;
        this.statementContext = this.createN1qlSpelValues(bucketName, scope, collection, domainClass, typeField, typeValue, isCount, distinctFields, fields);
        this.parsedExpression = null;
    }

    public N1qlSpelValues createN1qlSpelValues(String bucketName, String scope, String collection, Class domainClass, String typeKey, String typeValue, boolean isCount, String[] distinctFields, String[] fields) {
        String selectEntity;
        String b = bucketName;
        String keyspace = collection != null ? collection : bucketName;
        Assert.isTrue((distinctFields == null || fields == null ? 1 : 0) != 0, (String)"only one of project(fields) and distinct(distinctFields) can be specified");
        String entityFields = "";
        if (distinctFields != null) {
            String distinctFieldsStr = this.getProjectedOrDistinctFields(b, domainClass, typeKey, fields, distinctFields);
            selectEntity = isCount ? N1QLExpression.select(N1QLExpression.count(N1QLExpression.distinct(N1QLExpression.x(distinctFieldsStr))).as(N1QLExpression.i("count")).from(keyspace)).toString() : N1QLExpression.select(N1QLExpression.distinct(N1QLExpression.x(distinctFieldsStr))).from(keyspace).toString();
        } else if (isCount) {
            selectEntity = N1QLExpression.select(N1QLExpression.count(N1QLExpression.x("\"*\"")).as(N1QLExpression.i("count"))).from(keyspace).toString();
        } else {
            String projectedFields;
            entityFields = projectedFields = this.getProjectedOrDistinctFields(keyspace, domainClass, typeKey, fields, distinctFields);
            selectEntity = N1QLExpression.select(N1QLExpression.x(projectedFields)).from(keyspace).toString();
        }
        String typeSelection = !StringBasedN1qlQueryParser.empty(typeKey) && !StringBasedN1qlQueryParser.empty(typeValue) ? N1QLExpression.i(typeKey).eq(N1QLExpression.s(typeValue)).toString() : null;
        String delete = N1QLExpression.delete().from(keyspace).toString();
        String returning = " returning " + N1qlUtils.createReturningExpressionForDelete(keyspace);
        return new N1qlSpelValues(selectEntity, entityFields, N1QLExpression.i(b).toString(), N1QLExpression.i(scope).toString(), N1QLExpression.i(collection).toString(), typeSelection, delete, returning);
    }

    private static boolean empty(String s) {
        return s == null || s.length() == 0;
    }

    private String getProjectedOrDistinctFields(String b, Class resultClass, String typeField, String[] fields, String[] distinctFields) {
        Object projectedFields;
        if (distinctFields != null && distinctFields.length != 0) {
            return N1QLExpression.i(distinctFields).toString();
        }
        PersistentEntity persistentEntity = null;
        if (resultClass != null && !Modifier.isAbstract(resultClass.getModifiers())) {
            try {
                persistentEntity = this.couchbaseConverter.getMappingContext().getPersistentEntity(resultClass);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (persistentEntity != null) {
            StringBuilder sb = new StringBuilder();
            this.getProjectedFieldsInternal(b, null, sb, persistentEntity, typeField, fields, distinctFields != null);
            projectedFields = sb.toString();
        } else {
            projectedFields = N1QLExpression.i(b) + ".*, META(`" + b + "`).id AS __id, META(`" + b + "`).cas AS __cas";
        }
        return projectedFields;
    }

    private void getProjectedFieldsInternal(String bucketName, CouchbasePersistentProperty parent, StringBuilder sb, PersistentEntity persistentEntity, String typeField, String[] fields, boolean forDistinct) {
        sb.append(N1QLExpression.i(typeField));
        if (persistentEntity != null) {
            HashSet<String> fieldList = fields != null ? new HashSet<String>(Arrays.asList(fields)) : null;
            persistentEntity.doWithProperties(prop -> {
                if (prop == persistentEntity.getIdProperty() && parent == null) {
                    if (forDistinct) {
                        return;
                    }
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    PersistentPropertyPath path = this.couchbaseConverter.getMappingContext().getPersistentPropertyPath(prop.getName(), persistentEntity.getTypeInformation().getType());
                    String projectField = N1qlQueryCreator.addMetaIfRequired(bucketName, (PersistentPropertyPath<CouchbasePersistentProperty>)path, prop, persistentEntity).toString();
                    sb.append(projectField + " AS __id");
                    if (fieldList != null) {
                        fieldList.remove(prop.getFieldName());
                    }
                    return;
                }
                if (prop == persistentEntity.getVersionProperty() && parent == null) {
                    if (forDistinct) {
                        return;
                    }
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    PersistentPropertyPath path = this.couchbaseConverter.getMappingContext().getPersistentPropertyPath(prop.getName(), persistentEntity.getTypeInformation().getType());
                    String projectField = N1qlQueryCreator.addMetaIfRequired(bucketName, (PersistentPropertyPath<CouchbasePersistentProperty>)path, prop, persistentEntity).toString();
                    sb.append(projectField + " AS __cas");
                    if (fieldList != null) {
                        fieldList.remove(prop.getFieldName());
                    }
                    return;
                }
                if (prop.getFieldName().equals(typeField)) {
                    return;
                }
                if (forDistinct && prop.findAnnotation(Expiration.class) != null && parent == null) {
                    return;
                }
                String projectField = null;
                if (fieldList == null || fieldList.contains(prop.getFieldName())) {
                    PersistentPropertyPath path = this.couchbaseConverter.getMappingContext().getPersistentPropertyPath(prop.getName(), persistentEntity.getTypeInformation().getType());
                    projectField = N1qlQueryCreator.addMetaIfRequired(bucketName, (PersistentPropertyPath<CouchbasePersistentProperty>)path, prop, persistentEntity).toString();
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(projectField);
                }
                if (fieldList != null) {
                    fieldList.remove(prop.getFieldName());
                }
            });
            if (fieldList != null && !fieldList.isEmpty()) {
                throw new CouchbaseException("projected fields (" + fieldList + ") not found in entity: " + persistentEntity.getName());
            }
        } else {
            for (String field : fields) {
                if (!field.equals(typeField) && sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(N1QLExpression.x(field));
            }
        }
    }

    public static String doParse(String statement, SpelExpressionParser parser, EvaluationContext evaluationContext, N1qlSpelValues n1qlSpelValues) {
        Expression parsedExpression = parser.parseExpression(statement, (ParserContext)new TemplateParserContext());
        evaluationContext.setVariable(SPEL_PREFIX, (Object)n1qlSpelValues);
        return (String)parsedExpression.getValue(evaluationContext, String.class);
    }

    private void checkPlaceholders(String statement) {
        String placeholder;
        Matcher quoteMatcher = QUOTE_DETECTION_PATTERN.matcher(statement);
        Matcher positionMatcher = POSITIONAL_PLACEHOLDER_PATTERN.matcher(statement);
        Matcher namedMatcher = NAMED_PLACEHOLDER_PATTERN.matcher(statement);
        String queryIdentifier = (this.queryMethod != null ? ((Object)((Object)this.queryMethod)).getClass().getName() : StringQuery.class.getName()) + "." + (this.queryMethod != null ? this.queryMethod.getName() : this.statement);
        ArrayList<int[]> quotes = new ArrayList<int[]>();
        while (quoteMatcher.find()) {
            quotes.add(new int[]{quoteMatcher.start(), quoteMatcher.end()});
        }
        int posCount = 0;
        int namedCount = 0;
        while (positionMatcher.find()) {
            placeholder = positionMatcher.group(1);
            if (!this.checkNotQuoted(placeholder, positionMatcher.start(), positionMatcher.end(), quotes, queryIdentifier)) continue;
            if (this.queryMethod == null) {
                throw new IllegalArgumentException("StringQuery created from StringQuery(String) cannot have parameters. They cannot be processed. Use an @Query annotated method and the SPEL Expression #{[<n>]} : " + statement);
            }
            LOGGER.trace("{}: Found positional placeholder {}", (Object)queryIdentifier, (Object)placeholder);
            ++posCount;
            this.parameterNames.add(placeholder.substring(1));
        }
        while (namedMatcher.find()) {
            placeholder = namedMatcher.group(1);
            if (!this.checkNotQuoted(placeholder, namedMatcher.start(), namedMatcher.end(), quotes, queryIdentifier)) continue;
            if (this.queryMethod == null) {
                throw new IllegalArgumentException("StringQuery created from StringQuery(String) cannot have parameters. Use an @Query annotated method and the SPEL Expression #{[<n>]} : " + statement);
            }
            LOGGER.trace("{}: Found named placeholder {}", (Object)queryIdentifier, (Object)placeholder);
            ++namedCount;
            this.parameterNames.add(placeholder.substring(1));
        }
        if (posCount > 0 && namedCount > 0) {
            throw new IllegalArgumentException("Using both named (" + namedCount + ") and positional (" + posCount + ") placeholders is not supported, please choose one over the other in " + queryIdentifier + "()");
        }
        this.placeHolderType = posCount > 0 ? PlaceholderType.POSITIONAL : (namedCount > 0 ? PlaceholderType.NAMED : PlaceholderType.NONE);
        if (this.queryMethod == null) {
            Matcher spelMatcher = SPEL_EXPRESSION_PATTERN.matcher(statement);
            while (spelMatcher.find()) {
                String placeholder2 = spelMatcher.group(1);
                if (!this.checkNotQuoted(placeholder2, spelMatcher.start(), spelMatcher.end(), quotes, queryIdentifier)) continue;
                if (this.queryMethod == null) {
                    throw new IllegalArgumentException("StringQuery created from StringQuery(String) cannot SPEL expressions. Use an @Query annotated method and the SPEL Expression #{[<n>]} : " + statement);
                }
                LOGGER.trace("{}: Found SPEL Experssion {}", (Object)queryIdentifier, (Object)placeholder2);
            }
        }
    }

    private boolean checkNotQuoted(String item, int start, int end, List<int[]> quotes, String queryIdentifier) {
        for (int[] quote : quotes) {
            if (quote[0] > start || quote[1] < end) continue;
            LOGGER.trace("{}: potential placeholder {} is inside quotes, ignored", (Object)queryIdentifier, (Object)item);
            return false;
        }
        return true;
    }

    private JsonValue getPositionalPlaceholderValues(ParameterAccessor accessor) {
        JsonArray posValues = JsonArray.create();
        for (Parameter parameter : this.queryMethod.getParameters().getBindableParameters()) {
            Object rawValue = accessor.getBindableValue(parameter.getIndex());
            TreeMap<String, Object> value = this.couchbaseConverter.convertForWriteIfNeeded(rawValue);
            if (value instanceof CouchbaseDocument) {
                value = ((CouchbaseDocument)((Object)value)).export();
            }
            if (value instanceof CouchbaseList) {
                value = ((CouchbaseList)((Object)value)).export();
            }
            this.putPositionalValue(posValues, value);
        }
        return posValues;
    }

    private JsonObject getNamedPlaceholderValues(ParameterAccessor accessor) {
        JsonObject namedValues = JsonObject.create();
        HashSet<String> pNames = new HashSet<String>(this.parameterNames);
        for (Parameter parameter : this.queryMethod.getParameters().getBindableParameters()) {
            String placeholder = parameter.getPlaceholder();
            Object rawValue = accessor.getBindableValue(parameter.getIndex());
            TreeMap<String, Object> value = this.couchbaseConverter.convertForWriteIfNeeded(rawValue);
            if (value instanceof CouchbaseDocument) {
                value = ((CouchbaseDocument)((Object)value)).export();
            }
            if (value instanceof CouchbaseList) {
                value = ((CouchbaseList)((Object)value)).export();
            }
            if (placeholder != null && placeholder.charAt(0) == ':') {
                placeholder = placeholder.replaceFirst(":", "");
                this.putNamedValue(namedValues, placeholder, value);
                if (pNames.contains(placeholder)) {
                    pNames.remove(placeholder);
                    continue;
                }
                throw new RuntimeException("parameter named " + placeholder + " does not match any named parameter " + this.parameterNames + " in " + this.statement);
            }
            if (parameter.getName().isPresent()) {
                this.putNamedValue(namedValues, (String)parameter.getName().get(), value);
                continue;
            }
            throw new RuntimeException("cannot determine argument for named parameter. Argument " + parameter.getIndex() + " to " + ((Object)((Object)this.queryMethod)).getClass().getName() + "." + this.queryMethod.getName() + "() needs @Param(\"name\") that matches a named parameter in " + this.statement);
        }
        if (!pNames.isEmpty()) {
            throw new RuntimeException("no parameter found for " + pNames);
        }
        return namedValues;
    }

    public JsonValue getPlaceholderValues(ParameterAccessor accessor) {
        switch (this.placeHolderType) {
            case NAMED: {
                return this.getNamedPlaceholderValues(accessor);
            }
            case POSITIONAL: {
                return this.getPositionalPlaceholderValues(accessor);
            }
        }
        return JsonArray.create();
    }

    private void putPositionalValue(JsonArray posValues, Object value) {
        try {
            posValues.add(value);
        }
        catch (InvalidArgumentException iae) {
            if (value instanceof Object[]) {
                this.addAsArray(posValues, value);
            }
            throw iae;
        }
    }

    private void addAsArray(JsonArray posValues, Object o) {
        Object[] array = (Object[])o;
        JsonArray ja = JsonValue.ja();
        for (Object e : array) {
            ja.add(String.valueOf(this.couchbaseConverter.convertForWriteIfNeeded(e)));
        }
        posValues.add(ja);
    }

    private void putNamedValue(JsonObject namedValues, String placeholder, Object value) {
        try {
            namedValues.put(placeholder, value);
        }
        catch (InvalidArgumentException iae) {
            if (value instanceof Object[]) {
                this.addAsArray(namedValues, placeholder, value);
            }
            throw iae;
        }
    }

    private void addAsArray(JsonObject namedValues, String placeholder, Object o) {
        Object[] array = (Object[])o;
        JsonArray ja = JsonValue.ja();
        for (Object e : array) {
            ja.add(String.valueOf(this.couchbaseConverter.convertForWriteIfNeeded(e)));
        }
        namedValues.put(placeholder, ja);
    }

    protected boolean useGeneratedCountQuery() {
        return this.statement.contains(SPEL_SELECT_FROM_CLAUSE);
    }

    public N1qlSpelValues getStatementContext() {
        return this.statementContext;
    }

    public String getStatement() {
        return this.statement;
    }

    public N1QLExpression getExpression(String statement, CouchbaseQueryMethod queryMethod, ParameterAccessor accessor, SpelExpressionParser parser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        N1QLExpression parsedStatement;
        if (accessor != null && queryMethod != null && parser != null) {
            Object[] runtimeParameters = StringBasedN1qlQueryParser.getParameters(accessor);
            EvaluationContext evaluationContext = evaluationContextProvider.getEvaluationContext(queryMethod.getParameters(), runtimeParameters);
            parsedStatement = N1QLExpression.x(StringBasedN1qlQueryParser.doParse(statement, parser, evaluationContext, this.getStatementContext()));
        } else {
            parsedStatement = N1QLExpression.x(statement);
        }
        this.checkPlaceholders(parsedStatement.toString());
        return parsedStatement;
    }

    private static Object[] getParameters(ParameterAccessor accessor) {
        ArrayList params = new ArrayList();
        for (Object o : accessor) {
            params.add(o);
        }
        params.add(accessor.getPageable());
        params.add(accessor.getSort());
        return params.toArray();
    }

    public static final class N1qlSpelValues {
        public final String selectEntity;
        public final String fields;
        public final String bucket;
        public final String scope;
        public final String collection;
        public final String filter;
        public final String delete;
        public final String returning;

        public N1qlSpelValues(String selectClause, String entityFields, String bucket, String scope, String collection, String filter, String delete, String returning) {
            this.selectEntity = selectClause;
            this.fields = entityFields;
            this.bucket = bucket;
            this.scope = scope;
            this.collection = collection;
            this.filter = filter;
            this.delete = delete;
            this.returning = returning;
        }
    }

    private static enum PlaceholderType {
        NAMED,
        POSITIONAL,
        NONE;

    }
}

