/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.convert.join;

import com.couchbase.client.java.query.QueryOptions;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.core.TypeInformation;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.query.FetchType;
import org.springframework.data.couchbase.core.query.HashSide;
import org.springframework.data.couchbase.core.query.N1QLExpression;
import org.springframework.data.couchbase.core.query.N1QLQuery;
import org.springframework.data.couchbase.core.query.N1qlJoin;
import org.springframework.data.couchbase.core.query.OptionsBuilder;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.data.couchbase.repository.Collection;
import org.springframework.data.couchbase.repository.Scope;
import org.springframework.data.couchbase.repository.query.StringBasedN1qlQueryParser;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.util.Assert;

public class N1qlJoinResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(N1qlJoinResolver.class);

    public static <L, R> String buildQuery(ReactiveCouchbaseTemplate template, String scope, String collection, N1qlJoinResolverParameters parameters) {
        String joinType = "JOIN";
        String selectEntity = "SELECT META(rks).id AS __id, META(rks).cas AS __cas, (rks).* ";
        StringBuilder useLKSBuilder = new StringBuilder();
        if (parameters.getJoinDefinition().index().length() > 0) {
            useLKSBuilder.append("INDEX(" + parameters.getJoinDefinition().index() + ")");
        }
        String useLKS = useLKSBuilder.length() > 0 ? "USE " + useLKSBuilder.toString() + " " : "";
        KeySpacePair keySpacePair = N1qlJoinResolver.getKeySpacePair(template.getBucketName(), scope, collection, parameters);
        String from = "FROM " + String.valueOf(keySpacePair.lhs.keyspace) + " lks " + useLKS + joinType + " " + String.valueOf(keySpacePair.rhs.keyspace) + " rks";
        StringBasedN1qlQueryParser.N1qlSpelValues n1qlL = Query.getN1qlSpelValues(template.getConverter(), null, scope, keySpacePair.lhs.collection, parameters.getEntityTypeInfo().getType(), parameters.getEntityTypeInfo().getType(), false, null, null);
        String onLks = "lks." + n1qlL.filter;
        StringBasedN1qlQueryParser.N1qlSpelValues n1qlR = Query.getN1qlSpelValues(template.getConverter(), null, scope, keySpacePair.rhs.collection, parameters.getAssociatedEntityTypeInfo().getType(), parameters.getAssociatedEntityTypeInfo().getType(), false, null, null);
        String onRks = "rks." + n1qlR.filter;
        StringBuilder useRKSBuilder = new StringBuilder();
        if (parameters.getJoinDefinition().rightIndex().length() > 0) {
            useRKSBuilder.append("INDEX(" + parameters.getJoinDefinition().rightIndex() + ")");
        }
        if (!parameters.getJoinDefinition().hashside().equals((Object)HashSide.NONE)) {
            if (useRKSBuilder.length() > 0) {
                useRKSBuilder.append(" ");
            }
            useRKSBuilder.append("HASH(" + parameters.getJoinDefinition().hashside().getValue() + ")");
        }
        if (parameters.getJoinDefinition().keys().length > 0) {
            if (useRKSBuilder.length() > 0) {
                useRKSBuilder.append(" ");
            }
            useRKSBuilder.append("KEYS [");
            String[] keys = parameters.getJoinDefinition().keys();
            for (int i = 0; i < keys.length; ++i) {
                if (i != 0) {
                    useRKSBuilder.append(",");
                }
                useRKSBuilder.append("\"" + keys[i] + "\"");
            }
            useRKSBuilder.append("]");
        }
        String on = "ON " + parameters.getJoinDefinition().on().concat(" AND " + onLks).concat(" AND " + onRks);
        String where = "WHERE META(lks).id=\"" + parameters.getLksId() + "\"";
        where = where + (String)(parameters.getJoinDefinition().where().length() > 0 ? " AND " + parameters.getJoinDefinition().where() : "");
        StringBuilder statementSb = new StringBuilder();
        statementSb.append(selectEntity);
        statementSb.append(" " + from);
        statementSb.append((String)(useRKSBuilder.length() > 0 ? " USE " + useRKSBuilder.toString() : ""));
        statementSb.append(" " + on);
        statementSb.append(" " + where);
        return statementSb.toString();
    }

    static KeySpacePair getKeySpacePair(String bucketName, String scope, String collection, N1qlJoinResolverParameters parameters) {
        Class lhsClass = parameters.getEntityTypeInfo().getActualType().getType();
        String lhScope = scope != null ? scope : N1qlJoinResolver.getScope(lhsClass);
        String lhCollection = collection != null ? collection : N1qlJoinResolver.getCollection(lhsClass);
        Class rhsClass = parameters.getAssociatedEntityTypeInfo().getActualType().getType();
        String rhScope = N1qlJoinResolver.getScope(rhsClass);
        String rhCollection = N1qlJoinResolver.getCollection(rhsClass);
        if (lhCollection != null && rhCollection != null) {
            return new KeySpacePair(lhCollection, N1QLExpression.x(String.valueOf(N1QLExpression.i(bucketName)) + "." + String.valueOf(N1QLExpression.i(lhScope)) + "." + String.valueOf(N1QLExpression.i(lhCollection))), rhCollection, N1QLExpression.x(String.valueOf(N1QLExpression.i(bucketName)) + "." + String.valueOf(N1QLExpression.i(lhScope)) + "." + String.valueOf(N1QLExpression.i(rhCollection))));
        }
        if (lhCollection != null && rhCollection == null) {
            return new KeySpacePair(lhCollection, N1QLExpression.x(String.valueOf(N1QLExpression.i(bucketName)) + "." + String.valueOf(N1QLExpression.i(lhScope)) + "." + String.valueOf(N1QLExpression.i(lhCollection))), null, N1QLExpression.i(bucketName));
        }
        if (lhCollection == null && rhCollection != null) {
            return new KeySpacePair(null, N1QLExpression.i(bucketName), rhCollection, N1QLExpression.x(String.valueOf(N1QLExpression.i(bucketName)) + "." + String.valueOf(N1QLExpression.i(rhScope)) + "." + String.valueOf(N1QLExpression.i(rhCollection))));
        }
        return new KeySpacePair(null, N1QLExpression.i(bucketName), null, N1QLExpression.i(bucketName));
    }

    static String getCollection(Class<?> targetClass) {
        AnnotatedElement[] annotated = new AnnotatedElement[]{targetClass};
        return OptionsBuilder.annotationString(Collection.class, "_default", annotated);
    }

    static String getScope(Class<?> targetClass) {
        AnnotatedElement[] annotated = new AnnotatedElement[]{targetClass};
        return OptionsBuilder.annotationString(Scope.class, "_default", annotated);
    }

    public static <R> List<R> doResolve(ReactiveCouchbaseTemplate template, String scopeName, String collectionName, N1qlJoinResolverParameters parameters, Class<R> associatedEntityClass) {
        String statement = N1qlJoinResolver.buildQuery(template, scopeName, collectionName, parameters);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Join query executed " + statement);
        }
        N1QLQuery query = new N1QLQuery(N1QLExpression.x(statement), QueryOptions.queryOptions());
        List result = (List)template.findByQuery(associatedEntityClass).matching(query).all().collectList().block();
        return result.isEmpty() ? null : result;
    }

    public static boolean isLazyJoin(N1qlJoin joinDefinition) {
        return joinDefinition.fetchType().equals((Object)FetchType.LAZY);
    }

    public static void handleProperties(CouchbasePersistentEntity<?> persistentEntity, ConvertingPropertyAccessor<?> accessor, ReactiveCouchbaseTemplate template, String id, String scope, String collection) {
        persistentEntity.doWithProperties(prop -> {
            if (prop.isAnnotationPresent(N1qlJoin.class)) {
                N1qlJoin definition = (N1qlJoin)prop.findAnnotation(N1qlJoin.class);
                TypeInformation type = prop.getTypeInformation().getActualType();
                Class clazz = type.getType();
                N1qlJoinResolverParameters parameters = new N1qlJoinResolverParameters(definition, id, persistentEntity.getTypeInformation(), type, scope, collection);
                if (N1qlJoinResolver.isLazyJoin(definition)) {
                    N1qlJoinProxy proxy = new N1qlJoinProxy(template, parameters);
                    accessor.setProperty(prop, Proxy.newProxyInstance(List.class.getClassLoader(), new Class[]{List.class}, (InvocationHandler)proxy));
                } else {
                    accessor.setProperty(prop, N1qlJoinResolver.doResolve(template, scope, collection, parameters, clazz));
                }
            }
        });
    }

    public static class N1qlJoinResolverParameters {
        private N1qlJoin joinDefinition;
        private String lksId;
        private TypeInformation<?> entityTypeInfo;
        private TypeInformation<?> associatedEntityTypeInfo;
        private String scopeName;
        private String collectionName;

        public N1qlJoinResolverParameters(N1qlJoin joinDefinition, String lksId, TypeInformation<?> entityTypeInfo, TypeInformation<?> associatedEntityTypeInfo, String scopeName, String collectionName) {
            Assert.notNull((Object)joinDefinition, (String)"The join definition is required");
            Assert.notNull(entityTypeInfo, (String)"The entity type information is required");
            Assert.notNull(associatedEntityTypeInfo, (String)"The associated entity type information is required");
            this.joinDefinition = joinDefinition;
            this.lksId = lksId;
            this.entityTypeInfo = entityTypeInfo;
            this.associatedEntityTypeInfo = associatedEntityTypeInfo;
            this.scopeName = scopeName;
            this.collectionName = collectionName;
        }

        public N1qlJoin getJoinDefinition() {
            return this.joinDefinition;
        }

        public String getLksId() {
            return this.lksId;
        }

        public TypeInformation getEntityTypeInfo() {
            return this.entityTypeInfo;
        }

        public TypeInformation getAssociatedEntityTypeInfo() {
            return this.associatedEntityTypeInfo;
        }

        public String getScopeName() {
            return this.scopeName;
        }

        public String getCollectionName() {
            return this.collectionName;
        }
    }

    static class KeySpacePair {
        KeySpaceInfo lhs;
        KeySpaceInfo rhs;

        public KeySpacePair(String lhsCollection, N1QLExpression lhsKeyspace, String rhsCollection, N1QLExpression rhsKeyspace) {
            this.lhs = new KeySpaceInfo(lhsCollection, lhsKeyspace);
            this.rhs = new KeySpaceInfo(rhsCollection, rhsKeyspace);
        }

        static class KeySpaceInfo {
            String collection;
            N1QLExpression keyspace;

            public KeySpaceInfo(String collection, N1QLExpression keyspace) {
                this.collection = collection;
                this.keyspace = keyspace;
            }
        }
    }

    public static class N1qlJoinProxy
    implements InvocationHandler {
        private final ReactiveCouchbaseTemplate reactiveTemplate;
        private final String collectionName;
        private final String scopeName;
        private final N1qlJoinResolverParameters params;
        private List<?> resolved = null;

        public N1qlJoinProxy(ReactiveCouchbaseTemplate template, N1qlJoinResolverParameters params) {
            this.collectionName = null;
            this.scopeName = null;
            this.reactiveTemplate = template;
            this.params = params;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this.resolved == null) {
                this.resolved = N1qlJoinResolver.doResolve(this.reactiveTemplate, this.params.getScopeName(), this.params.getCollectionName(), this.params, this.params.associatedEntityTypeInfo.getType());
            }
            return method.invoke(this.resolved, args);
        }
    }
}

