/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.data.couchbase.repository.query.AbstractCouchbaseQuery;
import org.springframework.data.couchbase.repository.query.CouchbasePartTree;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.N1qlQueryCreator;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.data.repository.query.parser.PartTree;

public class PartTreeCouchbaseQuery
extends AbstractCouchbaseQuery {
    private final CouchbasePartTree tree;
    private final CouchbaseConverter converter;

    public PartTreeCouchbaseQuery(CouchbaseQueryMethod method, CouchbaseOperations operations, ValueExpressionDelegate valueExpressionDelegate) {
        super(method, operations, valueExpressionDelegate);
        ResultProcessor processor = method.getResultProcessor();
        this.tree = new CouchbasePartTree(method.getName(), processor.getReturnedType().getDomainType());
        this.converter = operations.getConverter();
    }

    public PartTree getTree() {
        return this.tree;
    }

    @Override
    protected Query createQuery(ParametersParameterAccessor accessor) {
        N1qlQueryCreator creator = new N1qlQueryCreator(this.tree, (ParameterAccessor)accessor, this.getQueryMethod(), this.converter, ((CouchbaseOperations)this.getOperations()).getBucketName());
        Query query = creator.createQuery();
        if (this.tree.isLimiting()) {
            query.limit(this.tree.getMaxResults());
        }
        if (this.tree.isDistinct()) {
            query.distinct(this.tree.getDistinctFields());
        }
        return query;
    }

    @Override
    protected Query createCountQuery(ParametersParameterAccessor accessor) {
        return new N1qlQueryCreator(this.tree, (ParameterAccessor)accessor, this.getQueryMethod(), this.converter, ((CouchbaseOperations)this.getOperations()).getBucketName()).createQuery();
    }

    @Override
    protected boolean isCountQuery() {
        return this.tree.isCountProjection();
    }

    @Override
    protected boolean isExistsQuery() {
        return this.tree.isExistsProjection();
    }

    @Override
    protected boolean isDeleteQuery() {
        return this.tree.isDelete();
    }

    @Override
    protected boolean isLimiting() {
        return this.tree.isLimiting();
    }
}

