/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.data.couchbase.repository.query.AbstractCouchbaseQuery;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.StringN1qlQueryCreator;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.ValueExpressionDelegate;

public class StringBasedCouchbaseQuery
extends AbstractCouchbaseQuery {
    private static final String COUNT_EXISTS_AND_DELETE = "Manually defined query for %s cannot be a count and exists or delete query at the same time!";
    private static final Logger LOG = LoggerFactory.getLogger(StringBasedCouchbaseQuery.class);
    private final ValueExpressionDelegate valueExpressionDelegate;
    private final NamedQueries namedQueries;

    public StringBasedCouchbaseQuery(CouchbaseQueryMethod method, CouchbaseOperations couchbaseOperations, ValueExpressionDelegate valueExpressionDelegate, NamedQueries namedQueries) {
        super(method, couchbaseOperations, valueExpressionDelegate);
        this.valueExpressionDelegate = valueExpressionDelegate;
        if (StringBasedCouchbaseQuery.hasAmbiguousProjectionFlags(this.isCountQuery(), this.isExistsQuery(), this.isDeleteQuery())) {
            throw new IllegalArgumentException(String.format(COUNT_EXISTS_AND_DELETE, new Object[]{method}));
        }
        this.namedQueries = namedQueries;
    }

    @Override
    protected Query createQuery(ParametersParameterAccessor accessor) {
        StringN1qlQueryCreator creator = new StringN1qlQueryCreator((ParameterAccessor)accessor, this.getQueryMethod(), ((CouchbaseOperations)this.getOperations()).getConverter(), this.valueExpressionDelegate, this.namedQueries);
        Query query = creator.createQuery();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Created query " + query.export(new int[0][]));
        }
        return query;
    }

    @Override
    protected Query createCountQuery(ParametersParameterAccessor accessor) {
        return this.applyQueryMetaAttributesIfPresent(this.createQuery(accessor), null);
    }

    @Override
    protected boolean isLimiting() {
        return false;
    }
}

