/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.ClientRegionFactory;
import org.apache.geode.cache.client.ClientRegionShortcut;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.PoolManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.data.gemfire.DataPolicyConverter;
import org.springframework.data.gemfire.RegionLookupFactoryBean;
import org.springframework.data.gemfire.client.ClientRegionShortcutWrapper;
import org.springframework.data.gemfire.client.Interest;
import org.springframework.data.gemfire.config.annotation.RegionConfigurer;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CacheUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ClientRegionFactoryBean<K, V>
extends RegionLookupFactoryBean<K, V>
implements DisposableBean {
    public static final String DEFAULT_POOL_NAME = "DEFAULT";
    public static final String GEMFIRE_POOL_NAME = "gemfirePool";
    private boolean close = false;
    private boolean destroy = false;
    private Boolean persistent;
    private CacheListener<K, V>[] cacheListeners;
    private CacheLoader<K, V> cacheLoader;
    private CacheWriter<K, V> cacheWriter;
    private Class<K> keyConstraint;
    private Class<V> valueConstraint;
    private ClientRegionShortcut shortcut;
    private DataPolicy dataPolicy;
    private EvictionAttributes evictionAttributes;
    private Interest<K>[] interests;
    private List<RegionConfigurer> regionConfigurers = Collections.emptyList();
    private RegionAttributes<K, V> attributes;
    private RegionConfigurer compositeRegionConfigurer = new RegionConfigurer(){

        @Override
        public void configure(String beanName, ClientRegionFactoryBean<?, ?> bean) {
            CollectionUtils.nullSafeCollection(ClientRegionFactoryBean.this.regionConfigurers).forEach(regionConfigurer -> regionConfigurer.configure(beanName, bean));
        }
    };
    private String diskStoreName;
    private String poolName;

    @Override
    protected Region<K, V> createRegion(GemFireCache gemfireCache, String regionName) throws Exception {
        this.applyRegionConfigurers(regionName);
        ClientCache cache = this.resolveCache(gemfireCache);
        ClientRegionFactory<K, V> clientRegionFactory = this.postProcess(this.configure(this.createClientRegionFactory(cache, this.resolveClientRegionShortcut())));
        Region<K, V> region = this.newRegion(clientRegionFactory, this.getParent(), regionName);
        return region;
    }

    private void applyRegionConfigurers(String regionName) {
        this.applyRegionConfigurers(regionName, this.getCompositeRegionConfigurer());
    }

    protected void applyRegionConfigurers(String regionName, RegionConfigurer ... regionConfigurers) {
        this.applyRegionConfigurers(regionName, Arrays.asList(ArrayUtils.nullSafeArray(regionConfigurers, RegionConfigurer.class)));
    }

    protected void applyRegionConfigurers(String regionName, Iterable<RegionConfigurer> regionConfigurers) {
        StreamSupport.stream(CollectionUtils.nullSafeIterable(regionConfigurers).spliterator(), false).forEach(regionConfigurer -> regionConfigurer.configure(regionName, this));
    }

    private void assertClientRegionShortcutAndPersistentAttributeAreCompatible(ClientRegionShortcut resolvedShortcut) {
        boolean persistentNotSpecified;
        boolean bl = persistentNotSpecified = this.persistent == null;
        if (ClientRegionShortcutWrapper.valueOf(resolvedShortcut).isPersistent()) {
            Assert.isTrue((persistentNotSpecified || this.isPersistent() ? 1 : 0) != 0, (String)String.format("Client Region Shortcut [%s] is not valid when persistent is false", resolvedShortcut));
        } else {
            Assert.isTrue((persistentNotSpecified || this.isNotPersistent() ? 1 : 0) != 0, (String)String.format("Client Region Shortcut [%s] is not valid when persistent is true", resolvedShortcut));
        }
    }

    private void assertDataPolicyAndPersistentAttributeAreCompatible(DataPolicy resolvedDataPolicy) {
        if (resolvedDataPolicy.withPersistence()) {
            Assert.isTrue((this.isPersistentUnspecified() || this.isPersistent() ? 1 : 0) != 0, (String)String.format("Data Policy [%s] is not valid when persistent is false", resolvedDataPolicy));
        } else {
            Assert.isTrue((this.isPersistentUnspecified() || this.isNotPersistent() ? 1 : 0) != 0, (String)String.format("Data Policy [%s] is not valid when persistent is true", resolvedDataPolicy));
        }
    }

    private Region<K, V> newRegion(ClientRegionFactory<K, V> clientRegionFactory, Region<?, ?> parentRegion, String regionName) {
        return Optional.ofNullable(parentRegion).map(parent -> {
            this.logInfo("Creating client Subregion [%1$s] with parent Region [%2$s]", regionName, parent.getName());
            return clientRegionFactory.createSubregion(parent, regionName);
        }).orElseGet(() -> {
            this.logInfo("Created client Region [%s]", regionName);
            return clientRegionFactory.create(regionName);
        });
    }

    private ClientCache resolveCache(GemFireCache gemfireCache) {
        return Optional.ofNullable(gemfireCache).filter(CacheUtils::isClient).map(cache -> (ClientCache)cache).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException("ClientCache is required", new Object[0]));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ClientRegionShortcut resolveClientRegionShortcut() {
        ClientRegionShortcut resolvedShortcut = this.shortcut;
        if (resolvedShortcut == null) {
            DataPolicy dataPolicy = this.dataPolicy;
            if (dataPolicy != null) {
                this.assertDataPolicyAndPersistentAttributeAreCompatible(dataPolicy);
                if (DataPolicy.EMPTY.equals(dataPolicy)) {
                    resolvedShortcut = ClientRegionShortcut.PROXY;
                } else if (DataPolicy.NORMAL.equals(dataPolicy)) {
                    resolvedShortcut = ClientRegionShortcut.CACHING_PROXY;
                } else {
                    if (!DataPolicy.PERSISTENT_REPLICATE.equals(dataPolicy)) throw RuntimeExceptionFactory.newIllegalArgumentException("Data Policy [%s] is not valid for the client Region", dataPolicy);
                    resolvedShortcut = ClientRegionShortcut.LOCAL_PERSISTENT;
                }
            } else {
                resolvedShortcut = this.isPersistent() ? ClientRegionShortcut.LOCAL_PERSISTENT : ClientRegionShortcut.LOCAL;
            }
        }
        this.assertClientRegionShortcutAndPersistentAttributeAreCompatible(resolvedShortcut);
        return resolvedShortcut;
    }

    private String resolvePoolName() {
        return Optional.of(this.getPoolName()).filter(this::isPoolResolvable).orElse(null);
    }

    private String getPoolName() {
        return Optional.ofNullable(this.poolName).filter(StringUtils::hasText).orElse(GEMFIRE_POOL_NAME);
    }

    private boolean isPoolResolvable(String poolName) {
        return this.getBeanFactory().containsBean(poolName) || PoolManager.find((String)poolName) != null;
    }

    private String eagerlyInitializePool(String poolName) {
        try {
            if (this.getBeanFactory().isTypeMatch(poolName, Pool.class)) {
                this.logDebug("Found bean definition for Pool [%s]; Eagerly initializing...", poolName);
                this.getBeanFactory().getBean(poolName, Pool.class);
            }
        }
        catch (BeansException ignore) {
            this.getLog().warn((Object)ignore.getMessage(), ignore.getCause());
        }
        return poolName;
    }

    protected ClientRegionFactory<K, V> createClientRegionFactory(ClientCache cache, ClientRegionShortcut shortcut) {
        return cache.createClientRegionFactory(shortcut);
    }

    protected ClientRegionFactory<K, V> configure(ClientRegionFactory<K, V> clientRegionFactory) {
        Optional.ofNullable(this.attributes).ifPresent(attributes -> {
            Arrays.stream(ArrayUtils.nullSafeArray(attributes.getCacheListeners(), CacheListener.class)).forEach(arg_0 -> ((ClientRegionFactory)clientRegionFactory).addCacheListener(arg_0));
            clientRegionFactory.setCloningEnabled(attributes.getCloningEnabled());
            clientRegionFactory.setCompressor(attributes.getCompressor());
            clientRegionFactory.setConcurrencyChecksEnabled(attributes.getConcurrencyChecksEnabled());
            clientRegionFactory.setConcurrencyLevel(attributes.getConcurrencyLevel());
            clientRegionFactory.setCustomEntryIdleTimeout(attributes.getCustomEntryIdleTimeout());
            clientRegionFactory.setCustomEntryTimeToLive(attributes.getCustomEntryTimeToLive());
            clientRegionFactory.setDiskStoreName(attributes.getDiskStoreName());
            clientRegionFactory.setDiskSynchronous(attributes.isDiskSynchronous());
            clientRegionFactory.setEntryIdleTimeout(attributes.getEntryIdleTimeout());
            clientRegionFactory.setEntryTimeToLive(attributes.getEntryTimeToLive());
            clientRegionFactory.setEvictionAttributes(attributes.getEvictionAttributes());
            clientRegionFactory.setInitialCapacity(attributes.getInitialCapacity());
            clientRegionFactory.setKeyConstraint(attributes.getKeyConstraint());
            clientRegionFactory.setLoadFactor(attributes.getLoadFactor());
            clientRegionFactory.setPoolName(attributes.getPoolName());
            clientRegionFactory.setRegionIdleTimeout(attributes.getRegionIdleTimeout());
            clientRegionFactory.setRegionTimeToLive(attributes.getRegionTimeToLive());
            clientRegionFactory.setStatisticsEnabled(attributes.getStatisticsEnabled());
            clientRegionFactory.setValueConstraint(attributes.getValueConstraint());
        });
        Arrays.stream(ArrayUtils.nullSafeArray(this.cacheListeners, CacheListener.class)).forEach(arg_0 -> clientRegionFactory.addCacheListener(arg_0));
        Optional.ofNullable(this.diskStoreName).filter(StringUtils::hasText).ifPresent(arg_0 -> clientRegionFactory.setDiskStoreName(arg_0));
        Optional.ofNullable(this.evictionAttributes).ifPresent(arg_0 -> clientRegionFactory.setEvictionAttributes(arg_0));
        Optional.ofNullable(this.keyConstraint).ifPresent(arg_0 -> clientRegionFactory.setKeyConstraint(arg_0));
        Optional.ofNullable(this.resolvePoolName()).filter(StringUtils::hasText).ifPresent(poolName -> clientRegionFactory.setPoolName(this.eagerlyInitializePool((String)poolName)));
        Optional.ofNullable(this.valueConstraint).ifPresent(arg_0 -> clientRegionFactory.setValueConstraint(arg_0));
        return clientRegionFactory;
    }

    @Override
    protected ClientRegionFactory<K, V> postProcess(ClientRegionFactory<K, V> clientRegionFactory) {
        return clientRegionFactory;
    }

    @Override
    protected Region<K, V> postProcess(Region<K, V> region) {
        super.postProcess(region);
        this.registerInterests(region);
        Optional.ofNullable(this.cacheLoader).ifPresent(cacheLoader -> region.getAttributesMutator().setCacheLoader(cacheLoader));
        Optional.ofNullable(this.cacheWriter).ifPresent(cacheWriter -> region.getAttributesMutator().setCacheWriter(cacheWriter));
        return region;
    }

    private Region<K, V> registerInterests(Region<K, V> region) {
        Arrays.stream(ArrayUtils.nullSafeArray(this.interests, Interest.class)).forEach(interest -> {
            if (interest.isRegexType()) {
                region.registerInterestRegex((String)interest.getKey(), interest.getPolicy(), interest.isDurable(), interest.isReceiveValues());
            } else {
                region.registerInterest(interest.getKey(), interest.getPolicy(), interest.isDurable(), interest.isReceiveValues());
            }
        });
        return region;
    }

    public void destroy() throws Exception {
        Optional.ofNullable(this.getObject()).ifPresent(region -> {
            if (this.isClose() && !region.getRegionService().isClosed()) {
                try {
                    region.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.isDestroy()) {
                region.destroyRegion();
            }
        });
    }

    protected RegionConfigurer getCompositeRegionConfigurer() {
        return this.compositeRegionConfigurer;
    }

    public void setAttributes(RegionAttributes<K, V> attributes) {
        this.attributes = attributes;
    }

    public void setCacheListeners(CacheListener<K, V>[] cacheListeners) {
        this.cacheListeners = cacheListeners;
    }

    public void setCacheLoader(CacheLoader<K, V> cacheLoader) {
        this.cacheLoader = cacheLoader;
    }

    public void setCacheWriter(CacheWriter<K, V> cacheWriter) {
        this.cacheWriter = cacheWriter;
    }

    final boolean isClose() {
        return this.close;
    }

    public void setClose(boolean close) {
        this.close = close;
        this.destroy = this.destroy && !close;
    }

    public void setDataPolicy(DataPolicy dataPolicy) {
        this.dataPolicy = dataPolicy;
    }

    @Deprecated
    public void setDataPolicyName(String dataPolicyName) {
        DataPolicy resolvedDataPolicy = new DataPolicyConverter().convert(dataPolicyName);
        Assert.notNull((Object)resolvedDataPolicy, (String)String.format("Data Policy [%1$s] is not valid", dataPolicyName));
        this.setDataPolicy(resolvedDataPolicy);
    }

    final boolean isDestroy() {
        return this.destroy;
    }

    public void setDestroy(boolean destroy) {
        this.destroy = destroy;
        this.close = this.close && !destroy;
    }

    public void setDiskStoreName(String diskStoreName) {
        this.diskStoreName = diskStoreName;
    }

    public void setEvictionAttributes(EvictionAttributes evictionAttributes) {
        this.evictionAttributes = evictionAttributes;
    }

    public void setInterests(Interest<K>[] interests) {
        this.interests = interests;
    }

    Interest<K>[] getInterests() {
        return this.interests;
    }

    public void setKeyConstraint(Class<K> keyConstraint) {
        this.keyConstraint = keyConstraint;
    }

    protected boolean isPersistentUnspecified() {
        return this.persistent == null;
    }

    protected boolean isPersistent() {
        return Boolean.TRUE.equals(this.persistent);
    }

    protected boolean isNotPersistent() {
        return Boolean.FALSE.equals(this.persistent);
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public void setPool(Pool pool) {
        this.setPoolName(Optional.ofNullable(pool).map(Pool::getName).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException("Pool cannot be null", new Object[0])));
    }

    public void setPoolName(String poolName) {
        this.poolName = Optional.ofNullable(poolName).filter(StringUtils::hasText).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException("Pool name is required", new Object[0]));
    }

    public void setRegionConfigurers(RegionConfigurer ... regionConfigurers) {
        this.setRegionConfigurers(Arrays.asList(ArrayUtils.nullSafeArray(regionConfigurers, RegionConfigurer.class)));
    }

    public void setRegionConfigurers(List<RegionConfigurer> regionConfigurers) {
        this.regionConfigurers = Optional.ofNullable(regionConfigurers).orElseGet(Collections::emptyList);
    }

    public void setShortcut(ClientRegionShortcut shortcut) {
        this.shortcut = shortcut;
    }

    public void setValueConstraint(Class<V> valueConstraint) {
        this.valueConstraint = valueConstraint;
    }
}

