/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.config.annotation.CacheServerConfigurer;
import org.springframework.data.gemfire.config.annotation.EnableCacheServer;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.data.gemfire.server.CacheServerFactoryBean;
import org.springframework.data.gemfire.server.SubscriptionEvictionPolicy;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class AddCacheServerConfiguration
extends AbstractAnnotationConfigSupport
implements ImportBeanDefinitionRegistrar {
    @Autowired(required=false)
    private List<CacheServerConfigurer> cacheServerConfigurers = Collections.emptyList();

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        if (importingClassMetadata.hasAnnotation(EnableCacheServer.class.getName())) {
            Map enableCacheServerAttributes = importingClassMetadata.getAnnotationAttributes(EnableCacheServer.class.getName());
            this.registerCacheServerFactoryBeanDefinition(enableCacheServerAttributes, registry);
        }
    }

    protected void registerCacheServerFactoryBeanDefinition(Map<String, Object> enableCacheServerAttributes, BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CacheServerFactoryBean.class);
        String beanName = this.registerCacheServerFactoryBeanDefinition(builder.getBeanDefinition(), (String)enableCacheServerAttributes.get("name"), registry);
        builder.addPropertyReference("cache", "gemfireCache");
        builder.addPropertyValue("cacheServerConfigurers", this.resolveCacheServerConfigurers());
        builder.addPropertyValue("autoStartup", (Object)this.resolveProperty(this.namedCacheServerProperty(beanName, "auto-startup"), this.resolveProperty(this.cacheServerProperty("auto-startup"), (Boolean)enableCacheServerAttributes.get("autoStartup"))));
        builder.addPropertyValue("bindAddress", (Object)this.resolveProperty(this.namedCacheServerProperty(beanName, "bind-address"), this.resolveProperty(this.cacheServerProperty("bind-address"), (String)enableCacheServerAttributes.get("bindAddress"))));
        builder.addPropertyValue("hostNameForClients", (Object)this.resolveProperty(this.namedCacheServerProperty(beanName, "hostname-for-clients"), this.resolveProperty(this.cacheServerProperty("hostname-for-clients"), (String)enableCacheServerAttributes.get("hostnameForClients"))));
        builder.addPropertyValue("loadPollInterval", (Object)this.resolveProperty(this.namedCacheServerProperty(beanName, "load-poll-interval"), this.resolveProperty(this.cacheServerProperty("load-poll-interval"), (Long)enableCacheServerAttributes.get("loadPollInterval"))));
        builder.addPropertyValue("maxConnections", (Object)this.resolveProperty(this.namedCacheServerProperty(beanName, "max-connections"), this.resolveProperty(this.cacheServerProperty("max-connections"), (Integer)enableCacheServerAttributes.get("maxConnections"))));
        builder.addPropertyValue("maxMessageCount", (Object)this.resolveProperty(this.namedCacheServerProperty(beanName, "max-message-count"), this.resolveProperty(this.cacheServerProperty("max-message-count"), (Integer)enableCacheServerAttributes.get("maxMessageCount"))));
        builder.addPropertyValue("maxThreads", (Object)this.resolveProperty(this.namedCacheServerProperty(beanName, "max-threads"), this.resolveProperty(this.cacheServerProperty("max-threads"), (Integer)enableCacheServerAttributes.get("maxThreads"))));
        builder.addPropertyValue("maxTimeBetweenPings", (Object)this.resolveProperty(this.namedCacheServerProperty(beanName, "max-time-between-pings"), this.resolveProperty(this.cacheServerProperty("max-time-between-pings"), (Integer)enableCacheServerAttributes.get("maxTimeBetweenPings"))));
        builder.addPropertyValue("messageTimeToLive", (Object)this.resolveProperty(this.namedCacheServerProperty(beanName, "message-time-to-live"), this.resolveProperty(this.cacheServerProperty("message-time-to-live"), (Integer)enableCacheServerAttributes.get("messageTimeToLive"))));
        builder.addPropertyValue("port", (Object)this.resolveProperty(this.namedCacheServerProperty(beanName, "port"), this.resolveProperty(this.cacheServerProperty("port"), (Integer)enableCacheServerAttributes.get("port"))));
        builder.addPropertyValue("socketBufferSize", (Object)this.resolveProperty(this.namedCacheServerProperty(beanName, "socket-buffer-size"), this.resolveProperty(this.cacheServerProperty("socket-buffer-size"), (Integer)enableCacheServerAttributes.get("socketBufferSize"))));
        builder.addPropertyValue("subscriptionCapacity", (Object)this.resolveProperty(this.namedCacheServerProperty(beanName, "subscription-capacity"), this.resolveProperty(this.cacheServerProperty("subscription-capacity"), (Integer)enableCacheServerAttributes.get("subscriptionCapacity"))));
        builder.addPropertyValue("subscriptionDiskStore", (Object)this.resolveProperty(this.namedCacheServerProperty(beanName, "subscription-disk-store-name"), this.resolveProperty(this.cacheServerProperty("subscription-disk-store-name"), (String)enableCacheServerAttributes.get("subscriptionDiskStoreName"))));
        builder.addPropertyValue("subscriptionEvictionPolicy", (Object)this.resolveProperty(this.namedCacheServerProperty(beanName, "subscription-eviction-policy"), SubscriptionEvictionPolicy.class, this.resolveProperty(this.cacheServerProperty("subscription-eviction-policy"), SubscriptionEvictionPolicy.class, (SubscriptionEvictionPolicy)((Object)enableCacheServerAttributes.get("subscriptionEvictionPolicy")))));
        builder.addPropertyValue("tcpNoDelay", (Object)this.resolveProperty(this.namedCacheServerProperty(beanName, "tcp-no-delay"), this.resolveProperty(this.cacheServerProperty("tcp-no-delay"), (Boolean)enableCacheServerAttributes.get("tcpNoDelay"))));
    }

    private List<CacheServerConfigurer> resolveCacheServerConfigurers() {
        return Optional.ofNullable(this.cacheServerConfigurers).filter(cacheServerConfigurers -> !cacheServerConfigurers.isEmpty()).orElseGet(() -> Optional.of(this.getBeanFactory()).filter(beanFactory -> beanFactory instanceof ListableBeanFactory).map(beanFactory -> {
            Map beansOfType = ((ListableBeanFactory)beanFactory).getBeansOfType(CacheServerConfigurer.class, true, true);
            return CollectionUtils.nullSafeMap(beansOfType).values().stream().collect(Collectors.toList());
        }).orElseGet(Collections::emptyList));
    }

    protected String registerCacheServerFactoryBeanDefinition(AbstractBeanDefinition beanDefinition, String beanName, BeanDefinitionRegistry registry) {
        if (StringUtils.hasText((String)beanName)) {
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)this.newBeanDefinitionHolder((BeanDefinition)beanDefinition, beanName), (BeanDefinitionRegistry)registry);
            return beanName;
        }
        return BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)beanDefinition, (BeanDefinitionRegistry)registry);
    }

    protected BeanDefinitionHolder newBeanDefinitionHolder(BeanDefinition beanDefinition, String beanName) {
        return new BeanDefinitionHolder(beanDefinition, beanName);
    }

    protected Class getAnnotationType() {
        return EnableCacheServer.class;
    }
}

