/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.geode.cache.client.ClientRegionShortcut;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AspectJTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.RegexPatternTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.gemfire.FixedPartitionAttributesFactoryBean;
import org.springframework.data.gemfire.LocalRegionFactoryBean;
import org.springframework.data.gemfire.PartitionAttributesFactoryBean;
import org.springframework.data.gemfire.PartitionedRegionFactoryBean;
import org.springframework.data.gemfire.RegionAttributesFactoryBean;
import org.springframework.data.gemfire.RegionLookupFactoryBean;
import org.springframework.data.gemfire.ReplicatedRegionFactoryBean;
import org.springframework.data.gemfire.ScopeType;
import org.springframework.data.gemfire.client.ClientRegionFactoryBean;
import org.springframework.data.gemfire.config.annotation.EnableEntityDefinedRegions;
import org.springframework.data.gemfire.config.annotation.RegionConfigurer;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.data.gemfire.config.annotation.support.GemFireCacheTypeAwareRegionFactoryBean;
import org.springframework.data.gemfire.config.annotation.support.GemFireComponentClassTypeScanner;
import org.springframework.data.gemfire.mapping.GemfireMappingContext;
import org.springframework.data.gemfire.mapping.GemfirePersistentEntity;
import org.springframework.data.gemfire.mapping.GemfirePersistentProperty;
import org.springframework.data.gemfire.mapping.annotation.ClientRegion;
import org.springframework.data.gemfire.mapping.annotation.LocalRegion;
import org.springframework.data.gemfire.mapping.annotation.PartitionRegion;
import org.springframework.data.gemfire.mapping.annotation.Region;
import org.springframework.data.gemfire.mapping.annotation.ReplicateRegion;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.data.gemfire.util.SpringUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class EntityDefinedRegionsConfiguration
extends AbstractAnnotationConfigSupport
implements ImportBeanDefinitionRegistrar {
    protected static final Class<? extends RegionLookupFactoryBean> DEFAULT_REGION_FACTORY_BEAN_CLASS = GemFireCacheTypeAwareRegionFactoryBean.class;
    protected static final Map<Class<? extends Annotation>, Class<? extends RegionLookupFactoryBean>> regionAnnotationToRegionFactoryBeanClass = new HashMap<Class<? extends Annotation>, Class<? extends RegionLookupFactoryBean>>();
    private GemfireMappingContext mappingContext;
    @Autowired(required=false)
    private List<RegionConfigurer> regionConfigurers = Collections.emptyList();

    @Override
    protected Class<? extends Annotation> getAnnotationType() {
        return EnableEntityDefinedRegions.class;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        if (this.isAnnotationPresent(importingClassMetadata)) {
            AnnotationAttributes enableEntityDefinedRegionsAttributes = this.getAnnotationAttributes(importingClassMetadata);
            String poolName = enableEntityDefinedRegionsAttributes.getString("poolName");
            boolean strict = enableEntityDefinedRegionsAttributes.getBoolean("strict");
            this.newGemFireComponentClassTypeScanner(importingClassMetadata, enableEntityDefinedRegionsAttributes).scan().forEach(persistentEntityClass -> {
                GemfirePersistentEntity<?> persistentEntity = this.getPersistentEntity((Class<?>)persistentEntityClass);
                this.registerRegionBeanDefinition(persistentEntity, poolName, strict, registry);
                this.postProcess(importingClassMetadata, registry, persistentEntity);
            });
        }
    }

    protected GemFireComponentClassTypeScanner newGemFireComponentClassTypeScanner(AnnotationMetadata importingClassMetadata, AnnotationAttributes enableEntityDefinedRegionsAttributes) {
        Set<String> resolvedBasePackages = this.resolveBasePackages(importingClassMetadata, enableEntityDefinedRegionsAttributes);
        return GemFireComponentClassTypeScanner.from(resolvedBasePackages).with(this.resolveBeanClassLoader()).withExcludes(this.resolveExcludes(enableEntityDefinedRegionsAttributes)).withIncludes(this.resolveIncludes(enableEntityDefinedRegionsAttributes)).withIncludes(this.resolveRegionAnnotatedPersistentEntityTypeFilters());
    }

    protected Set<String> resolveBasePackages(AnnotationMetadata importingClassMetaData, AnnotationAttributes enableEntityDefinedRegionAttributes) {
        HashSet<String> resolvedBasePackages = new HashSet<String>();
        Collections.addAll(resolvedBasePackages, ArrayUtils.nullSafeArray(ArrayUtils.defaultIfEmpty(enableEntityDefinedRegionAttributes.getStringArray("basePackages"), enableEntityDefinedRegionAttributes.getStringArray("value")), String.class));
        Arrays.stream(ArrayUtils.nullSafeArray(enableEntityDefinedRegionAttributes.getClassArray("basePackageClasses"), Class.class)).forEach(type -> resolvedBasePackages.add(type.getPackage().getName()));
        if (resolvedBasePackages.isEmpty()) {
            resolvedBasePackages.add(ClassUtils.getPackageName((String)importingClassMetaData.getClassName()));
        }
        return resolvedBasePackages;
    }

    protected Iterable<TypeFilter> resolveExcludes(AnnotationAttributes enableEntityDefinedRegionsAttributes) {
        return this.parseFilters(enableEntityDefinedRegionsAttributes.getAnnotationArray("excludeFilters"));
    }

    protected Iterable<TypeFilter> resolveIncludes(AnnotationAttributes enableEntityDefinedRegionsAttributes) {
        return this.parseFilters(enableEntityDefinedRegionsAttributes.getAnnotationArray("includeFilters"));
    }

    protected Iterable<TypeFilter> resolveRegionAnnotatedPersistentEntityTypeFilters() {
        return Region.REGION_ANNOTATION_TYPES.stream().map(AnnotationTypeFilter::new).collect(Collectors.toSet());
    }

    private Iterable<TypeFilter> parseFilters(AnnotationAttributes[] componentScanFilterAttributes) {
        return Arrays.stream(ArrayUtils.nullSafeArray(componentScanFilterAttributes, AnnotationAttributes.class)).flatMap(filterAttributes -> this.typeFiltersFor((AnnotationAttributes)filterAttributes).stream()).collect(Collectors.toSet());
    }

    private Set<TypeFilter> typeFiltersFor(AnnotationAttributes filterAttributes) {
        HashSet<TypeFilter> typeFilters = new HashSet<TypeFilter>();
        FilterType filterType = (FilterType)filterAttributes.getEnum("type");
        Arrays.stream(ArrayUtils.nullSafeArray(filterAttributes.getClassArray("value"), Class.class)).forEach(filterClass -> {
            switch (filterType) {
                case ANNOTATION: {
                    Assert.isAssignable(Annotation.class, (Class)filterClass, (String)String.format("@ComponentScan.Filter class [%s] must be an Annotation", filterClass));
                    typeFilters.add((TypeFilter)new AnnotationTypeFilter(filterClass));
                    break;
                }
                case ASSIGNABLE_TYPE: {
                    typeFilters.add((TypeFilter)new AssignableTypeFilter(filterClass));
                    break;
                }
                case CUSTOM: {
                    Assert.isAssignable(TypeFilter.class, (Class)filterClass, (String)String.format("@ComponentScan.Filter class [%s] must be a TypeFilter", filterClass));
                    typeFilters.add((TypeFilter)BeanUtils.instantiateClass((Class)filterClass, TypeFilter.class));
                    break;
                }
                default: {
                    throw RuntimeExceptionFactory.newIllegalArgumentException("Illegal filter type [%s] when 'value' or 'classes' are specified", filterType);
                }
            }
            block9: for (String pattern : this.nullSafeGetPatterns(filterAttributes)) {
                switch (filterType) {
                    case ASPECTJ: {
                        typeFilters.add((TypeFilter)new AspectJTypeFilter(pattern, this.resolveBeanClassLoader()));
                        continue block9;
                    }
                    case REGEX: {
                        typeFilters.add((TypeFilter)new RegexPatternTypeFilter(Pattern.compile(pattern)));
                        continue block9;
                    }
                    default: {
                        throw RuntimeExceptionFactory.newIllegalArgumentException("Illegal filter type [%s] when 'patterns' are specified", filterType);
                    }
                }
            }
        });
        return typeFilters;
    }

    private String[] nullSafeGetPatterns(AnnotationAttributes filterAttributes) {
        return SpringUtils.safeGetValue(() -> ArrayUtils.nullSafeArray(filterAttributes.getStringArray("pattern"), String.class), () -> new String[0]);
    }

    protected GemfirePersistentEntity<?> getPersistentEntity(Class<?> persistentEntityType) {
        return (GemfirePersistentEntity)this.resolveMappingContext().getPersistentEntity(persistentEntityType);
    }

    protected GemfireMappingContext resolveMappingContext() {
        return Optional.ofNullable(this.mappingContext).orElseGet(() -> {
            try {
                this.mappingContext = (GemfireMappingContext)((Object)((Object)this.getBeanFactory().getBean(GemfireMappingContext.class)));
            }
            catch (Throwable ignore) {
                this.mappingContext = new GemfireMappingContext();
            }
            return this.mappingContext;
        });
    }

    protected void registerRegionBeanDefinition(GemfirePersistentEntity persistentEntity, String poolName, boolean strict, BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder regionFactoryBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition(this.resolveRegionFactoryBeanClass(persistentEntity)).addPropertyReference("cache", "gemfireCache").addPropertyValue("regionConfigurers", this.resolveRegionConfigurers()).addPropertyValue("close", (Object)false);
        this.setRegionAttributes(persistentEntity, regionFactoryBeanBuilder, poolName, strict);
        registry.registerBeanDefinition(persistentEntity.getRegionName(), (BeanDefinition)regionFactoryBeanBuilder.getBeanDefinition());
    }

    protected Class<? extends RegionLookupFactoryBean> resolveRegionFactoryBeanClass(GemfirePersistentEntity persistentEntity) {
        return Optional.ofNullable(regionAnnotationToRegionFactoryBeanClass.get(persistentEntity.getRegionAnnotationType())).orElse(DEFAULT_REGION_FACTORY_BEAN_CLASS);
    }

    protected List<RegionConfigurer> resolveRegionConfigurers() {
        return Optional.ofNullable(this.regionConfigurers).filter(regionConfigurers -> !regionConfigurers.isEmpty()).orElseGet(() -> Optional.of(this.getBeanFactory()).filter(beanFactory -> beanFactory instanceof ListableBeanFactory).map(beanFactory -> {
            Map beansOfType = ((ListableBeanFactory)beanFactory).getBeansOfType(RegionConfigurer.class, true, true);
            return CollectionUtils.nullSafeMap(beansOfType).values().stream().collect(Collectors.toList());
        }).orElseGet(Collections::emptyList));
    }

    protected BeanDefinitionBuilder setRegionAttributes(GemfirePersistentEntity persistentEntity, BeanDefinitionBuilder regionFactoryBeanBuilder, String poolName, boolean strict) {
        Optional.ofNullable(persistentEntity.getRegionAnnotation()).ifPresent(regionAnnotation -> {
            AnnotationAttributes regionAnnotationAttributes = this.getAnnotationAttributes((Annotation)regionAnnotation);
            if (strict) {
                regionFactoryBeanBuilder.addPropertyValue("keyConstraint", this.resolveIdType(persistentEntity));
                regionFactoryBeanBuilder.addPropertyValue("valueConstraint", this.resolveDomainType(persistentEntity));
            }
            if (regionAnnotationAttributes.containsKey((Object)"diskStoreName")) {
                String diskStoreName = regionAnnotationAttributes.getString("diskStoreName");
                this.setPropertyValueIfNotDefault(regionFactoryBeanBuilder, "diskStoreName", diskStoreName, "");
                if (StringUtils.hasText((String)diskStoreName)) {
                    regionFactoryBeanBuilder.addDependsOn(diskStoreName);
                }
            }
            if (regionAnnotationAttributes.containsKey((Object)"ignoreIfExists")) {
                regionFactoryBeanBuilder.addPropertyValue("lookupEnabled", (Object)regionAnnotationAttributes.getBoolean("ignoreIfExists"));
            }
            if (regionAnnotationAttributes.containsKey((Object)"persistent")) {
                this.setPropertyValueIfNotDefault(regionFactoryBeanBuilder, "persistent", regionAnnotationAttributes.getBoolean("persistent"), false);
            }
            BeanDefinitionBuilder regionAttributesFactoryBeanBuilder = this.resolveRegionAttributesFactoryBeanBuilder((Annotation)regionAnnotation, regionFactoryBeanBuilder);
            if (regionAnnotationAttributes.containsKey((Object)"diskSynchronous")) {
                this.setPropertyValueIfNotDefault(regionAttributesFactoryBeanBuilder, "diskSynchronous", regionAnnotationAttributes.getBoolean("diskSynchronous"), true);
            }
            if (regionAnnotationAttributes.containsKey((Object)"ignoreJta")) {
                this.setPropertyValueIfNotDefault(regionAttributesFactoryBeanBuilder, "ignoreJTA", regionAnnotationAttributes.getBoolean("ignoreJta"), false);
            }
            this.setClientRegionAttributes(regionAnnotationAttributes, poolName, regionFactoryBeanBuilder);
            this.setPartitionRegionAttributes(regionAnnotationAttributes, regionFactoryBeanBuilder, regionAttributesFactoryBeanBuilder);
            this.setReplicateRegionAttributes(regionAnnotationAttributes, regionFactoryBeanBuilder);
        });
        return regionFactoryBeanBuilder;
    }

    protected Class<?> resolveDomainType(GemfirePersistentEntity persistentEntity) {
        return persistentEntity.getType();
    }

    protected Class<?> resolveIdType(GemfirePersistentEntity persistentEntity) {
        return Optional.ofNullable(persistentEntity.getIdProperty()).map(idProperty -> ((GemfirePersistentProperty)((Object)idProperty)).getActualType()).orElse(Object.class);
    }

    protected BeanDefinitionBuilder resolveRegionAttributesFactoryBeanBuilder(Annotation regionAnnotation, BeanDefinitionBuilder regionFactoryBeanBuilder) {
        BeanDefinitionBuilder regionAttributesFactoryBeanBuilder = regionFactoryBeanBuilder;
        if (!ClientRegion.class.isAssignableFrom(regionAnnotation.annotationType())) {
            regionAttributesFactoryBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition(RegionAttributesFactoryBean.class);
            regionFactoryBeanBuilder.addPropertyValue("attributes", (Object)regionAttributesFactoryBeanBuilder.getBeanDefinition());
        }
        return regionAttributesFactoryBeanBuilder;
    }

    protected BeanDefinitionBuilder setClientRegionAttributes(AnnotationAttributes regionAnnotationAttributes, String poolName, BeanDefinitionBuilder regionFactoryBeanBuilder) {
        if (this.isPoolNameConfigured(regionAnnotationAttributes, poolName)) {
            this.setPropertyValueIfNotDefault(regionFactoryBeanBuilder, "poolName", regionAnnotationAttributes.getString("poolName"), null);
        }
        if (regionAnnotationAttributes.containsKey((Object)"shortcut")) {
            this.setPropertyValueIfNotDefault(regionFactoryBeanBuilder, "shortcut", regionAnnotationAttributes.getEnum("shortcut"), ClientRegionShortcut.PROXY);
        }
        return regionFactoryBeanBuilder;
    }

    private boolean isPoolNameConfigured(AnnotationAttributes regionAnnotationAttributes, String poolName) {
        return regionAnnotationAttributes.containsKey((Object)"poolName") || !"DEFAULT".equals(poolName);
    }

    private String resolvePoolName(AnnotationAttributes regionAnnotationAttributes, String poolName) {
        return SpringUtils.safeGetValue(() -> regionAnnotationAttributes.getString("poolName"), poolName);
    }

    protected BeanDefinitionBuilder setPartitionRegionAttributes(AnnotationAttributes regionAnnotationAttributes, BeanDefinitionBuilder regionFactoryBeanBuilder, BeanDefinitionBuilder regionAttributesFactoryBeanBuilder) {
        if (regionAnnotationAttributes.containsKey((Object)"redundantCopies")) {
            BeanDefinitionBuilder partitionAttributesFactoryBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition(PartitionAttributesFactoryBean.class);
            String collocatedWith = regionAnnotationAttributes.getString("collocatedWith");
            this.setPropertyValueIfNotDefault(partitionAttributesFactoryBeanBuilder, "colocatedWith", collocatedWith, "");
            if (StringUtils.hasText((String)collocatedWith)) {
                regionFactoryBeanBuilder.addDependsOn(collocatedWith);
            }
            this.setPropertyReferenceIfSet(partitionAttributesFactoryBeanBuilder, "partitionResolver", regionAnnotationAttributes.getString("partitionResolverName"));
            this.setPropertyValueIfNotDefault(partitionAttributesFactoryBeanBuilder, "redundantCopies", regionAnnotationAttributes.getNumber("redundantCopies"), 0);
            this.setFixedPartitionRegionAttributes(regionAnnotationAttributes, partitionAttributesFactoryBeanBuilder);
            regionAttributesFactoryBeanBuilder.addPropertyValue("partitionAttributes", (Object)partitionAttributesFactoryBeanBuilder.getBeanDefinition());
        }
        return regionAttributesFactoryBeanBuilder;
    }

    protected BeanDefinitionBuilder setFixedPartitionRegionAttributes(AnnotationAttributes regionAnnotationAttributes, BeanDefinitionBuilder partitionAttributesFactoryBeanBuilder) {
        Object[] fixedPartitions = ArrayUtils.nullSafeArray(regionAnnotationAttributes.getAnnotationArray("fixedPartitions", PartitionRegion.FixedPartition.class), PartitionRegion.FixedPartition.class);
        if (!ObjectUtils.isEmpty((Object[])fixedPartitions)) {
            ManagedList fixedPartitionAttributesFactoryBeans = new ManagedList(fixedPartitions.length);
            for (Object fixedPartition : fixedPartitions) {
                BeanDefinitionBuilder fixedPartitionAttributesFactoryBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition(FixedPartitionAttributesFactoryBean.class);
                fixedPartitionAttributesFactoryBeanBuilder.addPropertyValue("partitionName", (Object)fixedPartition.name());
                this.setPropertyValueIfNotDefault(fixedPartitionAttributesFactoryBeanBuilder, "primary", fixedPartition.primary(), false);
                this.setPropertyValueIfNotDefault(fixedPartitionAttributesFactoryBeanBuilder, "numBuckets", fixedPartition.numBuckets(), 1);
                fixedPartitionAttributesFactoryBeans.add((Object)fixedPartitionAttributesFactoryBeanBuilder.getBeanDefinition());
            }
            partitionAttributesFactoryBeanBuilder.addPropertyValue("fixedPartitionAttributes", (Object)fixedPartitionAttributesFactoryBeans);
        }
        return partitionAttributesFactoryBeanBuilder;
    }

    protected BeanDefinitionBuilder setReplicateRegionAttributes(AnnotationAttributes regionAnnotationAttributes, BeanDefinitionBuilder regionFactoryBeanBuilder) {
        if (regionAnnotationAttributes.containsKey((Object)"scope")) {
            this.setPropertyValueIfNotDefault(regionFactoryBeanBuilder, "scope", ((ScopeType)regionAnnotationAttributes.getEnum("scope")).getScope(), ScopeType.DISTRIBUTED_NO_ACK);
        }
        return regionFactoryBeanBuilder;
    }

    private <T> BeanDefinitionBuilder setPropertyReferenceIfSet(BeanDefinitionBuilder beanDefinitionBuilder, String propertyName, String beanName) {
        return StringUtils.hasText((String)beanName) ? beanDefinitionBuilder.addPropertyReference(propertyName, beanName) : beanDefinitionBuilder;
    }

    private <T> BeanDefinitionBuilder setPropertyValueIfNotDefault(BeanDefinitionBuilder beanDefinitionBuilder, String propertyName, T value, T defaultValue) {
        return value != null && !value.equals(defaultValue) ? beanDefinitionBuilder.addPropertyValue(propertyName, value) : beanDefinitionBuilder;
    }

    protected GemfirePersistentEntity<?> postProcess(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry, GemfirePersistentEntity<?> persistentEntity) {
        return persistentEntity;
    }

    static {
        regionAnnotationToRegionFactoryBeanClass.put(ClientRegion.class, ClientRegionFactoryBean.class);
        regionAnnotationToRegionFactoryBeanClass.put(LocalRegion.class, LocalRegionFactoryBean.class);
        regionAnnotationToRegionFactoryBeanClass.put(PartitionRegion.class, PartitionedRegionFactoryBean.class);
        regionAnnotationToRegionFactoryBeanClass.put(ReplicateRegion.class, ReplicatedRegionFactoryBean.class);
        regionAnnotationToRegionFactoryBeanClass.put(Region.class, DEFAULT_REGION_FACTORY_BEAN_CLASS);
    }
}

