/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation.support;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.EnvironmentAccessor;
import org.springframework.context.expression.MapAccessor;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeConverter;
import org.springframework.expression.spel.support.StandardTypeLocator;
import org.springframework.util.StringUtils;

public abstract class AbstractAnnotationConfigSupport
implements BeanClassLoaderAware,
BeanFactoryAware,
EnvironmentAware {
    protected static final String SPRING_DATA_GEMFIRE_PROPERTY_PREFIX = "spring.data.gemfire.";
    private BeanFactory beanFactory;
    private ClassLoader beanClassLoader;
    private Environment environment;
    private final EvaluationContext evaluationContext;
    private final Log log;

    protected static boolean hasValue(Object value) {
        return Optional.ofNullable(value).isPresent();
    }

    protected static boolean hasValue(Number value) {
        return Optional.ofNullable(value).filter(it -> it.doubleValue() != 0.0).isPresent();
    }

    protected static boolean hasValue(String value) {
        return StringUtils.hasText((String)value);
    }

    public AbstractAnnotationConfigSupport() {
        this(null);
    }

    public AbstractAnnotationConfigSupport(BeanFactory beanFactory) {
        this.evaluationContext = this.newEvaluationContext(beanFactory);
        this.log = this.newLog();
    }

    protected EvaluationContext newEvaluationContext(BeanFactory beanFactory) {
        StandardEvaluationContext evaluationContext = new StandardEvaluationContext();
        evaluationContext.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
        evaluationContext.addPropertyAccessor((PropertyAccessor)new EnvironmentAccessor());
        evaluationContext.addPropertyAccessor((PropertyAccessor)new MapAccessor());
        evaluationContext.setTypeLocator((TypeLocator)new StandardTypeLocator(this.getBeanClassLoader()));
        this.configureTypeConverter((EvaluationContext)evaluationContext, beanFactory);
        return evaluationContext;
    }

    private void configureTypeConverter(EvaluationContext evaluationContext, BeanFactory beanFactory) {
        Optional.ofNullable(evaluationContext).filter(evalContext -> evalContext instanceof StandardEvaluationContext).ifPresent(evalContext -> Optional.ofNullable(beanFactory).filter(it -> it instanceof ConfigurableBeanFactory).map(it -> ((ConfigurableBeanFactory)it).getConversionService()).ifPresent(conversionService -> ((StandardEvaluationContext)evalContext).setTypeConverter((TypeConverter)new StandardTypeConverter(conversionService))));
    }

    protected Log newLog() {
        return LogFactory.getLog(this.getClass());
    }

    protected boolean isAnnotationPresent(AnnotationMetadata importingClassMetadata) {
        return this.isAnnotationPresent(importingClassMetadata, this.getAnnotationTypeName());
    }

    protected boolean isAnnotationPresent(AnnotationMetadata importingClassMetadata, String annotationName) {
        return importingClassMetadata.hasAnnotation(annotationName);
    }

    protected AnnotationAttributes getAnnotationAttributes(Annotation annotation) {
        return AnnotationAttributes.fromMap((Map)AnnotationUtils.getAnnotationAttributes((Annotation)annotation));
    }

    protected AnnotationAttributes getAnnotationAttributes(AnnotationMetadata importingClassMetadata) {
        return this.getAnnotationAttributes(importingClassMetadata, this.getAnnotationTypeName());
    }

    protected AnnotationAttributes getAnnotationAttributes(AnnotationMetadata importingClassMetadata, String annotationName) {
        return AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(annotationName));
    }

    protected abstract Class<? extends Annotation> getAnnotationType();

    protected String getAnnotationTypeName() {
        return this.getAnnotationType().getName();
    }

    protected String getAnnotationTypeSimpleName() {
        return this.getAnnotationType().getSimpleName();
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    protected ClassLoader getBeanClassLoader() {
        return this.beanClassLoader;
    }

    protected ClassLoader resolveBeanClassLoader() {
        return Optional.ofNullable(this.getBeanClassLoader()).orElseGet(() -> Thread.currentThread().getContextClassLoader());
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        this.configureTypeConverter(this.getEvaluationContext(), beanFactory);
    }

    protected BeanFactory getBeanFactory() {
        return Optional.ofNullable(this.beanFactory).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException("BeanFactory is required", new Object[0]));
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    protected Environment getEnvironment() {
        return this.environment;
    }

    protected EvaluationContext getEvaluationContext() {
        return this.evaluationContext;
    }

    protected Log getLog() {
        return this.log;
    }

    protected void logDebug(String message, Object ... args) {
        this.logDebug(() -> String.format(message, args));
    }

    protected void logDebug(Supplier<String> message) {
        Optional.ofNullable(this.getLog()).filter(Log::isDebugEnabled).ifPresent(log -> log.debug(message.get()));
    }

    protected void logInfo(String message, Object ... args) {
        this.logInfo(() -> String.format(message, args));
    }

    protected void logInfo(Supplier<String> message) {
        Optional.ofNullable(this.getLog()).filter(Log::isInfoEnabled).ifPresent(log -> log.info(message.get()));
    }

    protected void logWarning(String message, Object ... args) {
        this.logWarning(() -> String.format(message, args));
    }

    protected void logWarning(Supplier<String> message) {
        Optional.ofNullable(this.getLog()).filter(Log::isWarnEnabled).ifPresent(log -> log.info(message.get()));
    }

    protected void logError(String message, Object ... args) {
        this.logError(() -> String.format(message, args));
    }

    protected void logError(Supplier<String> message) {
        Optional.ofNullable(this.getLog()).filter(Log::isWarnEnabled).ifPresent(log -> log.info(message.get()));
    }

    protected AbstractBeanDefinition register(AbstractBeanDefinition beanDefinition) {
        BeanFactory beanFactory = this.getBeanFactory();
        return beanFactory instanceof BeanDefinitionRegistry ? this.register(beanDefinition, (BeanDefinitionRegistry)beanFactory) : beanDefinition;
    }

    protected AbstractBeanDefinition register(AbstractBeanDefinition beanDefinition, BeanDefinitionRegistry registry) {
        Optional.ofNullable(registry).ifPresent(it -> BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)beanDefinition, (BeanDefinitionRegistry)it));
        return beanDefinition;
    }

    protected List<String> arrayOfPropertyNamesFor(String propertyNamePrefix) {
        return this.arrayOfPropertyNamesFor(propertyNamePrefix, null);
    }

    protected List<String> arrayOfPropertyNamesFor(String propertyNamePrefix, String propertyNameSuffix) {
        ArrayList<String> propertyNames = new ArrayList<String>();
        boolean found = true;
        for (int index = 0; found && index < Integer.MAX_VALUE; ++index) {
            String propertyName = this.asArrayProperty(propertyNamePrefix, index, propertyNameSuffix);
            found = this.getEnvironment().containsProperty(propertyName);
            if (!found) continue;
            propertyNames.add(propertyName);
        }
        return propertyNames;
    }

    protected String asArrayProperty(String propertyNamePrefix, int index, String propertyNameSuffix) {
        return String.format("%1$s[%2$d]%3$s", propertyNamePrefix, index, Optional.ofNullable(propertyNamePrefix).filter(StringUtils::hasText).map("."::concat).orElse(""));
    }

    protected String cacheProperty(String propertyNameSuffix) {
        return String.format("%1$s%2$s", this.propertyName("cache."), propertyNameSuffix);
    }

    protected String cacheClientProperty(String propertyNameSuffix) {
        return String.format("%1$s%2$s", this.propertyName("cache.client."), propertyNameSuffix);
    }

    protected String cachePeerProperty(String propertyNameSuffix) {
        return String.format("%1$s%2$s", this.propertyName("cache.peer."), propertyNameSuffix);
    }

    protected String cacheServerProperty(String propertyNameSuffix) {
        return String.format("%1$s%2$s", this.propertyName("cache.server."), propertyNameSuffix);
    }

    protected String namedCacheServerProperty(String name, String propertyNameSuffix) {
        return String.format("%1$s%2$s.%3$s", this.propertyName("cache.server."), name, propertyNameSuffix);
    }

    protected String clusterProperty(String propertyNameSuffix) {
        return String.format("%1$s%2$s", this.propertyName("cluster."), propertyNameSuffix);
    }

    protected String diskStoreProperty(String propertyNameSuffix) {
        return String.format("%1$s%2$s", this.propertyName("disk.store."), propertyNameSuffix);
    }

    protected String namedDiskStoreProperty(String name, String propertyNameSuffix) {
        return String.format("%1$s%2$s.%3$s", this.propertyName("disk.store."), name, propertyNameSuffix);
    }

    protected String locatorProperty(String propertyNameSuffix) {
        return String.format("%1$s%2$s", this.propertyName("locator."), propertyNameSuffix);
    }

    protected String loggingProperty(String propertyNameSuffix) {
        return String.format("%1$s%2$s", this.propertyName("logging."), propertyNameSuffix);
    }

    protected String managementProperty(String propertyNameSuffix) {
        return String.format("%1$s%2$s", this.propertyName("management."), propertyNameSuffix);
    }

    protected String managerProperty(String propertyNameSuffix) {
        return String.format("%1$s%2$s", this.propertyName("manager."), propertyNameSuffix);
    }

    protected String pdxProperty(String propertyNameSuffix) {
        return String.format("%1$s%2$s", this.propertyName("pdx."), propertyNameSuffix);
    }

    protected String poolProperty(String propertyNameSuffix) {
        return String.format("%1$s%2$s", this.propertyName("pool."), propertyNameSuffix);
    }

    protected String namedPoolProperty(String name, String propertyNameSuffix) {
        return String.format("%1$s%2$s.%3$s", this.propertyName("pool."), name, propertyNameSuffix);
    }

    protected String securityProperty(String propertyNameSuffix) {
        return String.format("%1$s%2$s", this.propertyName("security."), propertyNameSuffix);
    }

    protected String sslProperty(String propertyNameSuffix) {
        return String.format("%1$s%2$s", this.securityProperty("ssl."), propertyNameSuffix);
    }

    protected String componentSslProperty(String component, String propertyNameSuffix) {
        return String.format("%1$s%2$s.%3$s", this.securityProperty("ssl."), component, propertyNameSuffix);
    }

    protected String statsProperty(String propertyNameSuffix) {
        return String.format("%1$s%2$s", this.propertyName("stats."), propertyNameSuffix);
    }

    protected String serviceProperty(String propertyNameSuffix) {
        return String.format("%1$s%2$s", this.propertyName("service."), propertyNameSuffix);
    }

    protected String redisServiceProperty(String propertyNameSuffix) {
        return String.format("%1$s%2$s", this.serviceProperty("redis."), propertyNameSuffix);
    }

    protected String memcachedServiceProperty(String propertyNameSuffix) {
        return String.format("%1$s%2$s", this.serviceProperty("memcached."), propertyNameSuffix);
    }

    protected String httpServiceProperty(String propertyNameSuffix) {
        return String.format("%1$s%2$s", this.serviceProperty("http."), propertyNameSuffix);
    }

    protected String propertyName(String propertyNameSuffix) {
        return String.format("%1$s%2$s", SPRING_DATA_GEMFIRE_PROPERTY_PREFIX, propertyNameSuffix);
    }

    protected <T> T requireProperty(String propertyName, Class<T> type) {
        return (T)Optional.of(propertyName).map(it -> this.resolveProperty(propertyName, type, null)).filter(Objects::nonNull).filter(value -> !(value instanceof String) || StringUtils.hasText((String)((String)value))).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException("Property [%s] is required", propertyName));
    }

    protected Boolean resolveProperty(String propertyName, Boolean defaultValue) {
        return this.resolveProperty(propertyName, Boolean.class, defaultValue);
    }

    protected Double resolveProperty(String propertyName, Double defaultValue) {
        return this.resolveProperty(propertyName, Double.class, defaultValue);
    }

    protected Float resolveProperty(String propertyName, Float defaultValue) {
        return this.resolveProperty(propertyName, Float.class, defaultValue);
    }

    protected Integer resolveProperty(String propertyName, Integer defaultValue) {
        return this.resolveProperty(propertyName, Integer.class, defaultValue);
    }

    protected Long resolveProperty(String propertyName, Long defaultValue) {
        return this.resolveProperty(propertyName, Long.class, defaultValue);
    }

    protected String resolveProperty(String propertyName, String defaultValue) {
        return this.resolveProperty(propertyName, String.class, defaultValue);
    }

    protected <T> T resolveProperty(String propertyName, Class<T> targetType) {
        return this.resolveProperty(propertyName, targetType, null);
    }

    protected <T> T resolveProperty(String propertyName, Class<T> targetType, T defaultValue) {
        return (T)Optional.ofNullable(this.getEnvironment()).filter(environment -> environment.containsProperty(propertyName)).map(environment -> environment.getProperty(environment.resolveRequiredPlaceholders(propertyName), targetType, defaultValue)).orElse(defaultValue);
    }
}

