/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.schema.support;

import java.util.Optional;
import java.util.Set;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionShortcut;
import org.springframework.data.gemfire.config.schema.SchemaObjectDefiner;
import org.springframework.data.gemfire.config.schema.SchemaObjectType;
import org.springframework.data.gemfire.config.schema.definitions.RegionDefinition;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.RegionUtils;

public class RegionDefiner
implements SchemaObjectDefiner {
    private final RegionShortcut regionShortcut;

    public RegionDefiner() {
        this(RegionDefinition.DEFAULT_REGION_SHORTCUT);
    }

    public RegionDefiner(RegionShortcut regionShortcut) {
        this.regionShortcut = regionShortcut;
    }

    protected RegionShortcut getRegionShortcut() {
        return Optional.ofNullable(this.regionShortcut).orElse(RegionDefinition.DEFAULT_REGION_SHORTCUT);
    }

    @Override
    public Set<SchemaObjectType> getSchemaObjectTypes() {
        return CollectionUtils.asSet(SchemaObjectType.REGION);
    }

    public Optional<RegionDefinition> define(Object schemaObject) {
        return Optional.ofNullable(schemaObject).filter(this::canDefine).map(it -> (Region)it).filter(RegionUtils::isClient).map(it -> RegionDefinition.from(it).having(this.getRegionShortcut()));
    }
}

