/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.support;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.data.gemfire.client.ClientRegionFactoryBean;
import org.springframework.data.gemfire.client.PoolFactoryBean;
import org.springframework.data.gemfire.util.SpringUtils;
import org.springframework.util.StringUtils;

public class ClientRegionPoolBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    protected static final String POOL_NAME_PROPERTY = "poolName";

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        HashSet clientRegionBeanNames = new HashSet();
        HashSet poolBeanNames = new HashSet();
        Arrays.stream(beanFactory.getBeanDefinitionNames()).forEach(beanName -> {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
            if (this.isClientRegionBean(beanDefinition)) {
                clientRegionBeanNames.add(beanName);
            } else if (this.isPoolBean(beanDefinition)) {
                poolBeanNames.add(beanName);
            }
        });
        clientRegionBeanNames.forEach(clientRegionBeanName -> {
            BeanDefinition clientRegionBean = beanFactory.getBeanDefinition(clientRegionBeanName);
            String poolName = this.getPoolName(clientRegionBean);
            if (poolBeanNames.contains(poolName)) {
                SpringUtils.addDependsOn(clientRegionBean, poolName);
            }
        });
    }

    boolean isBeanDefinitionOfType(BeanDefinition beanDefinition, Class<?> type) {
        return Optional.of(beanDefinition).map(it -> beanDefinition.getBeanClassName()).filter(StringUtils::hasText).map(beanClassName -> type.getName().equals(beanClassName)).orElseGet(() -> Optional.ofNullable(beanDefinition.getFactoryMethodName()).filter(StringUtils::hasText).filter(it -> beanDefinition instanceof AnnotatedBeanDefinition).map(it -> ((AnnotatedBeanDefinition)beanDefinition).getFactoryMethodMetadata()).map(methodMetadata -> type.getName().equals(methodMetadata.getReturnTypeName())).orElse(false));
    }

    boolean isClientRegionBean(BeanDefinition beanDefinition) {
        return this.isBeanDefinitionOfType(beanDefinition, ClientRegionFactoryBean.class);
    }

    boolean isPoolBean(BeanDefinition beanDefinition) {
        return this.isBeanDefinitionOfType(beanDefinition, PoolFactoryBean.class);
    }

    String getPoolName(BeanDefinition clientRegionBean) {
        PropertyValue poolNameProperty = clientRegionBean.getPropertyValues().getPropertyValue(POOL_NAME_PROPERTY);
        return poolNameProperty != null ? String.valueOf(poolNameProperty.getValue()) : null;
    }
}

