/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import org.apiguardian.api.API;
import org.springframework.data.neo4j.core.DatabaseSelection;
import org.springframework.data.neo4j.core.DefaultDatabaseSelectionProvider;
import org.springframework.util.Assert;

@API(status=API.Status.STABLE, since="6.0")
@FunctionalInterface
public interface DatabaseSelectionProvider {
    public DatabaseSelection getDatabaseSelection();

    public static DatabaseSelectionProvider createStaticDatabaseSelectionProvider(String databaseName) {
        Assert.notNull((Object)databaseName, (String)"The database name must not be null");
        Assert.hasText((String)databaseName, (String)"The database name must not be empty");
        return () -> DatabaseSelection.byName(databaseName);
    }

    public static DatabaseSelectionProvider getDefaultSelectionProvider() {
        return DefaultDatabaseSelectionProvider.INSTANCE;
    }
}

