/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.client.LinkDiscoverer;
import org.springframework.hateoas.client.TraversonDefaults;
import org.springframework.hateoas.mediatype.hal.HalJacksonModule;
import org.springframework.hateoas.mediatype.hal.HalLinkDiscoverer;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.JacksonJsonHttpMessageConverter;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.json.JsonMapper;

class HalTraversonDefaults
implements TraversonDefaults {
    private static final List<MediaType> HAL_FLAVORS = List.of(MediaTypes.HAL_JSON, MediaTypes.VND_HAL_JSON, MediaTypes.HAL_FORMS_JSON);

    HalTraversonDefaults() {
    }

    @Override
    public List<HttpMessageConverter<?>> getHttpMessageConverters(Collection<MediaType> mediaTypes) {
        ArrayList converters = new ArrayList();
        converters.add((HttpMessageConverter<?>)new StringHttpMessageConverter(StandardCharsets.UTF_8));
        List<MediaType> halFlavors = mediaTypes.stream().filter(HAL_FLAVORS::contains).collect(Collectors.toList());
        if (!halFlavors.isEmpty()) {
            converters.add(HalTraversonDefaults.getHalConverter(halFlavors));
        }
        return converters;
    }

    @Override
    public List<LinkDiscoverer> getLinkDiscoverers(Collection<MediaType> mediaTypes) {
        return mediaTypes.stream().anyMatch(it -> HAL_FLAVORS.stream().anyMatch(arg_0 -> ((MediaType)it).isCompatibleWith(arg_0))) ? List.of(new HalLinkDiscoverer()) : Collections.emptyList();
    }

    private static HttpMessageConverter<?> getHalConverter(List<MediaType> halFlavours) {
        JsonMapper mapper = ((JsonMapper.Builder)JsonMapper.builder().addModule((JacksonModule)new HalJacksonModule())).build();
        JacksonJsonHttpMessageConverter converter = new JacksonJsonHttpMessageConverter(mapper);
        converter.setSupportedMediaTypes(halFlavours);
        return converter;
    }
}

