/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ftp.session;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.util.Assert;

class FtpSession
implements Session {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final FTPClient client;

    public FtpSession(FTPClient client) {
        Assert.notNull((Object)client, (String)"client must not be null");
        this.client = client;
    }

    public boolean remove(String path) throws IOException {
        Assert.hasText((String)path, (String)"path must not be null");
        boolean completed = this.client.deleteFile(path);
        if (!completed) {
            throw new IOException("Failed to delete '" + path + "'. Server replied with: " + this.client.getReplyString());
        }
        return completed;
    }

    public FTPFile[] list(String path) throws IOException {
        Assert.hasText((String)path, (String)"path must not be null");
        return this.client.listFiles(path);
    }

    public void read(String path, OutputStream fos) throws IOException {
        Assert.hasText((String)path, (String)"path must not be null");
        Assert.notNull((Object)fos, (String)"outputStream must not be null");
        boolean completed = this.client.retrieveFile(path, fos);
        if (!completed) {
            throw new IOException("Failed to copy '" + path + "'. Server replied with: " + this.client.getReplyString());
        }
        this.logger.info((Object)("File have been successfully transfered to: " + path));
    }

    public void write(InputStream inputStream, String path) throws IOException {
        Assert.notNull((Object)inputStream, (String)"inputStream must not be null");
        Assert.hasText((String)path, (String)"path must not be null");
        boolean completed = this.client.storeFile(path, inputStream);
        if (!completed) {
            throw new IOException("Failed to write to '" + path + "'. Server replied with: " + this.client.getReplyString());
        }
        this.logger.info((Object)("File have been successfully transfered to: " + path));
    }

    public void close() {
        block2: {
            try {
                this.client.disconnect();
            }
            catch (Exception e) {
                if (!this.logger.isWarnEnabled()) break block2;
                this.logger.warn((Object)"failed to disconnect FTPClient", (Throwable)e);
            }
        }
    }

    public boolean isOpen() {
        try {
            this.client.noop();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void rename(String pathFrom, String pathTo) throws IOException {
        this.client.deleteFile(pathTo);
        boolean completed = this.client.rename(pathFrom, pathTo);
        if (!completed) {
            throw new IOException("Failed to rename '" + pathFrom + "' to " + pathTo + "'. Server replied with: " + this.client.getReplyString());
        }
        this.logger.info((Object)("File have been successfully renamed from: " + pathFrom + " to " + pathTo));
    }
}

