/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.core;

import java.util.Stack;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanNameTrackingDefaultListableBeanFactory
extends DefaultListableBeanFactory {
    private static ThreadLocal<Stack<String>> namesHolder = new ThreadLocal<Stack<String>>(){

        @Override
        protected Stack<String> initialValue() {
            return new Stack<String>();
        }
    };

    public static Stack<String> names() {
        return namesHolder.get();
    }

    public BeanNameTrackingDefaultListableBeanFactory(ConfigurableListableBeanFactory parent) {
        super((BeanFactory)parent);
        this.copyConfigurationFrom((ConfigurableBeanFactory)parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getBean(String name) throws BeansException {
        this.recordRequestForBeanName(name);
        try {
            Object result;
            Object object = result = super.getBean(name);
            return object;
        }
        finally {
            this.pop();
        }
    }

    public void recordRequestForBeanName(String name) {
        BeanNameTrackingDefaultListableBeanFactory.names().push(name);
    }

    public String pop() {
        return BeanNameTrackingDefaultListableBeanFactory.names().pop();
    }

    public String lastRequestedBeanName() {
        return BeanNameTrackingDefaultListableBeanFactory.names().empty() ? null : BeanNameTrackingDefaultListableBeanFactory.names().peek();
    }
}

