/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.support;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.config.java.annotation.Configuration;
import org.springframework.config.java.context.TypeSafeBeanFactoryUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configuration
public class ConfigurationSupport
implements BeanFactoryAware,
ApplicationContextAware {
    private BeanFactory beanFactory;
    private AutowireCapableBeanFactory autowireCapableBeanFactory;
    private ApplicationContext applicationContext;

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        if (beanFactory instanceof AutowireCapableBeanFactory) {
            this.autowireCapableBeanFactory = (AutowireCapableBeanFactory)beanFactory;
        }
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setApplicationContext(ApplicationContext ac) {
        this.applicationContext = ac;
    }

    @Deprecated
    protected ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Object getBean(String beanName) {
        return this.beanFactory.getBean(beanName);
    }

    public <T> T getBean(Class<T> type) {
        return TypeSafeBeanFactoryUtils.getBean((ListableBeanFactory)this.beanFactory, type);
    }

    public <T> T getBean(Class<T> type, String beanName) {
        return TypeSafeBeanFactoryUtils.getBean((ListableBeanFactory)this.beanFactory, type, beanName);
    }

    protected Object getObject(FactoryBean fb) {
        try {
            return ((FactoryBean)this.getConfigured(fb)).getObject();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected Object getConfigured(Object o) {
        if (this.autowireCapableBeanFactory == null) {
            throw new UnsupportedOperationException("Cannot configure object - not running in an AutowireCapableBeanFactory");
        }
        this.autowireCapableBeanFactory.initializeBean(o, null);
        if (this.applicationContext != null) {
            if (o instanceof ResourceLoaderAware) {
                ((ResourceLoaderAware)o).setResourceLoader((ResourceLoader)this.applicationContext);
            }
            if (o instanceof ApplicationEventPublisherAware) {
                ((ApplicationEventPublisherAware)o).setApplicationEventPublisher((ApplicationEventPublisher)this.applicationContext);
            }
            if (o instanceof MessageSourceAware) {
                ((MessageSourceAware)o).setMessageSource((MessageSource)this.applicationContext);
            }
            if (o instanceof ApplicationContextAware) {
                ((ApplicationContextAware)o).setApplicationContext(this.applicationContext);
            }
        }
        return o;
    }
}

