/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.aptk.tools.matcher.impl;

import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.springframework.modulith.aptk.tools.ElementUtils;
import org.springframework.modulith.aptk.tools.matcher.CriteriaMatcher;

public class ByQualifiedNameRegexMatcher
implements CriteriaMatcher<Element, String> {
    @Override
    public boolean checkForMatchingCharacteristic(Element element, String toCheckFor) {
        if (element != null && toCheckFor != null) {
            String name = null;
            switch (element.getKind()) {
                case ENUM: 
                case INTERFACE: 
                case ANNOTATION_TYPE: 
                case CLASS: {
                    TypeElement typeElement = ElementUtils.CastElement.castToTypeElement(element);
                    name = typeElement.getQualifiedName().toString();
                    break;
                }
                case PACKAGE: {
                    PackageElement packageElement = (PackageElement)element;
                    name = packageElement.getQualifiedName().toString();
                    break;
                }
                default: {
                    name = element.getSimpleName().toString();
                }
            }
            Pattern pattern = Pattern.compile(toCheckFor);
            return pattern.matcher(name).matches();
        }
        return false;
    }

    @Override
    public String getStringRepresentationOfPassedCharacteristic(String toGetStringRepresentationFor) {
        return toGetStringRepresentationFor;
    }
}

