/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.modulith.events.DefaultEventExternalizationConfiguration;
import org.springframework.modulith.events.Externalized;
import org.springframework.modulith.events.RoutingTarget;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;

class AnnotationTargetLookup
implements Supplier<Optional<RoutingTarget.ParsedRoutingTarget>> {
    private static Map<Class<?>, AnnotationTargetLookup> LOOKUPS = new ConcurrentReferenceHashMap(25);
    private static final String JMOLECULES_EXTERNALIZED = "org.jmolecules.event.annotation.Externalized";
    private static final @Nullable Class<? extends Annotation> JMOLECULES_ANNOTATION = AnnotationTargetLookup.loadJMoleculesExternalizedIfPresent();
    private final Class<?> type;
    private final Supplier<Optional<RoutingTarget.ParsedRoutingTarget>> lookup;

    private AnnotationTargetLookup(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        this.type = type;
        this.lookup = this.firstMatching(this.fromJMoleculesExternalized(), this.fromModulithExternalized());
    }

    static AnnotationTargetLookup of(Class<?> type) {
        return LOOKUPS.computeIfAbsent(type, AnnotationTargetLookup::new);
    }

    static boolean hasExternalizedAnnotation(Object event) {
        Assert.notNull((Object)event, (String)"Event must not be null!");
        Class<?> type = event.getClass();
        return AnnotatedElementUtils.hasAnnotation(type, Externalized.class) || JMOLECULES_ANNOTATION != null && AnnotatedElementUtils.hasAnnotation(type, JMOLECULES_ANNOTATION);
    }

    @Override
    public Optional<RoutingTarget.ParsedRoutingTarget> get() {
        return this.lookup.get();
    }

    private Supplier<Optional<RoutingTarget.ParsedRoutingTarget>> fromModulithExternalized() {
        return () -> this.lookupTarget(Externalized.class, Externalized::target);
    }

    private Supplier<Optional<RoutingTarget.ParsedRoutingTarget>> fromJMoleculesExternalized() {
        return JMOLECULES_ANNOTATION == null ? () -> Optional.empty() : () -> this.lookupTarget(org.jmolecules.event.annotation.Externalized.class, org.jmolecules.event.annotation.Externalized::target, org.jmolecules.event.annotation.Externalized::value);
    }

    @SafeVarargs
    private Supplier<Optional<RoutingTarget.ParsedRoutingTarget>> firstMatching(Supplier<Optional<RoutingTarget.ParsedRoutingTarget>> ... functions) {
        return () -> Arrays.stream(functions).reduce(Optional.empty(), (current, function) -> current.or(() -> AnnotationTargetLookup.lambda$firstMatching$3((Supplier)function)), (l, r) -> r);
    }

    @SafeVarargs
    private <T extends Annotation> Optional<RoutingTarget.ParsedRoutingTarget> lookupTarget(Class<T> annotation, Function<T, String> ... extractors) {
        return Optional.ofNullable(AnnotatedElementUtils.findMergedAnnotation(this.type, annotation)).stream().flatMap(it -> Arrays.stream(extractors).map(function -> (String)function.apply(it)).filter(Predicate.not(String::isBlank))).findFirst().map(RoutingTarget::parse);
    }

    private static @Nullable Class<? extends Annotation> loadJMoleculesExternalizedIfPresent() {
        ClassLoader classLoader = DefaultEventExternalizationConfiguration.class.getClassLoader();
        if (ClassUtils.isPresent((String)JMOLECULES_EXTERNALIZED, (ClassLoader)classLoader)) {
            try {
                return ClassUtils.forName((String)JMOLECULES_EXTERNALIZED, (ClassLoader)classLoader);
            }
            catch (Exception o_O) {
                return null;
            }
        }
        return null;
    }

    private static /* synthetic */ Optional lambda$firstMatching$3(Supplier function) {
        return (Optional)function.get();
    }
}

