/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.modulith.events.AnnotationTargetLookup;
import org.springframework.modulith.events.DefaultEventExternalizationConfiguration;
import org.springframework.modulith.events.RoutingTarget;
import org.springframework.util.Assert;

public interface EventExternalizationConfiguration {
    public static Router defaults(Collection<String> packages) {
        Assert.notEmpty(packages, (String)"Packages must not be null or empty!");
        Function<Object, RoutingTarget> router = it -> Optional.of(it).flatMap(EventExternalizationConfiguration.byApplicationLocalName(packages)::apply).map((? super T target) -> EventExternalizationConfiguration.mergeWithExternalizedAnnotation(it, target)).orElseGet(() -> EventExternalizationConfiguration.byFullyQualifiedTypeName().apply(it));
        return DefaultEventExternalizationConfiguration.builder().selectByPackagesAndFilter(packages, AnnotationTargetLookup::hasExternalizedAnnotation).routeAll(router);
    }

    public static Router defaults(String ... packages) {
        return EventExternalizationConfiguration.defaults(List.of(packages));
    }

    public static Selector externalizing() {
        return new Selector();
    }

    public static EventExternalizationConfiguration disabled() {
        return EventExternalizationConfiguration.externalizing().select(__ -> false).build();
    }

    public static Predicate<Object> annotatedAsExternalized() {
        return event -> AnnotationTargetLookup.hasExternalizedAnnotation(event);
    }

    public static Function<Object, Optional<RoutingTarget>> byApplicationLocalName(Collection<String> packages) {
        Assert.notNull(packages, (String)"Application packages must not be null!");
        return EventExternalizationConfiguration.toEventType().andThen(type -> packages.stream().filter(it -> type.getPackageName().startsWith((String)it)).map((? super T it) -> type.getName().substring(it.length() + 1)).findFirst().map(RoutingTarget::forTarget).map(RoutingTarget.RoutingTargetBuilder::withoutKey));
    }

    public static Function<Object, Optional<RoutingTarget.ParsedRoutingTarget>> byExternalizedAnnotations() {
        return event -> AnnotationTargetLookup.of(event.getClass()).get();
    }

    public static Function<Object, RoutingTarget> byFullyQualifiedTypeName() {
        return EventExternalizationConfiguration.toEventType().andThen(Class::getName).andThen(it -> RoutingTarget.forTarget(it).withoutKey());
    }

    public boolean supports(Object var1);

    public Object map(Object var1);

    public RoutingTarget determineTarget(Object var1);

    public Map<String, Object> getHeadersFor(Object var1);

    public boolean serializeExternalization();

    private static RoutingTarget mergeWithExternalizedAnnotation(Object event, RoutingTarget target) {
        Assert.notNull((Object)event, (String)"Event must not be null!");
        Assert.notNull((Object)target, (String)"RoutingTarget must not be null!");
        return EventExternalizationConfiguration.byExternalizedAnnotations().apply(event).map((? super T it) -> it.withFallback(target)).orElse(target);
    }

    private static Function<Object, Class<?>> toEventType() {
        return event -> event.getClass();
    }

    public static class Selector {
        private static final Predicate<Object> DEFAULT_FILTER = it -> true;
        private final @Nullable Predicate<Object> predicate = DEFAULT_FILTER;

        Selector() {
        }

        public Router select(Predicate<Object> predicate) {
            return new Router(predicate);
        }

        public Router selectByPackage(String basePackage) {
            Assert.hasText((String)basePackage, (String)"Base package must not be null or empty!");
            return this.select(it -> it.getClass().getPackageName().startsWith(basePackage));
        }

        public Router selectByPackage(Class<?> type) {
            Assert.notNull(type, (String)"Type must not be null!");
            return this.selectByPackage(type.getPackageName());
        }

        public Router selectByPackagesAndFilter(Collection<String> basePackages, Predicate<Object> filter) {
            Assert.notEmpty(basePackages, (String)"Base packages must not be null or empty!");
            Assert.notNull(filter, (String)"Filter must not be null!");
            BiPredicate<Object, String> matcher = (event, reference) -> event.getClass().getPackageName().startsWith((String)reference);
            Predicate<Object> residesInPackage = it -> basePackages.stream().anyMatch(inner -> matcher.test(it, (String)inner));
            return this.select(residesInPackage.and(filter));
        }

        public Router selectByAnnotation(Class<? extends Annotation> type) {
            Assert.notNull(type, (String)"Annotation type must not be null!");
            return this.select(it -> AnnotatedElementUtils.hasAnnotation(it.getClass(), (Class)type));
        }

        public Router selectByType(Class<?> type) {
            Assert.notNull(type, (String)"Type must not be null!");
            return this.select(type::isInstance);
        }

        public Router selectByType(Predicate<Class<?>> predicate) {
            Assert.notNull(predicate, (String)"Predicate must not be null!");
            return this.select(it -> predicate.test(it.getClass()));
        }

        public <T extends Annotation> Router selectAndRoute(Class<T> annotationType, Function<T, String> router) {
            Assert.notNull(annotationType, (String)"Annotation type must not be null!");
            Assert.notNull(router, (String)"Router must not be null!");
            Function<Object, Annotation> extractor = it -> Selector.findAnnotation(it, annotationType);
            return this.selectByAnnotation(annotationType).routeAll(it -> extractor.andThen(router).andThen(RoutingTarget::parse).andThen(target -> target.withFallback(EventExternalizationConfiguration.byFullyQualifiedTypeName().apply(it))).apply(it));
        }

        public <T extends Annotation> Router selectAndRoute(Class<T> annotationType, BiFunction<Object, T, RoutingTarget> router) {
            Assert.notNull(annotationType, (String)"Annotation type must not be null!");
            Assert.notNull(router, (String)"Router must not be null!");
            return this.selectByAnnotation(annotationType).routeAll(it -> (RoutingTarget)router.apply(it, Selector.findAnnotation(it, annotationType)));
        }

        private static <T extends Annotation> T findAnnotation(Object event, Class<T> annotationType) {
            Class<?> type = event.getClass();
            Annotation result = AnnotatedElementUtils.findMergedAnnotation(type, annotationType);
            if (result == null) {
                throw new IllegalStateException("Couldn't find annotation %s on type %s!".formatted(annotationType, type));
            }
            return (T)result;
        }
    }

    public static class Router
    extends BaseConfiguration<Router> {
        private static final Function<Object, RoutingTarget> DEFAULT_ROUTER = it -> EventExternalizationConfiguration.mergeWithExternalizedAnnotation(it, EventExternalizationConfiguration.byFullyQualifiedTypeName().apply(it));
        private final Predicate<Object> filter;
        private final Function<Object, Object> mapper;
        private final Function<Object, RoutingTarget> router;
        private final Function<Object, Map<String, Object>> headers;

        Router(Predicate<Object> filter, Function<Object, Object> mapper, Function<Object, RoutingTarget> router, Function<Object, Map<String, Object>> headers, boolean serializeExternalization) {
            Assert.notNull(filter, (String)"Selector must not be null!");
            Assert.notNull(mapper, (String)"Mapper must not be null!");
            Assert.notNull(router, (String)"Router must not be null!");
            Assert.notNull(headers, (String)"Headers extractor must not be null!");
            this.filter = filter;
            this.mapper = mapper;
            this.router = router;
            this.headers = headers;
            this.serializeExternalization = serializeExternalization;
        }

        Router(Predicate<Object> filter) {
            this(filter, Function.identity(), DEFAULT_ROUTER, it -> Collections.emptyMap(), false);
        }

        public Router mapping(Function<Object, Object> mapper) {
            Assert.notNull(mapper, (String)"Mapper must not be null!");
            return new Router(this.filter, mapper, this.router, this.headers, this.serializeExternalization);
        }

        public <T> Router mapping(Class<T> type, Function<T, Object> mapper) {
            Assert.notNull(type, (String)"Type must not be null!");
            Assert.notNull(mapper, (String)"Mapper must not be null!");
            Function<Object, Object> combined = it -> Router.toOptional(type, it).map(mapper::apply).orElse(it);
            return new Router(this.filter, this.mapper.compose(combined), this.router, this.headers, this.serializeExternalization);
        }

        public Router headers(Function<Object, Map<String, Object>> extractor) {
            Assert.notNull(extractor, (String)"Headers extractor must not be null!");
            return new Router(this.filter, this.mapper, this.router, extractor, this.serializeExternalization);
        }

        public <T> Router headers(Class<T> type, Function<T, Map<String, Object>> extractor) {
            Assert.notNull(type, (String)"Type must not be null!");
            Assert.notNull(extractor, (String)"Headers extractor must not be null!");
            Function<Object, Map<String, Object>> combined = it -> Router.toOptional(type, it).map(extractor::apply).orElseGet(() -> this.headers.apply(it));
            return new Router(this.filter, this.mapper, this.router, combined, this.serializeExternalization);
        }

        public Router routeMapped() {
            return new Router(this.filter, this.mapper, this.router.compose(this.mapper), this.headers, this.serializeExternalization);
        }

        public Router routeAll(Function<Object, RoutingTarget> router) {
            Assert.notNull(router, (String)"Router must not be null!");
            return new Router(this.filter, this.mapper, router, this.headers, this.serializeExternalization);
        }

        public <T> Router route(Class<T> type, Function<T, RoutingTarget> router) {
            Assert.notNull(type, (String)"Type must not be null!");
            Assert.notNull(router, (String)"Router must not be null!");
            Function<Object, RoutingTarget> adapted = it -> Router.toOptional(type, it).map(router::apply).orElseGet(() -> this.router.apply(it));
            return new Router(this.filter, this.mapper, adapted, this.headers, this.serializeExternalization);
        }

        public <T> Router routeKey(Class<T> type, Function<T, String> extractor) {
            Assert.notNull(type, (String)"Type must not be null!");
            Assert.notNull(extractor, (String)"Extractor must not be null!");
            Function<Object, RoutingTarget> adapted = it -> Router.toOptional(type, it).map(t -> this.router.apply(t).withKey((String)extractor.apply(t))).orElseGet(() -> this.router.apply(it));
            return new Router(this.filter, this.mapper, adapted, this.headers, this.serializeExternalization);
        }

        public EventExternalizationConfiguration routeOptional(Function<Object, Optional<RoutingTarget>> router) {
            Assert.notNull(router, (String)"Router must not be null!");
            Function<Object, RoutingTarget> adapted = it -> ((Optional)router.apply(it)).orElseGet(() -> this.router.apply(it));
            return new Router(this.filter, this.mapper, adapted, this.headers, this.serializeExternalization).build();
        }

        public EventExternalizationConfiguration routeOptionalByType(Function<Class<?>, Optional<RoutingTarget>> router) {
            Assert.notNull(router, (String)"Router must not be null!");
            return this.routeOptional(it -> (Optional)router.apply(it.getClass()));
        }

        public Router routeAllByType(Function<Class<?>, RoutingTarget> router) {
            Assert.notNull(router, (String)"Router must not be null!");
            return new Router(this.filter, this.mapper, it -> (RoutingTarget)router.apply(it.getClass()), this.headers, this.serializeExternalization);
        }

        public EventExternalizationConfiguration build() {
            return new DefaultEventExternalizationConfiguration(this.filter, this.mapper, this.router, this.headers, this.serializeExternalization);
        }

        private static <T> Optional<T> toOptional(Class<T> type, Object source) {
            return Optional.of(source).filter(type::isInstance).map(type::cast);
        }
    }

    public static abstract class BaseConfiguration<T extends BaseConfiguration<T>> {
        protected boolean serializeExternalization;

        public T serializeExternalization(boolean serializeExternalization) {
            this.serializeExternalization = serializeExternalization;
            return (T)this;
        }
    }
}

