/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events;

import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import org.jspecify.annotations.Nullable;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.PayloadApplicationEvent;

public interface EventPublication {
    public UUID getIdentifier();

    public Object getEvent();

    default public ApplicationEvent getApplicationEvent() {
        Object event = this.getEvent();
        return PayloadApplicationEvent.class.isInstance(event) ? (ApplicationEvent)PayloadApplicationEvent.class.cast(event) : new PayloadApplicationEvent((Object)this, event);
    }

    public Instant getPublicationDate();

    public Optional<Instant> getCompletionDate();

    @Deprecated
    default public boolean isPublicationCompleted() {
        return this.isCompleted();
    }

    default public boolean isCompleted() {
        return this.getCompletionDate().isPresent();
    }

    public Status getStatus();

    public @Nullable Instant getLastResubmissionDate();

    public int getCompletionAttempts();

    default public int compareTo(EventPublication that) {
        return this.getPublicationDate().compareTo(that.getPublicationDate());
    }

    public static enum Status {
        PUBLISHED,
        PROCESSING,
        COMPLETED,
        FAILED,
        RESUBMITTED;

    }
}

