/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RoutingTarget {
    private static final String EXPRESSION_PREFIX = "#{";
    private final String target;
    private final @Nullable String key;

    private RoutingTarget(String target, @Nullable String key) {
        Assert.hasText((String)target, (String)"Target must not be null or empty!");
        this.target = target.trim();
        this.key = key == null ? null : key.trim();
    }

    static ParsedRoutingTarget parse(String source) {
        Assert.notNull((Object)source, (String)"Routing target source must not be null!");
        String[] parts = source.split("::", 2);
        String target = parts[0].isBlank() ? null : parts[0].trim();
        String key = parts.length == 2 ? parts[1].trim() : null;
        return new ParsedRoutingTarget(target, key);
    }

    public static RoutingTargetBuilder forTarget(String target) {
        return new RoutingTargetBuilder(target);
    }

    public String getTarget() {
        return this.target;
    }

    public @Nullable String getKey() {
        return this.key;
    }

    public boolean hasKeyExpression() {
        return this.key != null && this.key.startsWith(EXPRESSION_PREFIX);
    }

    public boolean hasExpression() {
        return this.hasKeyExpression() || this.target.startsWith(EXPRESSION_PREFIX);
    }

    RoutingTarget withTarget(String target) {
        return new RoutingTarget(target, this.key);
    }

    RoutingTarget withKey(@Nullable String key) {
        return new RoutingTarget(this.target, key);
    }

    RoutingTarget verify() {
        if (this.target.isBlank()) {
            throw new IllegalStateException("No target set! Make sure your externalization configuration always produces a target!");
        }
        return this;
    }

    public String toString() {
        return this.target + (String)(this.key == null ? "" : "::" + this.key);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RoutingTarget)) {
            return false;
        }
        RoutingTarget that = (RoutingTarget)obj;
        return Objects.equals(this.target, that.target) && Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.target, this.key);
    }

    static class ParsedRoutingTarget {
        private final @Nullable String target;
        private final @Nullable String key;

        ParsedRoutingTarget(@Nullable String target, @Nullable String key) {
            this.target = target;
            this.key = key;
        }

        public @Nullable String getTarget() {
            return this.target;
        }

        public @Nullable String getKey() {
            return this.key;
        }

        RoutingTarget toRoutingTarget() {
            if (!StringUtils.hasText((String)this.target)) {
                throw new IllegalStateException("Routing target must not be empty!");
            }
            return new RoutingTarget(this.target, this.key);
        }

        RoutingTarget withFallback(RoutingTarget fallback) {
            String newTarget = StringUtils.hasText((String)this.target) ? this.target : fallback.getTarget();
            return new RoutingTarget(newTarget, this.key != null ? this.key : fallback.getKey());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ParsedRoutingTarget)) {
                return false;
            }
            ParsedRoutingTarget that = (ParsedRoutingTarget)obj;
            return Objects.equals(this.target, that.target) && Objects.equals(this.key, that.key);
        }

        public int hashCode() {
            return Objects.hash(this.target, this.key);
        }

        public String toString() {
            return (this.target != null ? this.target : "").concat("::").concat(this.key != null ? this.key : "");
        }
    }

    public static class RoutingTargetBuilder {
        private final String target;

        private RoutingTargetBuilder(String target) {
            Assert.hasText((String)target, (String)"Target must not be null or empty!");
            this.target = target.trim();
        }

        public RoutingTarget andKey(String key) {
            return new RoutingTarget(this.target, key);
        }

        public RoutingTarget withoutKey() {
            return new RoutingTarget(this.target, null);
        }
    }
}

