/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.jackson;

import java.util.function.Supplier;
import org.springframework.modulith.events.core.EventSerializer;
import org.springframework.util.Assert;
import tools.jackson.databind.json.JsonMapper;

class JacksonEventSerializer
implements EventSerializer {
    private final Supplier<JsonMapper> mapper;

    public JacksonEventSerializer(Supplier<JsonMapper> mapper) {
        Assert.notNull(mapper, (String)"ObjectMapper must not be null!");
        this.mapper = mapper;
    }

    public Object serialize(Object event) {
        return this.mapper.get().writeValueAsString(event);
    }

    public <T> T deserialize(Object serialized, Class<T> type) {
        return (T)this.mapper.get().readerFor(type).readValue(serialized.toString());
    }
}

