/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.runtime.autoconfigure;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.modulith.core.ApplicationModuleIdentifier;
import org.springframework.modulith.runtime.jsonpath.DocumentContext;
import org.springframework.modulith.runtime.jsonpath.JsonPath;
import org.springframework.modulith.runtime.jsonpath.Predicate;
import org.springframework.util.Assert;

class ApplicationModuleMetadata {
    private static final ApplicationModuleMetadata NONE = new ApplicationModuleMetadata();
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationModuleMetadata.class);

    ApplicationModuleMetadata() {
    }

    public static ApplicationModuleMetadata of(Resource resource) {
        Assert.notNull((Object)resource, (String)"Resource must not be null!");
        if (!resource.exists()) {
            LOGGER.debug("Did not find application module metadata in {}.", (Object)resource.getDescription());
            return NONE;
        }
        return new ResourceBasedApplicationModuleMetadata(resource);
    }

    public boolean isPresent() {
        return false;
    }

    public List<ApplicationModuleIdentifier> getIdentifiers() {
        return Collections.emptyList();
    }

    public List<String> getInitializerTypeNames() {
        return Collections.emptyList();
    }

    private static class ResourceBasedApplicationModuleMetadata
    extends ApplicationModuleMetadata {
        private final DocumentContext document;

        public ResourceBasedApplicationModuleMetadata(Resource metadata) {
            String description = metadata.getDescription();
            Assert.isTrue((boolean)metadata.exists(), () -> "Resource %s does not exist!".formatted(description));
            LOGGER.debug("Using application module metadata located in {}.", (Object)description);
            try (InputStream inputStream = metadata.getInputStream();){
                this.document = JsonPath.parse(inputStream);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public List<ApplicationModuleIdentifier> getIdentifiers() {
            return ((Collection)this.document.read("$.keys()", new Predicate[0])).stream().map(ApplicationModuleIdentifier::of).toList();
        }

        @Override
        public List<String> getInitializerTypeNames() {
            return (List)this.document.read("$..initializers[*]", new Predicate[0]);
        }
    }
}

