/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.runtime.autoconfigure;

import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aot.generate.GeneratedFiles;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.modulith.core.util.ApplicationModulesExporter;
import org.springframework.modulith.runtime.ApplicationModulesRuntime;
import org.springframework.modulith.runtime.jsonpath.internal.function.PathFunctionFactory;

class ApplicationModulesFileGeneratingProcessor
implements BeanFactoryInitializationAotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationModulesFileGeneratingProcessor.class);

    ApplicationModulesFileGeneratingProcessor() {
    }

    public BeanFactoryInitializationAotContribution processAheadOfTime(ConfigurableListableBeanFactory beanFactory) {
        return (context, __) -> {
            ApplicationModulesRuntime runtime = (ApplicationModulesRuntime)beanFactory.getBean(ApplicationModulesRuntime.class);
            ApplicationModulesExporter exporter = new ApplicationModulesExporter(runtime.get());
            String location = "META-INF/spring-modulith/application-modules.json";
            LOGGER.info("Generating application modules information to {}", (Object)location);
            context.getRuntimeHints().resources().registerPattern(location);
            context.getGeneratedFiles().handleFile(GeneratedFiles.Kind.RESOURCE, location, it -> {
                ByteArrayResource resource = new ByteArrayResource(exporter.toJson().getBytes(StandardCharsets.UTF_8));
                if (it.exists()) {
                    it.override((InputStreamSource)resource);
                } else {
                    it.create((InputStreamSource)resource);
                }
            });
            ReflectionHints reflection = context.getRuntimeHints().reflection();
            ClassLoader classLoader = ApplicationModulesFileGeneratingProcessor.class.getClassLoader();
            PathFunctionFactory.FUNCTIONS.values().forEach(it -> {
                String typeName = it.getName().replace("org.springframework.modulith.runtime.jsonpath", "org.springframework.modulith.runtime.jsonpath");
                reflection.registerTypeIfPresent(classLoader, typeName, new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS});
            });
        };
    }
}

