/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.runtime.autoconfigure;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.modulith.ApplicationModuleInitializer;
import org.springframework.modulith.runtime.autoconfigure.ApplicationModuleInitializerInvoker;
import org.springframework.modulith.runtime.autoconfigure.ApplicationModuleMetadata;
import org.springframework.modulith.runtime.autoconfigure.LoggingApplicationModuleInitializerAdapter;
import org.springframework.util.Assert;

class PrecomputedApplicationModuleInitializerInvoker
implements ApplicationModuleInitializerInvoker {
    private final List<String> initializerTypeNames;

    public PrecomputedApplicationModuleInitializerInvoker(ApplicationModuleMetadata metadata) {
        Assert.isTrue((boolean)metadata.isPresent(), (String)"ApplicationModuleMetadata not present!");
        this.initializerTypeNames = metadata.getInitializerTypeNames();
    }

    @Override
    public void invokeInitializers(Stream<ApplicationModuleInitializer> initializers) {
        Map map = initializers.collect(Collectors.toMap(it -> it.getClass().getName(), Function.identity()));
        this.triggerInitialization(this.initializerTypeNames.stream().map(map::remove).map(Optional::ofNullable).flatMap(Optional::stream));
        this.triggerInitialization(map.values().stream());
    }

    private void triggerInitialization(Stream<ApplicationModuleInitializer> initializers) {
        initializers.map(LoggingApplicationModuleInitializerAdapter::of).forEach(ApplicationModuleInitializer::initialize);
    }
}

