/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.runtime.flyway;

import java.util.List;
import java.util.stream.Stream;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.flyway.autoconfigure.FlywayMigrationStrategy;
import org.springframework.modulith.core.ApplicationModuleIdentifier;
import org.springframework.modulith.core.ApplicationModuleIdentifiers;
import org.springframework.util.Assert;

public class SpringModulithFlywayMigrationStrategy
implements FlywayMigrationStrategy {
    private static final ApplicationModuleIdentifier ROOT = ApplicationModuleIdentifier.of((String)"__root");
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringModulithFlywayMigrationStrategy.class);
    private final ApplicationModuleIdentifiers identifiers;

    public SpringModulithFlywayMigrationStrategy(ApplicationModuleIdentifiers identifiers) {
        Assert.notNull((Object)identifiers, (String)"ApplicationModuleIdentifiers must not be null!");
        this.identifiers = identifiers;
    }

    public void migrate(Flyway flyway) {
        new SpringModulithFlywayCustomizer(flyway).augment(this.identifiers).forEach(Flyway::migrate);
    }

    static class SpringModulithFlywayCustomizer {
        private final Flyway flyway;

        SpringModulithFlywayCustomizer(Flyway flyway) {
            this.flyway = flyway;
        }

        Stream<Flyway> augment(ApplicationModuleIdentifiers identifiers) {
            Configuration configuration = this.flyway.getConfiguration();
            return Stream.concat(Stream.of(ROOT), identifiers.stream()).peek(it -> LOGGER.debug("Executing Flyway migrations for application module {}.", it)).map(it -> this.augmentWithApplicationModule((ApplicationModuleIdentifier)it, configuration));
        }

        private Flyway augmentWithApplicationModule(ApplicationModuleIdentifier identifier, Configuration configuration) {
            List<String> locations = Stream.of(configuration.getLocations()).map(Location::toString).map(it -> SpringModulithFlywayCustomizer.customizeLocation(it, identifier)).toList();
            return SpringModulithFlywayCustomizer.withNewLocation(configuration, locations, identifier);
        }

        private static String customizeLocation(String location, ApplicationModuleIdentifier identifier) {
            if (location.endsWith("*")) {
                return location;
            }
            String asPath = identifier.toString().replace('.', '/');
            return location + "/" + asPath;
        }

        private static Flyway withNewLocation(Configuration configuration, List<String> locations, ApplicationModuleIdentifier identifier) {
            String table = configuration.getTable();
            String customizedTable = identifier.equals((Object)ROOT) ? table : table + "_" + String.valueOf(identifier);
            return Flyway.configure().configuration(configuration).locations((String[])locations.toArray(String[]::new)).table(customizedTable).baselineVersion("0").baselineOnMigrate(true).load();
        }
    }
}

