/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.runtime.jsonpath.internal.function.numeric;

import java.util.List;
import org.springframework.modulith.runtime.jsonpath.JsonPathException;
import org.springframework.modulith.runtime.jsonpath.internal.EvaluationContext;
import org.springframework.modulith.runtime.jsonpath.internal.PathRef;
import org.springframework.modulith.runtime.jsonpath.internal.function.Parameter;
import org.springframework.modulith.runtime.jsonpath.internal.function.PathFunction;

public abstract class AbstractAggregation
implements PathFunction {
    protected abstract void next(Number var1);

    protected abstract Number getValue();

    @Override
    public Object invoke(String currentPath, PathRef parent, Object model, EvaluationContext ctx, List<Parameter> parameters) {
        int count = 0;
        if (ctx.configuration().jsonProvider().isArray(model)) {
            Iterable<?> objects = ctx.configuration().jsonProvider().toIterable(model);
            for (Object obj : objects) {
                if (!(obj instanceof Number)) continue;
                Number value = (Number)obj;
                ++count;
                this.next(value);
            }
        }
        if (parameters != null) {
            for (Number value : Parameter.toList(Number.class, ctx, parameters)) {
                ++count;
                this.next(value);
            }
        }
        if (count != 0) {
            return this.getValue();
        }
        throw new JsonPathException("Aggregation function attempted to calculate value using empty array");
    }
}

