/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.springframework.social.facebook.api.CoverPhoto;
import org.springframework.social.facebook.api.Engagement;
import org.springframework.social.facebook.api.Location;
import org.springframework.social.facebook.api.MailingAddress;
import org.springframework.social.facebook.api.Page;
import org.springframework.social.facebook.api.PageParking;
import org.springframework.social.facebook.api.PagePaymentOptions;
import org.springframework.social.facebook.api.PageRestaurantServices;
import org.springframework.social.facebook.api.PageRestaurantSpecialties;
import org.springframework.social.facebook.api.Reference;
import org.springframework.social.facebook.api.VoipInfo;
import org.springframework.social.facebook.api.impl.json.FacebookObjectMixin;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class PageMixin
extends FacebookObjectMixin {
    @JsonProperty(value="id")
    String id;
    @JsonProperty(value="about")
    String about;
    @JsonProperty(value="access_token")
    String accessToken;
    @JsonProperty(value="affiliation")
    String affiliation;
    @JsonProperty(value="attire")
    String attire;
    @JsonProperty(value="band_members")
    String bandMembers;
    @JsonProperty(value="best_page")
    Page bestPage;
    @JsonProperty(value="birthday")
    String birthday;
    @JsonProperty(value="booking_agent")
    String bookingAgent;
    @JsonProperty(value="can_post")
    boolean canPost;
    @JsonProperty(value="category")
    String category;
    @JsonProperty(value="category_list")
    List<Reference> categoryList;
    @JsonProperty(value="checkins")
    int checkins;
    @JsonProperty(value="company_overview")
    String companyOverview;
    @JsonProperty(value="cover")
    CoverPhoto cover;
    @JsonProperty(value="current_location")
    String currentLocation;
    @JsonProperty(value="description")
    String description;
    @JsonProperty(value="directed_by")
    String directedBy;
    @JsonProperty(value="founded")
    String founded;
    @JsonProperty(value="general_info")
    String generalInfo;
    @JsonProperty(value="general_manager")
    String generalManager;
    @JsonProperty(value="global_brand_page_name")
    String globalBrandPageName;
    @JsonProperty(value="has_added_app")
    boolean hasAddedApp;
    @JsonProperty(value="hometown")
    String hometown;
    @JsonProperty(value="hours")
    Map<String, String> hours;
    @JsonProperty(value="is_community_page")
    boolean isCommunityPage;
    @JsonProperty(value="is_permanently_closed")
    boolean isPermanentlyClosed;
    @JsonProperty(value="is_published")
    boolean isPublished;
    @JsonProperty(value="is_unclaimed")
    boolean isUnclaimed;
    @JsonProperty(value="likes")
    int likes;
    @JsonProperty(value="link")
    String link;
    @JsonProperty(value="location")
    @JsonDeserialize(using=LocationDeserializer.class)
    Location location;
    @JsonProperty(value="mission")
    String mission;
    @JsonProperty(value="name")
    String name;
    @JsonProperty(value="parking")
    PageParking parking;
    @JsonProperty(value="phone")
    String phone;
    @JsonProperty(value="press_contact")
    String pressContact;
    @JsonProperty(value="price_range")
    @JsonDeserialize(using=PriceRangeDeserializer.class)
    Page.PriceRange priceRange;
    @JsonProperty(value="products")
    String products;
    @JsonProperty(value="restaurant_specialties")
    PageRestaurantSpecialties restaurantSpecialties;
    @JsonProperty(value="talking_about_count")
    int talkingAboutCount;
    @JsonProperty(value="website")
    String website;
    @JsonProperty(value="were_here_count")
    int wereHereCount;
    @JsonProperty(value="app_id")
    String appId;
    @JsonProperty(value="artists_we_like")
    String artistsWeLike;
    @JsonProperty(value="awards")
    String awards;
    @JsonProperty(value="band_interests")
    String bandInterests;
    @JsonProperty(value="bio")
    String bio;
    @JsonProperty(value="built")
    String built;
    @JsonProperty(value="business")
    Reference business;
    @JsonProperty(value="contact_adress")
    MailingAddress contactAddress;
    @JsonProperty(value="country_page_likes")
    int countryPageLikes;
    @JsonProperty(value="culinary_team")
    String culinaryTeam;
    @JsonProperty(value="description_html")
    String descriptionHtml;
    @JsonProperty(value="emails")
    List<String> emails;
    @JsonProperty(value="engagement")
    Engagement engagement;
    @JsonProperty(value="features")
    String features;
    @JsonProperty(value="food_styles")
    String foodStyles;
    @JsonProperty(value="genre")
    String genre;
    @JsonProperty(value="global_brand_parent_page")
    Reference globalBrandParentPage;
    @JsonProperty(value="global_brand_root_id")
    String globalBrandRootId;
    @JsonProperty(value="influences")
    String influences;
    @JsonProperty(value="is_verified")
    boolean isVerified;
    @JsonProperty(value="members")
    String members;
    @JsonProperty(value="mpg")
    String mpg;
    @JsonProperty(value="network")
    String network;
    @JsonProperty(value="new_like_count")
    int newLikeCount;
    @JsonProperty(value="offer_eligible")
    boolean offerEligible;
    @JsonProperty(value="parent_page")
    Reference parentPage;
    @JsonProperty(value="payment_options")
    PagePaymentOptions paymentOptions;
    @JsonProperty(value="personal_info")
    String personalInfo;
    @JsonProperty(value="personal_interests")
    String personalInterests;
    @JsonProperty(value="pharma_safety_info")
    String pharmaSafetyInfo;
    @JsonProperty(value="plot_outline")
    String plotOutline;
    @JsonProperty(value="produced_by")
    String producedBy;
    @JsonProperty(value="promotion_eligible")
    boolean promotionEligible;
    @JsonProperty(value="promotion_ineligible_reason")
    String promotionIneligibleReason;
    @JsonProperty(value="public_transit")
    String publicTransit;
    @JsonProperty(value="record_label")
    String recordLabel;
    @JsonProperty(value="release_date")
    String releaseDate;
    @JsonProperty(value="restaurant_services")
    PageRestaurantServices restaurantServices;
    @JsonProperty(value="schedule")
    String schedule;
    @JsonProperty(value="screenplay_by")
    String screenplayBy;
    @JsonProperty(value="season")
    String season;
    @JsonProperty(value="starring")
    String starring;
    @JsonProperty(value="store_number")
    int storeNumber;
    @JsonProperty(value="studio")
    String studio;
    @JsonProperty(value="unread_message_count")
    int unreadMessageCount;
    @JsonProperty(value="unread_notif_count")
    int unreadNotifCount;
    @JsonProperty(value="unseen_message_count")
    int unseenMessageCount;
    @JsonProperty(value="username")
    String username;
    @JsonProperty(value="voip_info")
    VoipInfo voipInfo;
    @JsonProperty(value="written_by")
    String writtenBy;

    PageMixin() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PriceRangeDeserializer
    extends JsonDeserializer<Page.PriceRange> {
        PriceRangeDeserializer() {
        }

        public Page.PriceRange deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String priceRangeText = jp.getText();
            if (priceRangeText.startsWith("$")) {
                String[] split = priceRangeText.split("\\s");
                return Page.PriceRange.valueOf(split[0]);
            }
            return Page.PriceRange.UNSPECIFIED;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LocationDeserializer
    extends JsonDeserializer<Location> {
        LocationDeserializer() {
        }

        public Location deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
                return (Location)jp.readValueAs(Location.class);
            }
            return new Location(jp.getText());
        }
    }
}

