/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.annotation.support;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.converter.ByteArrayMessageConverter;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;
import org.springframework.messaging.core.AbstractMessageSendingTemplate;
import org.springframework.messaging.handler.DestinationPatternsMessageCondition;
import org.springframework.messaging.handler.HandlerMethod;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.support.AnnotationExceptionHandlerMethodResolver;
import org.springframework.messaging.handler.annotation.support.DestinationVariableMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.HeaderMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.HeadersMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.MessageMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.PayloadArgumentResolver;
import org.springframework.messaging.handler.invocation.AbstractExceptionHandlerMethodResolver;
import org.springframework.messaging.handler.invocation.AbstractMethodMessageHandler;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.HandlerMethodReturnValueHandler;
import org.springframework.messaging.simp.SimpAttributesContextHolder;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageMappingInfo;
import org.springframework.messaging.simp.SimpMessageSendingOperations;
import org.springframework.messaging.simp.SimpMessageTypeMessageCondition;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.messaging.simp.annotation.SubscribeMapping;
import org.springframework.messaging.simp.annotation.support.PrincipalMethodArgumentResolver;
import org.springframework.messaging.simp.annotation.support.SendToMethodReturnValueHandler;
import org.springframework.messaging.simp.annotation.support.SubscriptionMethodReturnValueHandler;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.messaging.support.MessageHeaderInitializer;
import org.springframework.stereotype.Controller;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.PathMatcher;
import org.springframework.validation.Validator;

public class SimpAnnotationMethodMessageHandler
extends AbstractMethodMessageHandler<SimpMessageMappingInfo>
implements SmartLifecycle {
    private final SubscribableChannel clientInboundChannel;
    private final SimpMessageSendingOperations clientMessagingTemplate;
    private final SimpMessageSendingOperations brokerTemplate;
    private MessageConverter messageConverter;
    private ConversionService conversionService = new DefaultFormattingConversionService();
    private PathMatcher pathMatcher = new AntPathMatcher();
    private boolean slashPathSeparator = true;
    private Validator validator;
    private MessageHeaderInitializer headerInitializer;
    private final Object lifecycleMonitor = new Object();
    private volatile boolean running = false;

    public SimpAnnotationMethodMessageHandler(SubscribableChannel clientInboundChannel, MessageChannel clientOutboundChannel, SimpMessageSendingOperations brokerTemplate) {
        Assert.notNull((Object)clientInboundChannel, (String)"clientInboundChannel must not be null");
        Assert.notNull((Object)clientOutboundChannel, (String)"clientOutboundChannel must not be null");
        Assert.notNull((Object)brokerTemplate, (String)"brokerTemplate must not be null");
        this.clientInboundChannel = clientInboundChannel;
        this.clientMessagingTemplate = new SimpMessagingTemplate(clientOutboundChannel);
        this.brokerTemplate = brokerTemplate;
        ArrayList<MessageConverter> converters = new ArrayList<MessageConverter>();
        converters.add(new StringMessageConverter());
        converters.add(new ByteArrayMessageConverter());
        this.messageConverter = new CompositeMessageConverter(converters);
    }

    @Override
    public void setDestinationPrefixes(Collection<String> prefixes) {
        super.setDestinationPrefixes(SimpAnnotationMethodMessageHandler.appendSlashes(prefixes));
    }

    private static Collection<String> appendSlashes(Collection<String> prefixes) {
        if (CollectionUtils.isEmpty(prefixes)) {
            return prefixes;
        }
        ArrayList<String> result = new ArrayList<String>(prefixes.size());
        for (String prefix : prefixes) {
            if (!prefix.endsWith("/")) {
                prefix = prefix + "/";
            }
            result.add(prefix);
        }
        return result;
    }

    public void setMessageConverter(MessageConverter converter) {
        this.messageConverter = converter;
        if (converter != null) {
            ((AbstractMessageSendingTemplate)((Object)this.clientMessagingTemplate)).setMessageConverter(converter);
        }
    }

    public MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        Assert.notNull((Object)pathMatcher, (String)"PathMatcher must not be null");
        this.pathMatcher = pathMatcher;
        this.slashPathSeparator = this.pathMatcher.combine("a", "a").equals("a/a");
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public void setHeaderInitializer(MessageHeaderInitializer headerInitializer) {
        this.headerInitializer = headerInitializer;
    }

    public MessageHeaderInitializer getHeaderInitializer() {
        return this.headerInitializer;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRunning() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.running;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.clientInboundChannel.subscribe(this);
            this.running = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.running = false;
            this.clientInboundChannel.unsubscribe(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(Runnable callback) {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.stop();
            callback.run();
        }
    }

    @Override
    protected List<HandlerMethodArgumentResolver> initArgumentResolvers() {
        ConfigurableListableBeanFactory beanFactory = ClassUtils.isAssignableValue(ConfigurableApplicationContext.class, (Object)this.getApplicationContext()) ? ((ConfigurableApplicationContext)this.getApplicationContext()).getBeanFactory() : null;
        ArrayList<HandlerMethodArgumentResolver> resolvers = new ArrayList<HandlerMethodArgumentResolver>();
        resolvers.add(new HeaderMethodArgumentResolver(this.conversionService, (ConfigurableBeanFactory)beanFactory));
        resolvers.add(new HeadersMethodArgumentResolver());
        resolvers.add(new DestinationVariableMethodArgumentResolver(this.conversionService));
        resolvers.add(new PrincipalMethodArgumentResolver());
        resolvers.add(new MessageMethodArgumentResolver());
        resolvers.addAll(this.getCustomArgumentResolvers());
        resolvers.add(new PayloadArgumentResolver(this.messageConverter, this.validator));
        return resolvers;
    }

    @Override
    protected List<? extends HandlerMethodReturnValueHandler> initReturnValueHandlers() {
        ArrayList<HandlerMethodReturnValueHandler> handlers = new ArrayList<HandlerMethodReturnValueHandler>();
        SendToMethodReturnValueHandler sth = new SendToMethodReturnValueHandler(this.brokerTemplate, true);
        sth.setHeaderInitializer(this.headerInitializer);
        handlers.add(sth);
        SubscriptionMethodReturnValueHandler sh = new SubscriptionMethodReturnValueHandler(this.clientMessagingTemplate);
        sh.setHeaderInitializer(this.headerInitializer);
        handlers.add(sh);
        handlers.addAll(this.getCustomReturnValueHandlers());
        sth = new SendToMethodReturnValueHandler(this.brokerTemplate, false);
        sth.setHeaderInitializer(this.headerInitializer);
        handlers.add(sth);
        return handlers;
    }

    @Override
    protected boolean isHandler(Class<?> beanType) {
        return AnnotationUtils.findAnnotation(beanType, Controller.class) != null;
    }

    @Override
    protected SimpMessageMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        MessageMapping typeAnnotation = (MessageMapping)AnnotationUtils.findAnnotation(handlerType, MessageMapping.class);
        MessageMapping messageAnnot = (MessageMapping)AnnotationUtils.findAnnotation((Method)method, MessageMapping.class);
        if (messageAnnot != null) {
            SimpMessageMappingInfo result = this.createMessageMappingCondition(messageAnnot);
            if (typeAnnotation != null) {
                result = this.createMessageMappingCondition(typeAnnotation).combine(result);
            }
            return result;
        }
        SubscribeMapping subsribeAnnotation = (SubscribeMapping)AnnotationUtils.findAnnotation((Method)method, SubscribeMapping.class);
        if (subsribeAnnotation != null) {
            SimpMessageMappingInfo result = this.createSubscribeCondition(subsribeAnnotation);
            if (typeAnnotation != null) {
                result = this.createMessageMappingCondition(typeAnnotation).combine(result);
            }
            return result;
        }
        return null;
    }

    private SimpMessageMappingInfo createMessageMappingCondition(MessageMapping annotation) {
        return new SimpMessageMappingInfo(SimpMessageTypeMessageCondition.MESSAGE, new DestinationPatternsMessageCondition(annotation.value(), this.pathMatcher));
    }

    private SimpMessageMappingInfo createSubscribeCondition(SubscribeMapping annotation) {
        return new SimpMessageMappingInfo(SimpMessageTypeMessageCondition.SUBSCRIBE, new DestinationPatternsMessageCondition(annotation.value(), this.pathMatcher));
    }

    @Override
    protected Set<String> getDirectLookupDestinations(SimpMessageMappingInfo mapping) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String pattern : mapping.getDestinationConditions().getPatterns()) {
            if (this.pathMatcher.isPattern(pattern)) continue;
            result.add(pattern);
        }
        return result;
    }

    @Override
    protected String getDestination(Message<?> message) {
        return SimpMessageHeaderAccessor.getDestination(message.getHeaders());
    }

    @Override
    protected String getLookupDestination(String destination) {
        if (destination == null) {
            return null;
        }
        if (CollectionUtils.isEmpty(this.getDestinationPrefixes())) {
            return destination;
        }
        for (String prefix : this.getDestinationPrefixes()) {
            if (!destination.startsWith(prefix)) continue;
            if (this.slashPathSeparator) {
                return destination.substring(prefix.length() - 1);
            }
            return destination.substring(prefix.length());
        }
        return null;
    }

    @Override
    protected SimpMessageMappingInfo getMatchingMapping(SimpMessageMappingInfo mapping, Message<?> message) {
        return mapping.getMatchingCondition((Message)message);
    }

    @Override
    protected Comparator<SimpMessageMappingInfo> getMappingComparator(final Message<?> message) {
        return new Comparator<SimpMessageMappingInfo>(){

            @Override
            public int compare(SimpMessageMappingInfo info1, SimpMessageMappingInfo info2) {
                return info1.compareTo(info2, message);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleMatch(SimpMessageMappingInfo mapping, HandlerMethod handlerMethod, String lookupDestination, Message<?> message) {
        String matchedPattern = mapping.getDestinationConditions().getPatterns().iterator().next();
        Map vars = this.getPathMatcher().extractUriTemplateVariables(matchedPattern, lookupDestination);
        if (!CollectionUtils.isEmpty((Map)vars)) {
            MessageHeaderAccessor accessor = MessageHeaderAccessor.getAccessor(message, MessageHeaderAccessor.class);
            Assert.state((accessor != null && accessor.isMutable() ? 1 : 0) != 0);
            accessor.setHeader(DestinationVariableMethodArgumentResolver.DESTINATION_TEMPLATE_VARIABLES_HEADER, vars);
        }
        try {
            SimpAttributesContextHolder.setAttributesFromMessage(message);
            super.handleMatch(mapping, handlerMethod, lookupDestination, message);
        }
        finally {
            SimpAttributesContextHolder.resetAttributes();
        }
    }

    @Override
    protected AbstractExceptionHandlerMethodResolver createExceptionHandlerMethodResolverFor(Class<?> beanType) {
        return new AnnotationExceptionHandlerMethodResolver(beanType);
    }
}

